/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.input.ComboLookup;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.misc.DisplayValue;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.WrappedException;

public class ControlFactoryRelationCombo
implements PropertyControlFactory {
    @Override
    public int accepts(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(ComboLookup.class)) {
            return -1;
        }
        if (pmm.getRelationType() != PropertyRelationType.UP) {
            return 0;
        }
        if ("comboLookup".equals(pmm.getComponentTypeHint())) {
            return 10;
        }
        if (pmm.getComponentTypeHint() == null && "comboLookup".equals(pmm.getClassModel().getComponentTypeHint())) {
            return 10;
        }
        return 2;
    }

    @Override
    @Nonnull
    public <T> ControlFactoryResult createControl(@Nonnull PropertyMetaModel<T> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (!editable && controlClass == null) {
            DisplayValue dv = new DisplayValue(pmm.getActualType());
            dv.defineFrom(pmm);
            if (dv.getConverter() == null && dv.getRenderer() == null) {
                INodeContentRenderer<?> r = MetaManager.createDefaultComboRenderer(pmm, null);
                dv.setRenderer(r);
            }
            return new ControlFactoryResult(dv);
        }
        try {
            ComboLookup<T> co = ComboLookup.createLookup(pmm);
            co.setDisabled(!editable);
            return new ControlFactoryResult(co);
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }
}

