/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.controlfactory.RelationLookupDisplayInput;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.input.LookupInput;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyRelationType;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.server.DomApplication;

public class ControlFactoryRelationLookup
implements PropertyControlFactory {
    @Override
    public int accepts(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(LookupInput.class)) {
            return -1;
        }
        if (pmm.getRelationType() != PropertyRelationType.UP) {
            return 0;
        }
        if ("lookupInput".equals(pmm.getComponentTypeHint())) {
            return 10;
        }
        return 3;
    }

    @Override
    @Nonnull
    public <T> ControlFactoryResult createControl(@Nonnull PropertyMetaModel<T> pmm, boolean editable, @Nullable Class<?> controlClass) {
        IQueryManipulator<Object> qm;
        String s;
        LookupInput<T> li = editable ? new LookupInput<T>(pmm.getActualType(), pmm.getValueModel()) : new RelationLookupDisplayInput<T>(pmm.getActualType(), pmm.getValueModel());
        li.setReadOnly(!editable);
        List<SearchPropertyMetaModel> sp = pmm.getLookupFieldSearchProperties();
        if (sp.size() == 0 && (sp = li.getMetaModel().getSearchProperties()).size() > 0) {
            li.setSearchProperties(sp);
        }
        if (pmm.getLookupSelectedRenderer() != null) {
            li.setValueRenderer(DomApplication.get().createInstance(pmm.getLookupSelectedRenderer(), new Object[0]));
        } else {
            ClassMetaModel cmm = MetaManager.findClassMeta(pmm.getActualType());
            if (cmm.getLookupSelectedRenderer() != null) {
                li.setValueRenderer(DomApplication.get().createInstance(cmm.getLookupSelectedRenderer(), new Object[0]));
            }
        }
        if (pmm.isRequired()) {
            li.setMandatory(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            li.setTitle(s);
        }
        if (null == (qm = pmm.getQueryManipulator())) {
            qm = pmm.getClassModel().getQueryManipulator();
        }
        if (null != qm) {
            li.setQueryManipulator(qm);
        }
        return new ControlFactoryResult(li);
    }
}

