/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.controlfactory;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlFactoryResult;
import to.etc.domui.component.controlfactory.PropertyControlFactory;
import to.etc.domui.component.controlfactory.TextDisplayArea;
import to.etc.domui.component.meta.MetaUtils;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.server.DomApplication;

public class ControlFactoryTextArea
implements PropertyControlFactory {
    @Override
    public int accepts(@Nonnull PropertyMetaModel<?> pmm, boolean editable, @Nullable Class<?> controlClass) {
        if (controlClass != null && !controlClass.isAssignableFrom(TextArea.class)) {
            return -1;
        }
        String cth = pmm.getComponentTypeHint();
        if (cth != null && cth.toLowerCase().contains("textarea")) {
            return 10;
        }
        return 0;
    }

    @Override
    @Nonnull
    public <T> ControlFactoryResult createControl(@Nonnull PropertyMetaModel<T> pmm, boolean editable, @Nullable Class<?> controlClass) {
        int length;
        String s;
        String cth;
        TextArea ta;
        TextArea textArea = ta = editable ? new TextArea() : new TextDisplayArea();
        if (!editable) {
            ta.setReadOnly(true);
        }
        if ((cth = pmm.getComponentTypeHint()) != null) {
            String hint = cth.toLowerCase();
            ta.setCols(MetaUtils.parseIntParam(hint, "col", 80));
            ta.setRows(MetaUtils.parseIntParam(hint, "row", 4));
        }
        if (pmm.isRequired()) {
            ta.setMandatory(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            ta.setTitle(s);
        }
        if ((length = pmm.getLength()) > 0) {
            ta.setMaxLength(length);
            ta.setMaxByteLength(DomApplication.getPlatformVarcharByteLimit());
        }
        return new ControlFactoryResult(ta);
    }
}

