/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.delayed;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Pre;
import to.etc.domui.util.Msgs;
import to.etc.util.StringTool;

public abstract class AbstractAsyncRunnable
implements IAsyncRunnable {
    @Nonnull
    private final NodeContainer m_replacedNode;

    public abstract void onCompleted() throws Exception;

    public AbstractAsyncRunnable(@Nonnull NodeContainer replacedNode) {
        this.m_replacedNode = replacedNode;
    }

    @Override
    public void onCompleted(boolean cancelled, @Nullable Exception errorException) throws Exception {
        if (errorException != null) {
            StringBuilder sb = new StringBuilder(8192);
            StringTool.strStacktrace((Appendable)sb, (Throwable)errorException);
            this.addNode(new Pre().add(sb.toString()));
            return;
        }
        if (cancelled) {
            this.addNode(new Pre().add(Msgs.BUNDLE.getString("asynccontainer.cancelled.msg")));
            return;
        }
        this.onCompleted();
    }

    protected void addNode(@Nonnull NodeBase b) {
        if (this.m_replacedNode != this.m_replacedNode.getPage().getBody()) {
            this.m_replacedNode.appendAfterMe(b);
        } else {
            this.m_replacedNode.add(new Div(b));
        }
    }
}

