/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.delayed;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.delayed.IActivity;
import to.etc.domui.component.delayed.IAsyncRunnable;
import to.etc.domui.component.delayed.IProgress;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.state.DelayedActivityInfo;
import to.etc.domui.util.Msgs;
import to.etc.util.StringTool;

public class AsyncContainer
extends Div {
    @Nonnull
    private final IAsyncRunnable m_runnable;
    private DelayedActivityInfo m_scheduledActivity;
    private Div m_progress;
    private boolean m_abortable = true;
    private String m_busyMarkerSrc = "THEME/asy-container-busy.gif";

    public AsyncContainer(@Nonnull IAsyncRunnable arunnable) {
        this.m_runnable = arunnable;
    }

    public AsyncContainer(final @Nonnull IActivity activity) {
        this.m_runnable = new IAsyncRunnable(){
            @Nullable
            private Div m_result;

            @Override
            public void run(@Nonnull IProgress p) throws Exception {
                this.setResult(activity.run(p));
            }

            private synchronized Div getResult() {
                return this.m_result;
            }

            private synchronized void setResult(Div result) {
                this.m_result = result;
            }

            @Override
            public void onCompleted(boolean cancelled, @Nullable Exception errorException) throws Exception {
                if (errorException != null) {
                    errorException.printStackTrace();
                    StringBuilder sb = new StringBuilder(8192);
                    StringTool.strStacktrace((Appendable)sb, (Throwable)errorException);
                    String s = sb.toString();
                    s = s.replace("\n", "<br/>\n");
                    MsgBox.error((NodeBase)AsyncContainer.this.getParent(), "Exception while creating result for asynchronous task:<br/>" + s);
                    return;
                }
                Div res = this.getResult();
                if (res == null) {
                    if (cancelled) {
                        AsyncContainer.this.setText(Msgs.BUNDLE.getString("asynccontainer.cancelled.msg"));
                    } else {
                        AsyncContainer.this.setText(Msgs.BUNDLE.getString("asynccontainer.no.results.msg"));
                    }
                    return;
                }
                AsyncContainer.this.replaceWith(res);
            }
        };
    }

    @Override
    public void createContent() throws Exception {
        if (this.m_scheduledActivity == null) {
            this.m_scheduledActivity = this.getPage().getConversation().scheduleDelayed(this, this.m_runnable);
        }
        this.setCssClass("ui-asc");
        Img img = new Img();
        img.setSrc(this.getBusyMarkerSrc());
        this.add(img);
        this.m_progress = new Div();
        this.add(this.m_progress);
        if (this.isAbortable()) {
            DefaultButton db = new DefaultButton(Msgs.BUNDLE.getString("lookupform.cancel"), "THEME/btnCancel.png", new IClicked<DefaultButton>(){

                @Override
                public void clicked(@Nonnull DefaultButton b) throws Exception {
                    AsyncContainer.this.cancel();
                    b.setDisabled(true);
                }
            });
            this.add(db);
        }
    }

    void cancel() {
        if (this.m_scheduledActivity != null) {
            this.m_scheduledActivity.cancel();
        }
    }

    public void updateProgress(int pct, String msg) {
        StringBuilder sb = new StringBuilder();
        sb.append(pct);
        sb.append("%");
        if (msg != null) {
            sb.append(' ');
            sb.append(msg);
        } else {
            sb.append(" " + Msgs.BUNDLE.getString("asynccontainer.complete.indicator"));
        }
        this.m_progress.setText(sb.toString());
    }

    public void updateCompleted(DelayedActivityInfo dai) throws Exception {
        try {
            dai.getActivity().onCompleted(dai.getMonitor().isCancelled(), dai.getException());
        }
        finally {
            try {
                this.remove();
            }
            catch (Exception x) {
                System.err.println("Could not remove AsyncContainer: " + x);
                x.printStackTrace();
            }
        }
    }

    public void confirmCancelled() {
        this.setText(Msgs.BUNDLE.getString("asynccontainer.cancelled"));
    }

    public boolean isAbortable() {
        return this.m_abortable;
    }

    public void setAbortable(boolean abortable) {
        this.m_abortable = abortable;
    }

    public String getBusyMarkerSrc() {
        return this.m_busyMarkerSrc;
    }

    public void setBusyMarkerSrc(String busyMarkerSrc) {
        this.m_busyMarkerSrc = busyMarkerSrc;
    }
}

