/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import to.etc.domui.component.dynaima.ChartDimensions;
import to.etc.domui.component.dynaima.ChartField;
import to.etc.domui.component.dynaima.ICharterHelper;
import to.etc.domui.component.dynaima.JGraphChartSource;

public abstract class AbstractCharter
implements ICharterHelper {
    protected JGraphChartSource m_source;
    protected ChartProperties m_properties;
    protected AxisProperties m_axisProperties = new AxisProperties();
    private LegendProperties m_legendProperties;
    protected int m_width = 0;
    protected int m_minheight = 0;
    protected int m_maxheight = 0;
    protected String m_title;
    private List<ChartField> m_chartDataElements;
    private static final Color[] AVAILABLE_PAINTS = new Color[]{new Color(7117290), new Color(16591916), new Color(8198334), new Color(16229121), new Color(706660), new Color(0xFF5500)};

    public AbstractCharter(JGraphChartSource source, ChartDimensions dimensions) {
        this.m_source = source;
        this.m_width = dimensions.getWidth();
        this.m_minheight = dimensions.getMinheight();
        this.m_maxheight = dimensions.getMaxheight();
        this.m_chartDataElements = new ArrayList<ChartField>();
        this.m_legendProperties = new LegendProperties();
        this.m_legendProperties.setNumColumns(2);
        this.m_legendProperties.setFont(new Font("Arial", 0, 10));
        this.m_properties = new ChartProperties();
    }

    public AbstractCharter(JGraphChartSource source, ChartDimensions dimensions, LegendProperties legendProperties, ChartProperties chartProperties) {
        this.m_source = source;
        this.m_width = dimensions.getWidth();
        this.m_minheight = dimensions.getMinheight();
        this.m_maxheight = dimensions.getMaxheight();
        this.m_chartDataElements = new ArrayList<ChartField>();
        this.m_legendProperties = legendProperties;
        this.m_properties = chartProperties;
    }

    @Override
    public void addChartField(ChartField element) {
        this.m_chartDataElements.add(element);
    }

    public double[] getChartDataValues() {
        double[] values = new double[this.m_chartDataElements.size()];
        for (int i = 0; i < this.m_chartDataElements.size(); ++i) {
            values[i] = this.m_chartDataElements.get(i).getValue();
        }
        return values;
    }

    public String[] getChartDataLabels() {
        String[] values = new String[this.m_chartDataElements.size()];
        for (int i = 0; i < this.m_chartDataElements.size(); ++i) {
            values[i] = this.m_chartDataElements.get(i).getShortLabel();
        }
        return values;
    }

    protected Paint[] selectPaints() {
        Paint[] resultSet = new Paint[this.m_chartDataElements.size()];
        for (int i = 0; i < this.m_chartDataElements.size(); ++i) {
            int paintIndex = i % AVAILABLE_PAINTS.length;
            Color paint = AVAILABLE_PAINTS[paintIndex];
            for (int j = 0; j < i / AVAILABLE_PAINTS.length; ++j) {
                paint = paint.darker();
            }
            resultSet[i] = paint;
        }
        return resultSet;
    }

    public LegendProperties getLegendProperties() {
        return this.m_legendProperties;
    }

    public void setLegendProperties(LegendProperties legendProperties) {
        this.m_legendProperties = legendProperties;
    }

    public ChartProperties getProperties() {
        return this.m_properties;
    }
}

