/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.AreaChartProperties;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.types.ChartType;
import to.etc.domui.component.dynaima.ChartDimensions;
import to.etc.domui.component.dynaima.ChartField;
import to.etc.domui.component.dynaima.ICharterHelper;
import to.etc.domui.component.dynaima.JGraphChartSource;

public class AreaCharter
implements ICharterHelper {
    private JGraphChartSource m_source;
    private String m_title;
    private String m_bucketTitle;
    private int m_width;
    private int m_minheight;
    private int m_maxheight;
    private String m_valueTitle;
    private AreaChartProperties m_areaProperties = new AreaChartProperties();
    private ChartProperties m_properties = new ChartProperties();
    private AxisProperties m_axisProperties = new AxisProperties();
    private LegendProperties m_legendProperties = new LegendProperties();
    private Map<Object, BucketData> m_bucketSet = new HashMap<Object, BucketData>();
    private List<DataSet> m_sets = new ArrayList<DataSet>();

    protected AreaCharter(JGraphChartSource source, String title, ChartDimensions chartDimensions, String bucketTitle, String valueTitle) {
        this.m_source = source;
        this.m_title = title;
        this.m_width = chartDimensions.getWidth();
        this.m_minheight = chartDimensions.getMinheight();
        this.m_maxheight = chartDimensions.getMaxheight();
        this.m_bucketTitle = bucketTitle;
        this.m_valueTitle = valueTitle;
    }

    public DataSet addDataSet(Paint paint, String name) {
        DataSet ds = new DataSet(paint, name, this.m_sets.size());
        this.m_sets.add(ds);
        return ds;
    }

    <T extends Comparable<T>> void _add(int index, String bucketlabel, T sortvalue, double value) {
        BucketData bd = this.addBucket(bucketlabel, sortvalue);
        bd.setValue(index, value);
    }

    public BucketData addBucket(String bucketlabel, Object sortvalue) {
        BucketData d = this.m_bucketSet.get(sortvalue);
        if (d == null) {
            d = new BucketData(bucketlabel, sortvalue);
            this.m_bucketSet.put(sortvalue, d);
        }
        return d;
    }

    public List<BucketData> getOrderedBuckets() {
        Collection<BucketData> values = this.m_bucketSet.values();
        ArrayList<BucketData> res = new ArrayList<BucketData>(values);
        Collections.sort(res, new Comparator<BucketData>(){

            @Override
            public int compare(BucketData o1, BucketData o2) {
                Comparable a = (Comparable)o1.getBucketValue();
                Comparable b = (Comparable)o2.getBucketValue();
                return a.compareTo(b);
            }
        });
        return res;
    }

    @Override
    public void finish() throws Exception {
        List<BucketData> list = this.getOrderedBuckets();
        double[][] data = new double[this.m_sets.size()][];
        int i = data.length;
        while (--i >= 0) {
            data[i] = new double[list.size()];
        }
        String[] axislabels = new String[list.size()];
        int bix = 0;
        for (BucketData bd : list) {
            axislabels[bix] = bd.getBucketName();
            for (int i2 = 0; i2 < data.length; ++i2) {
                Double v = bd.getValue(i2);
                if (v == null) continue;
                data[i2][bix] = v;
            }
            ++bix;
        }
        DataSeries ds = new DataSeries(axislabels, this.m_bucketTitle, this.m_valueTitle, this.m_title);
        String[] legends = new String[this.m_sets.size()];
        Paint[] paints = new Paint[this.m_sets.size()];
        int i3 = this.m_sets.size();
        while (--i3 >= 0) {
            legends[i3] = this.m_sets.get(i3).getName();
            paints[i3] = this.m_sets.get(i3).getPaint();
        }
        int legendHeight = Math.round((float)legends.length / 2.0f) * 20 + 8;
        int chartHeight = Math.min(this.m_minheight + legendHeight, this.m_maxheight);
        AxisChartDataSet ads = new AxisChartDataSet((double[][])data, legends, paints, ChartType.AREA, (ChartTypeProperties)this.m_areaProperties);
        ds.addIAxisPlotDataSet((IAxisPlotDataSet)ads);
        AxisChart c = new AxisChart((IAxisDataSeries)ds, this.m_properties, this.m_axisProperties, this.m_legendProperties, this.m_width, chartHeight);
        this.m_source.setChart((Chart)c);
    }

    @Override
    public void addChartField(ChartField element) {
    }

    public class DataSet {
        private String m_name;
        private int m_index;
        private Paint m_paint;

        protected DataSet(Paint paint, String name, int index) {
            this.m_paint = paint;
            this.m_name = name;
            this.m_index = index;
        }

        public <T extends Comparable<T>> void add(String bucketlabel, T sortvalue, double value) {
            AreaCharter.this._add(this.m_index, bucketlabel, sortvalue, value);
        }

        public String getName() {
            return this.m_name;
        }

        public Paint getPaint() {
            return this.m_paint;
        }
    }

    public static class BucketData {
        private String m_bucketName;
        private Object m_bucketValue;
        private List<Double> m_values = new ArrayList<Double>();

        protected BucketData(String bucketName, Object bucketValue) {
            this.m_bucketName = bucketName;
            this.m_bucketValue = bucketValue;
        }

        public void setValue(int index, double val) {
            while (this.m_values.size() <= index) {
                this.m_values.add(null);
            }
            this.m_values.set(index, val);
        }

        public String getBucketName() {
            return this.m_bucketName;
        }

        public Object getBucketValue() {
            return this.m_bucketValue;
        }

        public Double getValue(int ix) {
            if (ix >= this.m_values.size()) {
                return null;
            }
            return this.m_values.get(ix);
        }
    }
}

