/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisDataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.ClusteredBarChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.util.ChartStroke;
import org.jCharts.types.ChartType;
import to.etc.domui.component.dynaima.AbstractCharter;
import to.etc.domui.component.dynaima.ChartDimensions;
import to.etc.domui.component.dynaima.JGraphChartSource;

public class BarCharter
extends AbstractCharter {
    private ClusteredBarChartProperties m_barChartProperties;
    private String m_bucketTitle;
    private String m_valueTitle;

    public BarCharter(JGraphChartSource source, ChartDimensions chartDimensions, String bucketTitle, String valueTitle) {
        super(source, chartDimensions);
        this.m_bucketTitle = bucketTitle;
        this.m_valueTitle = valueTitle;
        this.m_barChartProperties = new ClusteredBarChartProperties();
        this.m_barChartProperties.setBarOutlineStroke(new ChartStroke((Stroke)new BasicStroke(0.8f), (Paint)new Color(Integer.parseInt("5C5C5C", 16))));
    }

    public BarCharter(JGraphChartSource source, BarCharterParameters barCharterParameters, ChartDimensions chartDimensions, String bucketTitle, String valueTitle) {
        super(source, chartDimensions, barCharterParameters.m_isLegendProperties, barCharterParameters.m_isChartProperties);
        this.m_barChartProperties = barCharterParameters.m_isBarChartProperties;
        this.m_bucketTitle = bucketTitle;
        this.m_valueTitle = valueTitle;
    }

    @Override
    public void finish() throws Exception {
        double[][] data = this.getChartDataAsMatrix();
        String[] axisLabels = new String[]{" "};
        DataSeries ds = new DataSeries(axisLabels, this.m_bucketTitle, this.m_valueTitle, null);
        String[] cdl = this.getChartDataLabels();
        double fontHeight = this.getLegendProperties().getFont().getStringBounds(cdl[0], new FontRenderContext(null, false, false)).getHeight();
        int borders = 15;
        int legendHeight = 15 + Math.round((float)((double)Math.round((float)cdl.length / (float)this.getLegendProperties().getNumColumns()) * fontHeight));
        int chartHeight = Math.min(this.m_minheight + legendHeight, this.m_maxheight);
        AxisChartDataSet ads = new AxisChartDataSet(data, cdl, this.selectPaints(), ChartType.BAR_CLUSTERED, (ChartTypeProperties)this.m_barChartProperties);
        ds.addIAxisPlotDataSet((IAxisPlotDataSet)ads);
        AxisChart c = new AxisChart((IAxisDataSeries)ds, this.getProperties(), this.m_axisProperties, this.getLegendProperties(), this.m_width, chartHeight);
        this.m_source.setChart((Chart)c);
    }

    private double[][] getChartDataAsMatrix() {
        double[] original = this.getChartDataValues();
        double[][] result = new double[original.length][1];
        for (int i = 0; i < original.length; ++i) {
            result[i][0] = original[i];
        }
        return result;
    }

    public class BarCharterParameters {
        private LegendProperties m_isLegendProperties;
        private ChartProperties m_isChartProperties;
        private ClusteredBarChartProperties m_isBarChartProperties;

        public BarCharterParameters(LegendProperties legendProperties, ChartProperties chartProperties, ClusteredBarChartProperties barChartProperties) {
            this.m_isLegendProperties = legendProperties;
            this.m_isChartProperties = chartProperties;
            this.m_isBarChartProperties = barChartProperties;
        }
    }
}

