/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.text.DecimalFormat;
import java.util.Comparator;
import javax.annotation.Nonnull;
import to.etc.domui.util.DomUtil;

public final class ChartField {
    public static final Comparator<ChartField> COMPARATOR_BY_VALUE = new Comparator<ChartField>(){

        @Override
        public int compare(ChartField o1, ChartField o2) {
            return Double.compare(o1.getValue(), o2.getValue());
        }
    };
    public static final Comparator<ChartField> COMPARATOR_BY_LABEL = new Comparator<ChartField>(){

        @Override
        public int compare(ChartField o1, ChartField o2) {
            return o1.getLabel().compareTo(o2.getLabel());
        }
    };
    private static final int VALUE_EXTRA_CHARACTERS = 3;
    private static final int LABEL_LIMIT = 27;
    private final double m_value;
    private final String m_label;

    public ChartField(double value, @Nonnull String label) {
        if (label == null) {
            throw new IllegalArgumentException("ChartField.label cannot be null");
        }
        this.m_value = value;
        this.m_label = label;
    }

    public double getValue() {
        return this.m_value;
    }

    @Nonnull
    public String getLabel() {
        return this.m_label;
    }

    public String getShortLabel() {
        String value = "[" + new DecimalFormat("#####,##0.##").format(this.m_value) + "] ";
        String label = DomUtil.isBlank(this.m_label) || this.m_label.length() < 27 - value.length() ? this.m_label : this.m_label.substring(0, 24 - value.length()) + "...";
        return value + label;
    }

    public String toString() {
        return "Label: " + this.m_label + " Value: " + this.m_value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_label == null ? 0 : this.m_label.hashCode());
        long temp = Double.doubleToLongBits(this.m_value);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChartField other = (ChartField)obj;
        if (this.m_label == null ? other.m_label != null : !this.m_label.equals(other.m_label)) {
            return false;
        }
        return Double.doubleToLongBits(this.m_value) == Double.doubleToLongBits(other.m_value);
    }
}

