/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.io.OutputStream;
import to.etc.domui.component.dynaima.DynaImaPart;
import to.etc.domui.component.dynaima.IBufferedImageSource;
import to.etc.domui.component.dynaima.IStreamingImageSource;
import to.etc.domui.dom.html.Img;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.state.UIContext;
import to.etc.sjit.ImaTool;
import to.etc.util.ByteBufferOutputStream;
import to.etc.util.FileTool;

public class DynaIma
extends Img {
    private IStreamingImageSource m_streamingSource;
    private IBufferedImageSource m_bufferedSource;
    private BufferedImage m_bufferedImage;
    private String m_cachedMime;
    private int m_cachedSize;
    private byte[][] m_cachedData;
    private long m_changeTag = System.nanoTime();

    public synchronized IStreamingImageSource getStreamingSource() {
        return this.m_streamingSource;
    }

    public synchronized void setStreamingSource(IStreamingImageSource streamingSource) {
        this.m_streamingSource = streamingSource;
        this.m_bufferedSource = null;
        this.m_bufferedImage = null;
        this.updateURL();
    }

    public synchronized IBufferedImageSource getBufferedSource() {
        return this.m_bufferedSource;
    }

    public synchronized void setBufferedSource(IBufferedImageSource bufferedSource) {
        this.m_bufferedImage = null;
        this.m_bufferedSource = bufferedSource;
        this.m_streamingSource = null;
        this.updateURL();
    }

    public synchronized void setBufferedImage(BufferedImage bufferedImage, String outputMime) {
        this.m_bufferedImage = bufferedImage;
        this.m_bufferedSource = null;
        this.m_streamingSource = null;
        this.m_cachedMime = outputMime;
        this.updateURL();
    }

    private synchronized void updateURL() {
        this.m_cachedData = null;
        StringBuilder sb = new StringBuilder(256);
        ComponentPartRenderer.appendComponentURL(sb, DynaImaPart.class, this, UIContext.getRequestContext());
        sb.append("?tag=");
        sb.append(++this.m_changeTag);
        this.setSrc(sb.toString());
    }

    synchronized String getCachedMime() {
        return this.m_cachedMime;
    }

    int getCachedSize() {
        return this.m_cachedSize;
    }

    void setCachedSize(int cachedSize) {
        this.m_cachedSize = cachedSize;
    }

    synchronized byte[][] getCachedData() {
        return this.m_cachedData;
    }

    synchronized void setCachedData(byte[][] cachedData) {
        this.m_cachedData = cachedData;
    }

    synchronized void initializeCached() throws Exception {
        if (this.m_cachedData != null) {
            return;
        }
        if (this.m_bufferedSource != null) {
            this.m_bufferedImage = this.m_bufferedSource.getImage();
            this.m_cachedMime = this.m_bufferedSource.getMimeType();
        }
        if (this.m_bufferedImage != null) {
            String mime = this.m_cachedMime;
            if (mime == null || mime.trim().length() == 0) {
                mime = "image/jpeg";
            }
            ByteBufferOutputStream bbos = new ByteBufferOutputStream(32768);
            ImaTool.saveImageByMime((OutputStream)bbos, (BufferedImage)this.m_bufferedImage, (String)mime);
            bbos.close();
            this.m_cachedData = bbos.getBuffers();
            return;
        }
        if (this.m_streamingSource != null) {
            this.m_cachedMime = this.m_streamingSource.getMimeType();
            this.m_cachedSize = this.m_streamingSource.getSize();
            InputStream is = this.m_streamingSource.getInputStream();
            try {
                this.m_cachedData = FileTool.loadByteBuffers((InputStream)is);
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception exception) {}
            }
            return;
        }
        this.m_cachedData = null;
    }
}

