/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.io.OutputStream;
import javax.annotation.Nonnull;
import to.etc.domui.component.dynaima.DynaIma;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.DomApplication;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.server.parts.IUnbufferedPartFactory;
import to.etc.domui.trouble.ThingyNotFoundException;
import to.etc.util.FileTool;

public class DynaImaPart
implements IUnbufferedPartFactory {
    @Override
    public void generate(@Nonnull DomApplication app, @Nonnull String rurl, @Nonnull RequestContextImpl param) throws Exception {
        DynaRenderer cpr = new DynaRenderer();
        cpr.generate(app, param, rurl);
    }

    public static class DynaRenderer
    extends ComponentPartRenderer {
        private DynaIma m_ima;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void generate(DomApplication app, RequestContextImpl param, String rurl) throws Exception {
            byte[][] data;
            int size;
            String mime;
            this.initialize(app, param, rurl);
            if (this.getArgs().length != 3) {
                throw new IllegalStateException("Invalid input URL '" + rurl + "': must be in format cid/pageclass/componentID");
            }
            if (!(this.getComponent() instanceof DynaIma)) {
                throw new ThingyNotFoundException("The component " + this.getComponent().getActualID() + " on page " + this.getPage().getBody() + " is not an HtmlEditor instance");
            }
            DynaIma dynaIma = this.m_ima = (DynaIma)this.getComponent();
            synchronized (dynaIma) {
                if (this.m_ima.getCachedData() == null) {
                    this.m_ima.initializeCached();
                }
                mime = this.m_ima.getCachedMime();
                size = this.m_ima.getCachedSize();
                data = this.m_ima.getCachedData();
            }
            if (data == null) {
                throw new ThingyNotFoundException("No image in " + rurl);
            }
            OutputStream os = param.getRequestResponse().getOutputStream(mime, null, size);
            FileTool.save((OutputStream)os, (byte[][])data);
        }
    }
}

