/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import org.jCharts.Chart;
import to.etc.domui.component.dynaima.AreaCharter;
import to.etc.domui.component.dynaima.BarCharter;
import to.etc.domui.component.dynaima.ChartDimensions;
import to.etc.domui.component.dynaima.IBufferedImageSource;
import to.etc.domui.component.dynaima.ICharterHelper;
import to.etc.domui.component.dynaima.PieCharter;
import to.etc.sjit.ImaTool;

public class JGraphChartSource
implements IBufferedImageSource {
    private Chart m_chart;
    private ICharterHelper m_helper;

    @Override
    public String getMimeType() {
        return "image/png";
    }

    void setChart(Chart c) {
        this.m_chart = c;
    }

    @Override
    public BufferedImage getImage() throws Exception {
        try {
            this.createGraph();
        }
        finally {
            this.close();
        }
        if (this.m_helper != null) {
            this.m_helper.finish();
            this.m_helper = null;
        }
        System.out.println("DYNAIMA: Generating jGraph graph");
        BufferedImage bufferedImage = null;
        if (this.m_chart.getGenerateImageMapFlag()) {
            bufferedImage = this.m_chart.getBufferedImage();
        } else {
            bufferedImage = new BufferedImage(this.m_chart.getImageWidth(), this.m_chart.getImageHeight(), 1);
            Graphics2D chartImage = bufferedImage.createGraphics();
            InputStream inputStream = JGraphChartSource.class.getResourceAsStream("glossy-chart.png");
            BufferedImage glossyOverlay = ImaTool.loadPNG((InputStream)inputStream);
            this.m_chart.setGraphics2D(chartImage);
            this.m_chart.render();
            chartImage.drawImage(glossyOverlay, null, 0, 0);
        }
        return bufferedImage;
    }

    public void createGraph() throws Exception {
    }

    public void close() {
    }

    public PieCharter createPieChart(ChartDimensions chartDimensions, PieCharter.PieCharterProperties pieChartProperties) {
        PieCharter c = new PieCharter(this, chartDimensions, pieChartProperties);
        this.m_helper = c;
        return c;
    }

    public PieCharter createPieChart(ChartDimensions chartDimensions) {
        PieCharter c = new PieCharter(this, chartDimensions);
        this.m_helper = c;
        return c;
    }

    public AreaCharter createAreaChart(ChartDimensions chartDimensions, String title, String buckettitle, String valuetitle) {
        AreaCharter c = new AreaCharter(this, title, chartDimensions, buckettitle, valuetitle);
        this.m_helper = c;
        return c;
    }

    public BarCharter createBarChart(ChartDimensions chartDimensions, String buckettitle, String valuetitle) {
        BarCharter c = new BarCharter(this, chartDimensions, buckettitle, valuetitle);
        this.m_helper = c;
        return c;
    }

    public BarCharter createBarChart(ChartDimensions chartDimensions, BarCharter.BarCharterParameters barCharterProperties, String buckettitle, String valuetitle) {
        BarCharter c = new BarCharter(this, barCharterProperties, chartDimensions, buckettitle, valuetitle);
        this.m_helper = c;
        return c;
    }
}

