/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.dynaima;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import org.jCharts.Chart;
import org.jCharts.chartData.PieChartDataSet;
import org.jCharts.chartData.interfaces.IPieChartDataSet;
import org.jCharts.nonAxisChart.PieChart2D;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PieChart2DProperties;
import to.etc.domui.component.dynaima.AbstractCharter;
import to.etc.domui.component.dynaima.ChartDimensions;
import to.etc.domui.component.dynaima.JGraphChartSource;

public class PieCharter
extends AbstractCharter {
    private PieChart2DProperties m_pieChartProperties;

    protected PieCharter(JGraphChartSource source, ChartDimensions chartDimensions) {
        super(source, chartDimensions);
        this.m_pieChartProperties = new PieChart2DProperties();
        this.m_pieChartProperties.setBorderPaint((Paint)new Color(Integer.parseInt("5C5C5C", 16)));
        this.m_pieChartProperties.setBorderStroke((Stroke)new BasicStroke(0.8f));
    }

    protected PieCharter(JGraphChartSource source, ChartDimensions chartDimensions, PieCharterProperties pieCharterProperties) {
        super(source, chartDimensions, pieCharterProperties.m_legendProperties, pieCharterProperties.m_chartProperties);
        this.m_pieChartProperties = pieCharterProperties.m_pieChart2DProperties;
    }

    @Override
    public void finish() throws Exception {
        PieChartDataSet pds = new PieChartDataSet(null, this.getChartDataValues(), this.getChartDataLabels(), this.selectPaints(), this.m_pieChartProperties);
        double fontHeight = this.getLegendProperties().getFont().getStringBounds(this.getChartDataLabels()[0], new FontRenderContext(null, false, false)).getHeight();
        int borders = 15;
        int legendHeight = 15 + Math.round((float)((double)Math.round((float)this.getChartDataLabels().length / (float)this.getLegendProperties().getNumColumns()) * fontHeight));
        int chartHeight = Math.min(this.m_minheight + legendHeight, this.m_maxheight);
        ChartProperties chartProperties = new ChartProperties();
        PieChart2D p2d = new PieChart2D((IPieChartDataSet)pds, this.getLegendProperties(), chartProperties, this.m_width, chartHeight);
        this.m_source.setChart((Chart)p2d);
    }

    public class PieCharterProperties {
        private LegendProperties m_legendProperties;
        private ChartProperties m_chartProperties;
        private PieChart2DProperties m_pieChart2DProperties;

        public PieCharterProperties(LegendProperties legendProperties, ChartProperties chartProperties, PieChart2DProperties pieChartProperties) {
            this.m_legendProperties = legendProperties;
            this.m_chartProperties = chartProperties;
            this.m_pieChart2DProperties = pieChartProperties;
        }
    }
}

