/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.experimental;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.experimental.DataTableRow;
import to.etc.domui.component.experimental.TableRowSet;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.misc.MiniLogger;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.IAcceptable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ISelectableTableComponent;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.ISelectionModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.PageableTabularComponentBase;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.ClickInfo;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClickBase;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IClicked2;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.dom.html.THead;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TextNode;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.JavascriptUtil;
import to.etc.domui.util.Msgs;

public final class MultiRowDataTable<T>
extends PageableTabularComponentBase<T>
implements ISelectionListener<T>,
ISelectableTableComponent<T> {
    private MiniLogger m_ml = new MiniLogger(40);
    private Table m_table = new Table();
    private IRowRenderer<T> m_rowRenderer;
    private int m_pageSize;
    private TBody m_dataBody;
    private Div m_errorDiv;
    private final List<TableRowSet<T>> m_visibleItemList = new ArrayList<TableRowSet<T>>();
    private boolean m_multiSelectMode;
    private int m_lastSelectionLocation = -1;
    @Nullable
    private NodeBase m_emptyMessage;
    private boolean m_displayReadonlySelection = true;
    private boolean m_showHeaderAlways;
    @Nonnull
    private final IClicked<TH> m_headerSelectClickHandler = new IClicked<TH>(){

        @Override
        public void clicked(@Nonnull TH clickednode) throws Exception {
            if (MultiRowDataTable.this.isDisabled()) {
                return;
            }
            ISelectionModel sm = MultiRowDataTable.this.getSelectionModel();
            if (null == sm) {
                return;
            }
            int ct = sm.getSelectionCount();
            if (0 == ct && sm.isMultiSelect()) {
                sm.selectAll(MultiRowDataTable.this.getModel());
            } else {
                sm.clearSelection();
            }
        }
    };

    public MultiRowDataTable(@Nonnull ITableModel<T> m, @Nonnull IRowRenderer<T> r) {
        super(m);
        this.m_rowRenderer = r;
    }

    public MultiRowDataTable(@Nonnull IRowRenderer<T> r) {
        this.m_rowRenderer = r;
    }

    public MultiRowDataTable(@Nonnull ITableModel<T> m) {
        super(m);
    }

    public MultiRowDataTable() {
    }

    private void updateBodyClipboardSelection() {
        TBody dataBody = this.m_dataBody;
        if (null == dataBody) {
            return;
        }
        if (this.isDisableClipboardSelection()) {
            this.appendJavascript(JavascriptUtil.disableSelection(dataBody));
        }
    }

    @Override
    public void createContent() throws Exception {
        this.m_dataBody = null;
        this.m_errorDiv = null;
        this.addCssClass("ui-dt");
        ISelectionModel sm = this.getSelectionModel();
        if (sm != null) {
            this.m_multiSelectMode = this.isShowSelectionAlways() || sm.getSelectionCount() > 0 ? sm.isMultiSelect() : false;
        }
        if (this.m_rowRenderer == null) {
            throw new IllegalStateException("There is no row renderer assigned to the table");
        }
        this.m_rowRenderer.beforeQuery(this);
        this.calcIndices();
        List list = this.getPageItems();
        if (list.size() == 0) {
            this.setNoResults();
            return;
        }
        this.setResults();
        ColumnContainer cc = new ColumnContainer(this);
        this.m_visibleItemList.clear();
        int ix = this.m_six;
        for (Object o : list) {
            TableRowSet rowSet = new TableRowSet(this, o);
            this.m_visibleItemList.add(rowSet);
            DataTableRow tr = rowSet.getPrimaryRow();
            this.m_dataBody.add(tr);
            tr.setTestRepeatID("r" + ix);
            cc.setParent(tr);
            this.renderRow(tr, cc, ix, o);
            ++ix;
        }
        this.ml("createContent rebuilt visibleList after render");
    }

    private void setResults() throws Exception {
        if (this.m_errorDiv != null) {
            this.m_errorDiv.remove();
            this.m_errorDiv = null;
        }
        if (this.m_dataBody != null) {
            return;
        }
        this.m_table.removeAllChildren();
        this.add(this.m_table);
        THead hd = new THead();
        this.m_table.add(hd);
        HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
        this.renderHeader(hc);
        if (!hc.hasContent()) {
            hd.remove();
        }
        this.m_dataBody = new TBody();
        this.m_table.add(this.m_dataBody);
        this.updateBodyClipboardSelection();
    }

    @Deprecated
    void renderHeader(@Nonnull HeaderContainer<T> hc) throws Exception {
        if (this.m_multiSelectMode) {
            TH headerCell = hc.add("");
            headerCell.add(new Img("THEME/dspcb-on.png"));
            headerCell.setTestID("dt_select_all");
            headerCell.setWidth("1%");
            headerCell.setClicked(this.m_headerSelectClickHandler);
            headerCell.setCssClass("ui-clickable");
        }
        this.m_rowRenderer.renderHeader(this, hc);
    }

    private void setNoResults() throws Exception {
        if (this.m_showHeaderAlways) {
            this.setNoResultsWithHeader();
        } else {
            this.setNoResultsWithoutHeader();
        }
    }

    private void setNoResultsWithHeader() throws Exception {
        this.m_visibleItemList.clear();
        this.ml("setNoResults visibleList cleared");
        if (this.m_errorDiv != null) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.removeAllChildren();
        } else {
            this.m_table = new Table();
            this.add(this.m_table);
        }
        this.m_dataBody = null;
        if (!this.m_table.isAttached()) {
            this.add(this.m_table);
        }
        THead hd = new THead();
        this.m_table.add(hd);
        HeaderContainer hc = new HeaderContainer(this, hd, "ui-dt-hdr");
        this.renderHeader(hc);
        if (!hc.hasContent()) {
            hd.remove();
        }
        this.m_dataBody = new TBody();
        this.m_table.add(this.m_dataBody);
        this.updateBodyClipboardSelection();
        this.renderNoResultsMessage();
    }

    private void renderNoResultsMessage() {
        this.m_errorDiv = new Div();
        this.m_errorDiv.setCssClass("ui-dt-nores");
        NodeBase emptyMessage = this.m_emptyMessage;
        if (null == emptyMessage) {
            this.m_errorDiv.setText(Msgs.BUNDLE.getString("ui.dt.empty"));
        } else {
            this.m_errorDiv.add(emptyMessage);
        }
        this.add(this.m_errorDiv);
    }

    private void setNoResultsWithoutHeader() throws Exception {
        this.m_visibleItemList.clear();
        this.ml("setNoResults visibleList cleared");
        if (this.m_errorDiv != null) {
            return;
        }
        if (this.m_table != null) {
            this.m_table.removeAllChildren();
            this.m_table.remove();
            this.m_dataBody = null;
        }
        this.renderNoResultsMessage();
    }

    private void renderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T value) throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (this.m_rowRenderer.getRowClicked() != null || null != sm) {
            cc.getTR().setClicked(new IClicked2<TR>(){

                @Override
                public void clicked(@Nonnull TR b, @Nonnull ClickInfo clinfo) throws Exception {
                    MultiRowDataTable.this.handleRowClick(b, value, clinfo);
                }
            });
            cc.getTR().addCssClass("ui-rowsel");
        } else {
            cc.getTR().addCssClass("ui-dt-row-nosel");
        }
        if (sm != null) {
            String clzName;
            boolean issel = sm.isSelected(value);
            String string = clzName = sm.isMultiSelect() ? "mselected" : "selected";
            if (issel) {
                tr.addCssClass(clzName);
            } else {
                tr.removeCssClass(clzName);
            }
            if (this.m_multiSelectMode) {
                Checkbox cb = this.createSelectionCheckbox(value, sm);
                TD td = cc.add(cb);
                if (cb.isReadOnly()) {
                    td.addCssClass("ui-cur-default");
                } else {
                    this.hookCheckboxClickToCellToo(td, cb);
                }
                cb.setChecked(issel);
            }
        }
        this.internalRenderRow(tr, cc, index, value);
    }

    private void hookCheckboxClickToCellToo(TD td, Checkbox cb) {
        td.setClicked((node, clinfo) -> {
            IClickBase<?> clickHandler;
            if (!cb.isDisabled() && null != (clickHandler = cb.getClicked()) && clickHandler instanceof IClicked2) {
                cb.setChecked(!cb.isChecked());
                ((IClicked2)clickHandler).clicked(cb, clinfo);
            }
        });
    }

    @Deprecated
    void internalRenderRow(@Nonnull TR tr, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T value) throws Exception {
        this.m_rowRenderer.renderRow(this, cc, index, value);
    }

    private void handleRowClick(TR b, T instance, ClickInfo clinfo) throws Exception {
        ICellClicked<?> rowClicked = this.m_rowRenderer.getRowClicked();
        if (null != rowClicked) {
            rowClicked.cellClicked(b, instance);
        }
    }

    private void selectionCheckboxClicked(T instance, boolean checked, ClickInfo info, @Nonnull Checkbox checkbox) throws Exception {
    }

    private void updateSelectionChanged(T instance, TableRowSet<T> tableRowSet, boolean on) throws Exception {
        ISelectionModel sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("No selection model!?");
        }
        DataTableRow<T> row = tableRowSet.getPrimaryRow();
        THead head = this.m_table.getHead();
        if (null == head) {
            throw new IllegalStateException("I've lost my head!?");
        }
        TR headerrow = (TR)head.getChild(0);
        if (!sm.isMultiSelect()) {
            if (on) {
                row.addCssClass("selected");
            } else {
                row.removeCssClass("selected");
            }
            return;
        }
        if (!this.m_multiSelectMode && !on) {
            return;
        }
        TD td = (TD)row.getChild(0);
        Checkbox cb = (Checkbox)td.getChild(0);
        if (cb.isChecked() != on) {
            cb.setChecked(on);
        }
        if (on) {
            row.addCssClass("mselected");
        } else {
            row.removeCssClass("mselected");
        }
    }

    @Override
    protected void createSelectionUI() throws Exception {
    }

    @Override
    public void modelChanged(@Nullable ITableModel<T> model) {
        this.forceRebuild();
        this.fireModelChanged(null, model);
    }

    @Override
    public void rowAdded(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        try {
            if (!this.isBuilt()) {
                return;
            }
            this.calcIndices();
            if (index < this.m_six || index >= this.m_eix) {
                this.firePageChanged();
                return;
            }
            this.setResults();
            int rrow = index - this.m_six;
            this.ml("rowAdded before anything: rrow=" + rrow + " index=" + index);
            ColumnContainer cc = new ColumnContainer(this);
            TableRowSet<T> rowSet = new TableRowSet<T>(this, value);
            DataTableRow<T> tr = rowSet.getPrimaryRow();
            this.m_visibleItemList.add(rrow, rowSet);
            int bodyIndex = this.calculateBodyPosition(rrow);
            this.m_dataBody.add(bodyIndex, tr);
            cc.setParent(tr);
            tr.setTestRepeatID("r" + index);
            this.renderRow(tr, cc, index, value);
            this.ml("rowAdded after adds: rrow=" + rrow + ", index=" + index + ", bodyIndex=" + bodyIndex);
            if (this.m_pageSize > 0 && this.m_visibleItemList.size() > this.m_pageSize) {
                int lastChildIndex = this.m_visibleItemList.size() - 1;
                this.ml("rowAdded removing last item at " + lastChildIndex);
                TableRowSet<T> lastRow = this.m_visibleItemList.remove(lastChildIndex);
                for (DataTableRow<T> tableRow : lastRow) {
                    tableRow.remove();
                }
            }
            this.handleOddEven(rrow);
            this.firePageChanged();
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    private int calculateBodyPosition(int rowIndex) {
        int position = 0;
        for (int i = 0; i < rowIndex; ++i) {
            TableRowSet<T> rowSet = this.m_visibleItemList.get(i);
            position += rowSet.rowCount();
        }
        return position;
    }

    private void ml(String rest) {
        try {
            TBody dataBody = this.m_dataBody;
            int sz = dataBody == null ? -1 : dataBody.getChildCount();
            this.m_ml.add(rest + ": six=" + this.m_six + ", eix=" + this.m_eix + ", visibleSz=" + this.m_visibleItemList.size() + ", bodySz=" + sz + ", modelSz=" + this.getModel().getRows());
        }
        catch (Exception x) {
            this.m_ml.add("Exception adding to log stack: " + x);
        }
    }

    @Override
    public void rowDeleted(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        try {
            if (!this.isBuilt()) {
                return;
            }
            if (index < this.m_six || index >= this.m_eix) {
                this.calcIndices();
                this.firePageChanged();
                return;
            }
            int rrow = index - this.m_six;
            this.ml("rowDeleted before, index=" + index + ", rrow=" + rrow);
            TableRowSet<T> rowSet = this.m_visibleItemList.remove(rrow);
            for (DataTableRow<T> tableRow : rowSet) {
                tableRow.remove();
            }
            if (this.m_visibleItemList.size() == 0) {
                this.calcIndices();
                this.setNoResults();
                this.firePageChanged();
                return;
            }
            int peix = this.m_six + this.m_pageSize - 1;
            if (this.m_pageSize > 0 && peix < this.m_eix && peix < this.getModel().getRows()) {
                this.ml("rowDelete grow page: peix=" + peix + ", rrow=" + rrow);
                Object mi = this.getModelItem(peix);
                TableRowSet newSet = new TableRowSet(this, mi);
                int lastIndex = this.m_pageSize - 1;
                this.m_visibleItemList.add(lastIndex, newSet);
                ColumnContainer cc = new ColumnContainer(this);
                DataTableRow tr = newSet.getPrimaryRow();
                cc.setParent(tr);
                int bodyIndex = this.calculateBodyPosition(lastIndex);
                this.ml("rowDelete add at body index " + lastIndex);
                this.m_dataBody.add(lastIndex, tr);
                this.renderRow(tr, cc, peix, mi);
            }
            this.calcIndices();
            this.handleOddEven(rrow);
            this.firePageChanged();
        }
        catch (IndexOutOfBoundsException x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw new RuntimeException("Bug 7153 rowDelete index error " + x.getMessage() + "\n" + this.m_ml.getData(), x);
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    private void handleOddEven(int index) {
        for (int ix = index; ix < this.m_visibleItemList.size(); ++ix) {
            TableRowSet<T> rowSet = this.m_visibleItemList.get(ix);
            rowSet.markEven((ix & 1) == 0);
        }
    }

    @Override
    public void rowModified(@Nonnull ITableModel<T> model, int index, @Nonnull T value) throws Exception {
        if (!this.isBuilt()) {
            return;
        }
        if (index < this.m_six || index >= this.m_eix) {
            return;
        }
        try {
            int rrow = index - this.m_six;
            TableRowSet<T> rowSet = this.m_visibleItemList.get(rrow);
            for (DataTableRow<T> tableRow : rowSet) {
                tableRow.remove();
            }
            rowSet = new TableRowSet<T>(this, value);
            this.m_visibleItemList.set(rrow, rowSet);
            this.ml("rowModified: index=" + index + ", rrow=" + rrow);
            DataTableRow<T> tr = rowSet.getPrimaryRow();
            int bodyIndex = this.calculateBodyPosition(rrow);
            this.m_dataBody.add(bodyIndex, tr);
            ColumnContainer cc = new ColumnContainer(this);
            cc.setParent(tr);
            this.renderRow(tr, cc, index, value);
        }
        catch (Exception x) {
            System.err.println("Last DataTable actions:\n" + this.m_ml.getData());
            throw x;
        }
    }

    public void setTableWidth(@Nullable String w) {
        this.m_table.setTableWidth(w);
    }

    @Nonnull
    public IRowRenderer<T> getRowRenderer() {
        return this.m_rowRenderer;
    }

    public void setRowRenderer(@Nonnull IRowRenderer<T> rowRenderer) {
        if (DomUtil.isEqual(this.m_rowRenderer, rowRenderer)) {
            return;
        }
        this.m_rowRenderer = rowRenderer;
        this.forceRebuild();
    }

    @Override
    protected void onForceRebuild() {
        this.m_visibleItemList.clear();
        this.ml("onForceRebuild, visiblesz cleared");
        this.m_lastSelectionLocation = -1;
        super.onForceRebuild();
    }

    @Override
    public void selectionChanged(@Nonnull T row, boolean on) throws Exception {
        for (TableRowSet<T> tableRowSet : this.m_visibleItemList) {
            if (!MetaManager.areObjectsEqual(row, tableRowSet.getInstance())) continue;
            this.updateSelectionChanged(row, tableRowSet, on);
            return;
        }
    }

    @Override
    public void selectionAllChanged() throws Exception {
        ISelectionModel<T> sm = this.getSelectionModel();
        if (sm == null) {
            throw new IllegalStateException("Got selection changed event but selection model is empty?");
        }
        for (TableRowSet<T> tableRowSet : this.m_visibleItemList) {
            this.updateSelectionChanged(tableRowSet.getInstance(), tableRowSet, sm.isSelected(tableRowSet.getInstance()));
        }
    }

    @Nonnull
    private Checkbox createSelectionCheckbox(final @Nonnull T rowInstance, @Nullable ISelectionModel<T> selectionModel) {
        Checkbox cb = new Checkbox();
        boolean selectable = true;
        if (selectionModel instanceof IAcceptable) {
            selectable = ((IAcceptable)((Object)selectionModel)).acceptable(rowInstance);
        }
        if (selectable) {
            cb.setClicked(new IClicked2<Checkbox>(){

                @Override
                public void clicked(@Nonnull Checkbox clickednode, @Nonnull ClickInfo info) throws Exception {
                    MultiRowDataTable.this.selectionCheckboxClicked(rowInstance, clickednode.isChecked(), info, clickednode);
                }
            });
        } else {
            cb.setReadOnly(true);
        }
        return cb;
    }

    public boolean isDisplayReadonlySelection() {
        return this.m_displayReadonlySelection;
    }

    public void setDisplayReadonlySelection(boolean displayReadonlySelection) {
        if (this.m_displayReadonlySelection == displayReadonlySelection) {
            return;
        }
        this.m_displayReadonlySelection = displayReadonlySelection;
        this.forceRebuild();
    }

    public void setEmptyMessage(@Nullable String message) {
        this.m_emptyMessage = null != message ? new TextNode(message) : null;
    }

    public void setEmptyMessage(@Nullable NodeBase node) {
        this.m_emptyMessage = node;
    }

    public boolean isShowHeaderAlways() {
        return this.m_showHeaderAlways;
    }

    public void setShowHeaderAlways(boolean showHeaderAlways) {
        this.m_showHeaderAlways = showHeaderAlways;
    }

    @Nonnull
    private Table getTable() {
        if (null == this.m_table) {
            throw new IllegalStateException("Backing table is still null");
        }
        return this.m_table;
    }

    private void setDataBody(@Nonnull TBody dataBody) {
        this.m_dataBody = dataBody;
        this.updateBodyClipboardSelection();
    }

    @Nonnull
    private TBody getDataBody() {
        if (null == this.m_dataBody) {
            throw new IllegalStateException("dataBody is still null");
        }
        return this.m_dataBody;
    }

    @Override
    public boolean isMultiSelectionVisible() {
        return this.m_multiSelectMode;
    }

    @Override
    public int getPageSize() {
        return this.m_pageSize;
    }

    public void setPageSize(int pageSize) {
        if (this.m_pageSize == pageSize) {
            return;
        }
        this.m_pageSize = pageSize;
        this.forceRebuild();
        this.firePageChanged();
    }

    private void checkVisible(TableRowSet<T> rowSet) {
        if (!this.m_visibleItemList.contains(rowSet)) {
            throw new IllegalStateException("The row set is no longer visible");
        }
    }

    public boolean isVisible(TableRowSet<T> rowSet) {
        return this.m_visibleItemList.contains(rowSet);
    }

    void appendExtraRowAfter(TableRowSet<T> rowSet, DataTableRow<T> newRow, DataTableRow<T> row) {
        this.checkVisible(rowSet);
        row.appendAfterMe(newRow);
    }

    void appendExtraRowBefore(TableRowSet<T> rowSet, DataTableRow<T> newRow, DataTableRow<T> row) {
        this.checkVisible(rowSet);
        row.appendBeforeMe(newRow);
    }
}

