/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.experimental;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.controlfactory.ControlBuilder;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SortableType;
import to.etc.domui.component.misc.DisplaySpan;
import to.etc.domui.component.ntbl.IRowButtonFactory;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.ColumnDef;
import to.etc.domui.component.tbl.ColumnList;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.IRowControlFactory;
import to.etc.domui.component.tbl.IRowRenderHelper;
import to.etc.domui.component.tbl.ISortHelper;
import to.etc.domui.component.tbl.ISortableTableModel;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.TableHeader;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConverter;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TH;
import to.etc.domui.server.DomApplication;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.util.StringTool;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.annotations.GProperty;

public final class MultiRowRenderer<T>
implements IClickableRowRenderer<T> {
    @Nonnull
    private final Class<T> m_dataClass;
    @Nonnull
    private final ClassMetaModel m_metaModel;
    @Nullable
    private IRowRenderHelper<T> m_helper;
    private boolean m_completed;
    @Nonnull
    private final ColumnList<T> m_columnList;
    @Nullable
    private Img[] m_sortImages;
    @Nullable
    private ICellClicked<?> m_rowClicked;
    @Nullable
    private IRowButtonFactory<T> m_rowButtonFactory;
    @Nullable
    private TableModelTableBase<T> m_tableModelTable;
    @Nonnull
    private List<TableHeader> m_tableHeaderBeforeList = Collections.EMPTY_LIST;
    @Nonnull
    private List<TableHeader> m_tableHeaderAfterList = Collections.EMPTY_LIST;
    @Nullable
    private ITableModel<T> m_lastSortedModel;
    @Nullable
    private ColumnDef<T, ?> m_lastSortedColumn;
    @Nullable
    private Boolean m_lastSortedDirection;

    public MultiRowRenderer(@Nonnull Class<T> data) {
        this(data, MetaManager.findClassMeta(data));
    }

    public MultiRowRenderer(@Nonnull Class<T> data, @Nonnull ClassMetaModel cmm) {
        this.m_dataClass = data;
        this.m_metaModel = cmm;
        this.m_columnList = new ColumnList<T>(data, this.m_metaModel);
    }

    private void check() {
        if (this.m_completed) {
            throw new IllegalStateException("Programmer error: This object has been USED and cannot be changed anymore");
        }
    }

    public MultiRowRenderer<T> helper(IRowRenderHelper<T> helper) {
        this.m_helper = helper;
        return this;
    }

    private void complete(@Nonnull TableModelTableBase<T> tbl) {
        ColumnDef<T, ?> column;
        if (this.isComplete()) {
            return;
        }
        this.m_tableModelTable = tbl;
        if (this.getColumnList().size() == 0) {
            this.addDefaultColumns();
        }
        if (this.getSortColumn() == null) {
            String dsp = this.model().getDefaultSortProperty();
            this.getColumnList().setDefaultSortColumn(dsp);
        }
        if (null != (column = this.getSortColumn())) {
            this.setSortDescending(column.getSortable() == SortableType.SORTABLE_DESC);
        }
        this.getColumnList().assignPercentages();
        this.m_completed = true;
    }

    @Override
    public void renderHeader(@Nonnull TableModelTableBase<T> tbl, @Nonnull HeaderContainer<T> cc) throws Exception {
        for (TableHeader h : this.m_tableHeaderBeforeList) {
            cc.addHeader(false, h);
        }
        for (TableHeader h : this.m_tableHeaderAfterList) {
            cc.addHeader(true, h);
        }
        this.m_sortImages = new Img[this.m_columnList.size()];
        Img[] sortImages = this.m_sortImages;
        int ix = 0;
        boolean sortablemodel = tbl.getModel() instanceof ISortableTableModel;
        StringBuilder sb = new StringBuilder();
        for (ColumnDef<T, ?> cd : this.m_columnList) {
            TH th;
            String label = cd.getColumnLabel();
            if (!cd.getSortable().isSortable() || !sortablemodel) {
                th = cc.add(new Span(label));
            } else {
                Div cellSpan = new Div();
                cellSpan.setCssClass("ui-sortable");
                th = cc.add(cellSpan);
                th.setCssClass("ui-sortable");
                Img img = new Img();
                cellSpan.add(img);
                if (cd == this.getSortColumn()) {
                    img.setSrc(this.m_columnList.isSortDescending() ? "THEME/sort-desc.png" : "THEME/sort-asc.png");
                } else {
                    img.setSrc("THEME/sort-none.png");
                }
                sortImages[ix] = img;
                if (!StringTool.isBlank((String)label)) {
                    cellSpan.add(new Span(label));
                }
                final ColumnDef<T, ?> scd = cd;
                th.setClicked(new IClicked<TH>(){

                    @Override
                    public void clicked(@Nonnull TH b) throws Exception {
                        MultiRowRenderer.this.handleSortClick(b, scd);
                    }
                });
            }
            if (cd.getHeaderCssClass() != null) {
                sb.setLength(0);
                if (th.getCssClass() != null) {
                    sb.append(th.getCssClass());
                    sb.append(' ');
                }
                sb.append(cd.getHeaderCssClass());
                th.setCssClass(sb.toString());
            }
            th.setWidth(cd.getWidth());
            ++ix;
        }
        if (this.getRowButtonFactory() != null) {
            cc.add("");
        }
    }

    private void handleSortClick(@Nonnull NodeBase nb, @Nonnull ColumnDef<T, ?> scd) throws Exception {
        ColumnDef<T, ?> sortColumn = this.getSortColumn();
        if (scd == sortColumn) {
            this.setSortDescending(!this.isSortDescending());
        } else {
            if (sortColumn != null) {
                this.updateSortImage(sortColumn, "THEME/sort-none.png");
            }
            this.m_columnList.setSortColumn(scd, scd.getSortable());
        }
        this.updateSortImage(scd, this.isSortDescending() ? "THEME/sort-desc.png" : "THEME/sort-asc.png");
        TableModelTableBase<T> parent = this.m_tableModelTable;
        if (null == parent) {
            throw new IllegalStateException("Table not defined");
        }
        this.resort(scd, parent);
    }

    private boolean hasSortChanged(@Nonnull ColumnDef<T, ?> newColumn, @Nonnull TableModelTableBase<T> tableComponent) {
        if (newColumn != this.m_lastSortedColumn) {
            return true;
        }
        ITableModel<T> newModel = tableComponent.getModel();
        if (newModel != this.m_lastSortedModel) {
            return true;
        }
        Boolean direction = this.m_lastSortedDirection;
        if (direction == null) {
            return true;
        }
        return direction.booleanValue() != this.isSortDescending();
    }

    private void resort(@Nonnull ColumnDef<T, ?> scd, TableModelTableBase<T> parent) throws Exception {
        if (!this.hasSortChanged(scd, parent)) {
            return;
        }
        ISortHelper<?> sortHelper = scd.getSortHelper();
        if (sortHelper != null) {
            sortHelper.adjustSort(parent.getModel(), this.isSortDescending());
        } else {
            ISortableTableModel stm = (ISortableTableModel)((Object)parent.getModel());
            String propertyName = scd.getSortProperty();
            if (null == propertyName) {
                propertyName = scd.getPropertyName();
            }
            stm.sortOn(propertyName, this.isSortDescending());
        }
        this.m_lastSortedDirection = this.isSortDescending();
        this.m_lastSortedModel = parent.getModel();
        this.m_lastSortedColumn = scd;
    }

    private void updateSortImage(@Nonnull ColumnDef<T, ?> scd, @Nonnull String img) {
        Img[] sortImages = this.m_sortImages;
        if (sortImages == null) {
            return;
        }
        int index = this.m_columnList.indexOf(scd);
        if (index == -1) {
            throw new IllegalStateException("?? Cannot find sort column!?");
        }
        sortImages[index].setSrc(img);
    }

    @Override
    public void beforeQuery(@Nonnull TableModelTableBase<T> tbl) throws Exception {
        this.complete(tbl);
        if (!(tbl.getModel() instanceof ISortableTableModel)) {
            return;
        }
        ColumnDef<T, ?> scol = this.getSortColumn();
        if (scol == null) {
            return;
        }
        this.resort(scol, tbl);
    }

    @Override
    public void renderRow(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnContainer<T> cc, int index, @Nonnull T instance) throws Exception {
        IRowRenderHelper<T> helper = this.m_helper;
        if (null != helper) {
            helper.setRow(instance);
        }
        for (ColumnDef<T, ?> cd : this.m_columnList) {
            this.renderColumn(tbl, cc, index, instance, cd);
        }
        IRowButtonFactory<T> rbf = this.getRowButtonFactory();
        if (rbf != null) {
            TD td = cc.add((NodeBase)null);
            cc.getRowButtonContainer().setContainer(td);
            rbf.addButtonsFor(cc.getRowButtonContainer(), instance);
        }
    }

    protected <X> void renderColumn(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T instance, final @Nonnull ColumnDef<T, X> cd) throws Exception {
        TD cell = cc.add((NodeBase)null);
        String cssClass = cd.getCssClass();
        if (cssClass != null) {
            cell.addCssClass(cssClass);
        }
        if (cd.isNowrap()) {
            cell.setNowrap(true);
        }
        if (cd.getCellClicked() != null) {
            cell.setClicked(new IClicked<TD>(){

                @Override
                public void clicked(@Nonnull TD b) throws Exception {
                    ICellClicked<?> clicked = cd.getCellClicked();
                    if (null != clicked) {
                        clicked.cellClicked(b, instance);
                    }
                }
            });
            cell.addCssClass("ui-cellsel");
        }
        if (cd.getAlign() != null) {
            cell.setTextAlign(cd.getAlign());
        } else if (cssClass != null) {
            cell.addCssClass(cssClass);
        }
        final INodeContentRenderer<X> contentRenderer = cd.getContentRenderer();
        IConverter<X> cellConverter = cd.getConverter();
        PropertyMetaModel<X> pmm = cd.getPropertyMetaModel();
        if (cd.isEditable()) {
            if (null != contentRenderer) {
                throw new IllegalStateException("A column cannot be editable if you assign your own renderer to it: handle the editing inside the renderer yourself.");
            }
            if (null != cellConverter) {
                throw new IllegalStateException("A column cannot be editable if you assign a converter to it: handle the conversion inside the renderer yourself.");
            }
            this.renderEditable(tbl, cd, cell, instance);
        } else if (pmm != null) {
            IConverter<X> converter = cellConverter;
            if (null == converter) {
                converter = ConverterRegistry.findBestConverter(pmm);
            }
            DisplaySpan<Class<X>> ds = new DisplaySpan<Class<X>>(pmm.getActualType());
            ds.bind().to(instance, pmm);
            if (null != contentRenderer) {
                ds.setRenderer(new INodeContentRenderer<X>(){

                    @Override
                    public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable X object, @Nullable Object parameters) throws Exception {
                        contentRenderer.renderNodeContent(component, node, object, instance);
                    }
                });
            }
            cell.add(ds);
            if (converter != null) {
                ds.setConverter(converter);
            }
            this.applyCellAttributes(cell, cd);
        } else if (contentRenderer != null) {
            X value = cd.getColumnValue(instance);
            contentRenderer.renderNodeContent(cc.getTR(), cell, value, null);
        } else {
            throw new IllegalStateException("? Don't know how to render " + cd);
        }
    }

    private void applyCellAttributes(NodeContainer cell, ColumnDef<T, ?> cd) {
        if (cd.getNumericPresentation() != null && cd.getNumericPresentation() != NumericPresentation.UNKNOWN) {
            cell.addCssClass("ui-numeric");
        }
    }

    private <X, C extends NodeBase> void renderEditable(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnDef<T, X> cd, @Nonnull TD cell, @Nonnull T instance) throws Exception {
        NodeBase control;
        PropertyMetaModel<X> pmm = cd.getPropertyMetaModel();
        if (null == pmm) {
            throw new IllegalStateException("Cannot render edit value for row type");
        }
        IRowControlFactory<T> cf = cd.getControlFactory();
        if (cf != null) {
            control = (NodeBase)((Object)cf.createControl(instance));
        } else {
            ControlBuilder cb = DomApplication.get().getControlBuilder();
            control = cb.createControlFor(pmm, true, null).getFormControl();
        }
        control.bind().to(instance, pmm);
        cell.add(control);
    }

    @Nullable
    public IRowButtonFactory<T> getRowButtonFactory() {
        return this.m_rowButtonFactory;
    }

    public void setRowButtonFactory(@Nullable IRowButtonFactory<T> rowButtonFactory) {
        this.m_rowButtonFactory = rowButtonFactory;
    }

    public void addDefaultColumns() {
        this.getColumnList().addDefaultColumns();
    }

    @Nonnull
    private ColumnList<T> getColumnList() {
        return this.m_columnList;
    }

    public void setDefaultSort(@Nonnull ColumnDef<T, ?> cd, @Nonnull SortableType type) {
        this.getColumnList().setSortColumn(cd, type);
    }

    @Nonnull
    protected ClassMetaModel model() {
        return this.m_metaModel;
    }

    @Nonnull
    protected Class<?> getActualClass() {
        return this.m_dataClass;
    }

    protected boolean isComplete() {
        return this.m_completed;
    }

    protected void setSortColumn(@Nullable ColumnDef<T, ?> cd, @Nullable SortableType type) {
        this.m_columnList.setSortColumn(cd, type);
    }

    @Nullable
    protected ColumnDef<T, ?> getSortColumn() {
        return this.m_columnList.getSortColumn();
    }

    protected boolean isSortDescending() {
        return this.m_columnList.isSortDescending();
    }

    protected void setSortDescending(boolean desc) {
        this.m_columnList.setSortDescending(desc);
    }

    @Nonnull
    public ColumnDef<T, ?> getColumn(int ix) {
        return this.m_columnList.get(ix);
    }

    public int getColumnCount() {
        return this.m_columnList.size();
    }

    @Nonnull
    public ColumnDef<T, ?> getColumnByName(String propertyName) {
        for (ColumnDef<T, ?> scd : this.m_columnList) {
            if (!propertyName.equals(scd.getPropertyName())) continue;
            return scd;
        }
        throw new ProgrammerErrorException("The property with the name '" + propertyName + "' is undefined in this RowRenderer - perhaps metadata has changed?");
    }

    public void setColumnWidths(String ... widths) {
        this.check();
        int ix = 0;
        for (String s : widths) {
            this.getColumn(ix++).width(s);
        }
    }

    public void setColumnWidth(int index, String width) {
        this.check();
        this.getColumn(index).width(width);
    }

    public <C> void setNodeRenderer(int index, @Nullable INodeContentRenderer<C> renderer) {
        this.check();
        this.getColumn(index).renderer(renderer);
    }

    public INodeContentRenderer<?> getNodeRenderer(int index) {
        return this.getColumn(index).getContentRenderer();
    }

    @Override
    @Nullable
    public ICellClicked<?> getRowClicked() {
        return this.m_rowClicked;
    }

    @Override
    public <V> void setRowClicked(@Nullable ICellClicked<V> rowClicked) {
        this.m_rowClicked = rowClicked;
    }

    @Nullable
    public ICellClicked<?> getCellClicked(int col) {
        return this.getColumn(col).getCellClicked();
    }

    @Override
    public <V> void setCellClicked(int col, @Nullable ICellClicked<V> cellClicked) {
        this.getColumn(col).cellClicked(cellClicked);
    }

    @Nonnull
    public <V> ColumnDef<T, V> column(@Nonnull Class<V> type, @Nonnull @GProperty String property) {
        return this.getColumnList().column(type, property);
    }

    @Nonnull
    public ColumnDef<T, ?> column(@Nonnull String property) {
        return this.getColumnList().column(property);
    }

    @Nonnull
    public ColumnDef<T, T> column() {
        return this.getColumnList().column();
    }

    public void addHeaderBefore(@Nonnull TableHeader header) {
        if (this.m_tableHeaderBeforeList.size() == 0) {
            this.m_tableHeaderBeforeList = new ArrayList<TableHeader>(2);
        }
        this.m_tableHeaderBeforeList.add(header);
    }

    public void addHeaderAfter(@Nonnull TableHeader header) {
        if (this.m_tableHeaderAfterList.size() == 0) {
            this.m_tableHeaderAfterList = new ArrayList<TableHeader>(2);
        }
        this.m_tableHeaderAfterList.add(header);
    }
}

