/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.experimental;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.DefaultNonNull;
import to.etc.domui.component.experimental.DataTableRow;
import to.etc.domui.component.experimental.MultiRowDataTable;

@DefaultNonNull
public final class TableRowSet<T>
implements Iterable<DataTableRow<T>> {
    private final MultiRowDataTable<T> m_dataTable;
    private final T m_instance;
    private final DataTableRow<T> m_primaryRow;
    private final List<DataTableRow<T>> m_rowsList = new ArrayList<DataTableRow<T>>();
    private boolean m_even;

    public TableRowSet(MultiRowDataTable<T> dataTable, T instance) {
        this.m_dataTable = dataTable;
        this.m_instance = instance;
        this.m_primaryRow = new DataTableRow(this);
        this.m_rowsList.add(this.m_primaryRow);
    }

    @Override
    public Iterator<DataTableRow<T>> iterator() {
        return this.m_rowsList.iterator();
    }

    public DataTableRow<T> getPrimaryRow() {
        return this.m_primaryRow;
    }

    public T getInstance() {
        return this.m_instance;
    }

    public DataTableRow<T> addRowAfter(DataTableRow<T> row) {
        DataTableRow newRow = new DataTableRow(this);
        int index = this.m_rowsList.indexOf(row);
        if (index < 0) {
            throw new IllegalStateException("Invalid reference row");
        }
        this.m_rowsList.add(index + 1, newRow);
        this.m_dataTable.appendExtraRowAfter(this, newRow, row);
        return newRow;
    }

    public DataTableRow<T> addRowBefore(DataTableRow<T> row) {
        DataTableRow newRow = new DataTableRow(this);
        int index = this.m_rowsList.indexOf(row);
        if (index < 0) {
            throw new IllegalStateException("Invalid reference row");
        }
        this.m_rowsList.add(index, newRow);
        this.m_dataTable.appendExtraRowBefore(this, newRow, row);
        return newRow;
    }

    public int rowCount() {
        return this.m_rowsList.size();
    }

    public void markEven(boolean even) {
        this.m_even = even;
        for (DataTableRow<T> tr : this.m_rowsList) {
            tr.markEven(even);
        }
    }

    public boolean isVisible() {
        return this.m_dataTable.isVisible(this);
    }
}

