/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.form;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import to.etc.domui.component.form.GenericTableFormBuilder;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.server.IControlLabelFactory;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IReadOnlyModel;

@Deprecated
public class HorizontalFormBuilder
extends GenericTableFormBuilder {
    private TR m_labelRow;
    private TR m_editRow;
    private TableMode m_tableMode = TableMode.perForm;
    private List<Table> m_generatedTableList = new ArrayList<Table>();
    private int m_labelRowSpan = 1;
    private int m_controlRowSpan = 1;
    private int m_labelColSpan = 1;
    private int m_controlColSpan = 1;
    private String m_defaultLabelClass = "ui-fvs-lbl";
    private String m_defaultControlClass = "ui-fvs-in";
    private String m_labelClass;
    private String m_controlClass;
    private String m_labelWidth;
    private String m_controlWidth;
    private Boolean m_labelNowrap;
    private Boolean m_controlNoWrap;

    public HorizontalFormBuilder() {
    }

    public <T> HorizontalFormBuilder(Class<T> clz, IReadOnlyModel<T> mdl) {
        super(clz, mdl);
    }

    public <T> HorizontalFormBuilder(T instance) {
        this.setInstance(instance);
    }

    @Override
    @Nonnull
    public TD addCell() {
        return this.addCell(null, 1, 2);
    }

    public TD addCell(int colSpan, int rowSpan) {
        return this.addCell(null, colSpan, rowSpan);
    }

    public TD addCell(String css, int colSpan, int rowSpan) {
        TR tr = this.getLabelRow();
        TD td = tr.addCell(css);
        if (colSpan > 1) {
            td.setColspan(colSpan);
        }
        if (rowSpan > 1) {
            td.setRowspan(rowSpan);
        }
        return td;
    }

    public TR getLabelRow() {
        this.checkRows();
        return this.m_labelRow;
    }

    public TR getEditRow() {
        this.checkRows();
        return this.m_editRow;
    }

    private void checkRows() {
        if (this.m_labelRow != null && this.m_editRow != null) {
            return;
        }
        if (this.m_tableMode == TableMode.perRow) {
            if (this.getTable() == null) {
                this.reset();
            } else if (this.getTBody() == null) {
                this.tbody();
            } else if (this.getTBody().getChildCount() > 0) {
                this.reset();
            }
        }
        this.m_labelRow = this.addRow();
        this.m_editRow = this.addRow();
    }

    @Override
    protected void addControl(String label, NodeBase labelnode, NodeBase[] list, boolean mandatory, boolean editable, PropertyMetaModel<?> pmm) {
        IControlLabelFactory clf = this.getControlLabelFactory();
        if (clf == null && (clf = this.getBuilder().getControlLabelFactory()) == null) {
            throw new IllegalStateException("Programmer error: the DomApplication instance returned a null IControlLabelFactory!?!?!?!?");
        }
        Label l = clf.createControlLabel(labelnode, label, editable, mandatory, pmm);
        this.modalAdd(l, list, editable);
        this.clearRun();
    }

    @Override
    protected void addControl(NodeBase label, NodeBase labelnode, NodeBase[] list, boolean mandatory, boolean editable, PropertyMetaModel<?> pmm) {
        this.modalAdd(label, list, editable);
        this.clearRun();
    }

    @Override
    public void addContent(NodeBase label, NodeBase[] control, boolean editable) {
        this.modalAdd(label, control, editable);
        this.clearRun();
    }

    @Override
    protected IControl<?>[] addListOfProperties(boolean editable, String ... names) {
        IControl[] res = new IControl[names.length];
        int ix = 0;
        for (String name : names) {
            res[ix] = editable ? this.addProp(name) : this.addDisplayProp(name);
            ++ix;
        }
        this.clearRun();
        return res;
    }

    private void modalAdd(NodeBase l, NodeBase[] list, boolean editable) {
        String css;
        TR tr = this.getLabelRow();
        TD td = tr.addCell();
        td.setCssClass(this.m_labelClass == null ? this.m_defaultLabelClass : this.m_labelClass);
        td.add(l);
        if (this.m_labelColSpan > 1) {
            td.setColspan(this.m_labelColSpan);
        }
        if (this.m_labelRowSpan > 1) {
            td.setRowspan(this.m_labelRowSpan);
        }
        if (this.m_labelNowrap != null) {
            td.setNowrap(this.m_labelNowrap);
        }
        if (this.m_labelWidth != null) {
            td.setWidth(this.m_labelWidth);
        }
        tr = this.getEditRow();
        td = tr.addCell();
        String string = css = editable ? this.m_defaultControlClass : "ui-fvs-do";
        if (this.m_controlClass != null) {
            css = this.m_controlClass;
        }
        td.setCssClass(css);
        if (this.m_controlColSpan > 1) {
            td.setColspan(this.m_controlColSpan);
        }
        if (this.m_controlRowSpan > 1) {
            td.setRowspan(this.m_controlRowSpan);
        }
        if (this.m_controlNoWrap != null) {
            td.setNowrap(this.m_controlNoWrap);
        }
        if (this.m_controlWidth != null) {
            td.setWidth(this.m_controlWidth);
        }
        for (NodeBase nb : list) {
            td.add(nb);
        }
    }

    @Override
    protected void onTableAdded(Table t) {
        this.m_generatedTableList.add(t);
    }

    @Override
    protected void internalClearLocation() {
        this.m_labelRow = null;
        this.m_editRow = null;
    }

    public void nl() {
        this.m_labelRow = null;
        this.m_editRow = null;
        if (this.m_tableMode == TableMode.perRow) {
            this.reset();
        }
    }

    private void basicFinish(boolean balance) {
        for (Table t : this.m_generatedTableList) {
            if (!balance) continue;
            DomUtil.balanceTable(t);
        }
    }

    @Override
    public NodeContainer finish() {
        this.basicFinish(false);
        NodeContainer result = null;
        if (this.m_generatedTableList.size() == 0) {
            result = null;
        } else if (this.m_generatedTableList.size() == 1) {
            result = this.m_generatedTableList.get(0);
        } else {
            Div d = new Div();
            d.setCssClass("ui-szless");
            for (Table t : this.m_generatedTableList) {
                d.add(t);
            }
            result = d;
        }
        this.m_generatedTableList.clear();
        this.reset();
        return result;
    }

    public void finish(NodeContainer target) {
        this.finish(target, true);
    }

    public void finish(NodeContainer target, boolean balance) {
        this.basicFinish(balance);
        for (Table t : this.m_generatedTableList) {
            target.add(t);
        }
        this.m_generatedTableList.clear();
        this.reset();
    }

    private void clearRun() {
        this.m_labelColSpan = 1;
        this.m_labelRowSpan = 1;
        this.m_controlColSpan = 1;
        this.m_controlRowSpan = 1;
        this.m_labelClass = null;
        this.m_controlClass = null;
        this.m_labelWidth = null;
        this.m_controlWidth = null;
        this.m_labelNowrap = null;
        this.m_controlNoWrap = null;
    }

    public HorizontalFormBuilder colSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("colspan " + x + " must be > 0");
        }
        this.m_labelColSpan = x;
        this.m_controlColSpan = x;
        return this;
    }

    public HorizontalFormBuilder rowSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("rowspan " + x + " must be > 0");
        }
        this.m_labelRowSpan = x;
        this.m_controlRowSpan = x;
        return this;
    }

    public HorizontalFormBuilder labelColSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("colspan " + x + " must be > 0");
        }
        this.m_labelColSpan = x;
        return this;
    }

    public HorizontalFormBuilder labelRowSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("rowspan " + x + " must be > 0");
        }
        this.m_labelRowSpan = x;
        return this;
    }

    public HorizontalFormBuilder controlColSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("colspan " + x + " must be > 0");
        }
        this.m_controlColSpan = x;
        return this;
    }

    public HorizontalFormBuilder controlRowSpan(int x) {
        if (x < 0) {
            throw new IllegalArgumentException("rowspan " + x + " must be > 0");
        }
        this.m_controlRowSpan = x;
        return this;
    }

    public HorizontalFormBuilder defaultLabelClass(String defaultLabelClass) {
        this.m_defaultLabelClass = defaultLabelClass;
        return this;
    }

    public HorizontalFormBuilder defaultControlClass(String defaultControlClass) {
        this.m_defaultControlClass = defaultControlClass;
        return this;
    }

    public HorizontalFormBuilder labelClass(String labelClass) {
        this.m_labelClass = labelClass;
        return this;
    }

    public HorizontalFormBuilder controlClass(String controlClass) {
        this.m_controlClass = controlClass;
        return this;
    }

    public HorizontalFormBuilder tablePerRow() {
        this.m_tableMode = TableMode.perRow;
        return this;
    }

    public HorizontalFormBuilder tablePerForm() {
        this.m_tableMode = TableMode.perForm;
        return this;
    }

    public HorizontalFormBuilder labelWidth(String s) {
        this.m_labelWidth = s;
        return this;
    }

    public HorizontalFormBuilder controlWidth(String s) {
        this.m_controlWidth = s;
        return this;
    }

    public HorizontalFormBuilder labelNowrap() {
        this.m_labelNowrap = Boolean.TRUE;
        return this;
    }

    public HorizontalFormBuilder controlNowrap() {
        this.m_controlNoWrap = Boolean.TRUE;
        return this;
    }

    public HorizontalFormBuilder nowrap() {
        this.m_labelNowrap = Boolean.TRUE;
        this.m_controlNoWrap = Boolean.TRUE;
        return this;
    }

    public HorizontalFormBuilder width(String s) {
        this.m_labelWidth = s;
        this.m_controlWidth = s;
        return this;
    }

    private static enum TableMode {
        perRow,
        perForm;

    }
}

