/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.form;

import java.util.Arrays;
import to.etc.domui.component.form.GenericTableFormBuilder;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.server.IControlLabelFactory;
import to.etc.domui.util.IReadOnlyModel;

@Deprecated
public class TabularFormBuilder
extends GenericTableFormBuilder {
    private int m_colCol;
    private String m_appendIntoSeparator;
    private String m_appendIntoDefaultSeparator;
    private Mode m_mode = Mode.NORM;
    private Mode m_nextNodeMode = Mode.NORM;
    private Mode m_nextMode;
    private int m_maxColumns;
    private int[] m_columnRowCount = new int[20];
    private int m_nextColSpan = 1;

    public TabularFormBuilder() {
    }

    public <T> TabularFormBuilder(Class<T> clz, IReadOnlyModel<T> mdl) {
        this.setClassModel(clz, mdl);
    }

    public <T> TabularFormBuilder(T instance) {
        super(instance);
    }

    @Override
    public NodeContainer finish() {
        this.m_colCol = 0;
        this.m_nextColSpan = 1;
        this.m_maxColumns = 1;
        Arrays.fill(this.m_columnRowCount, 0);
        return super.finish();
    }

    @Override
    protected IControl<?>[] addListOfProperties(boolean editable, String ... names) {
        Mode m = this.m_nextNodeMode;
        Mode nextm = this.m_nextMode;
        IControl[] res = new IControl[names.length];
        int ix = 0;
        for (String name : names) {
            this.m_nextNodeMode = m;
            res[ix] = editable ? this.addProp(name) : this.addDisplayProp(name);
            ++ix;
        }
        if (nextm != null) {
            this.m_nextNodeMode = nextm;
        }
        return res;
    }

    @Override
    public void addControl(String label, NodeBase labelnode, NodeBase[] list, boolean mandatory, boolean editable, PropertyMetaModel<?> pmm) {
        Label l = this.createLabel(label, labelnode, mandatory, editable, pmm);
        this.modalAdd(l, list, editable);
    }

    public Label createLabel(String label, NodeBase labelnode, boolean mandatory, boolean editable, PropertyMetaModel<?> pmm) {
        IControlLabelFactory clf = this.getControlLabelFactory();
        if (clf == null && (clf = this.getBuilder().getControlLabelFactory()) == null) {
            throw new IllegalStateException("Programmer error: the DomApplication instance returned a null IControlLabelFactory!?!?!?!?");
        }
        Label l = clf.createControlLabel(labelnode, label, editable, mandatory, pmm);
        return l;
    }

    @Override
    public void addControl(NodeBase label, NodeBase labelnode, NodeBase[] list, boolean mandatory, boolean editable, PropertyMetaModel<?> pmm) {
        this.modalAdd(label, list, editable);
    }

    @Override
    public void addContent(NodeBase label, NodeBase[] control, boolean editable) {
        this.modalAdd(label, control, editable);
    }

    public TabularFormBuilder norm() {
        this.m_nextNodeMode = Mode.NORM;
        this.m_nextMode = this.m_mode;
        return this;
    }

    public TabularFormBuilder append() {
        this.m_nextNodeMode = Mode.APPEND;
        this.m_nextMode = this.m_mode;
        return this;
    }

    public TabularFormBuilder into() {
        this.m_nextNodeMode = Mode.APPEND_INTO;
        this.m_nextMode = this.m_mode;
        return this;
    }

    public TabularFormBuilder into(String separator) {
        this.m_appendIntoSeparator = separator;
        return this.into();
    }

    public TabularFormBuilder col(int x) {
        return this.setCol(x);
    }

    public TabularFormBuilder setCol(int x) {
        if (x < 0 || x >= this.m_columnRowCount.length) {
            throw new IllegalArgumentException("Column number " + x + " invalid.");
        }
        this.m_colCol = x;
        if (this.m_maxColumns <= this.m_colCol) {
            this.m_maxColumns = this.m_colCol + 1;
        }
        return this;
    }

    public TabularFormBuilder colspan(int cells) {
        if (cells <= 0 || cells >= this.m_columnRowCount.length) {
            throw new IllegalArgumentException("Cell count of " + cells + " is invalid.");
        }
        this.m_nextColSpan = cells;
        return this;
    }

    public void setModeNorm() {
        this.m_mode = Mode.NORM;
        this.m_nextNodeMode = Mode.NORM;
    }

    public void setModeAppend() {
        this.m_nextNodeMode = this.m_mode = Mode.APPEND;
    }

    public void setModeAppendInto() {
        this.m_nextNodeMode = this.m_mode = Mode.APPEND_INTO;
    }

    public void setModeAppendInto(String sepa) {
        this.m_nextNodeMode = this.m_mode = Mode.APPEND_INTO;
        this.m_appendIntoDefaultSeparator = sepa;
    }

    private void modalAdd(NodeBase l, NodeBase[] ctlcontainer, boolean editable) {
        switch (this.m_nextNodeMode) {
            default: {
                throw new IllegalStateException("Invalid table insert mode: " + (Object)((Object)this.m_mode));
            }
            case NORM: {
                this.modeAddNormal(l, ctlcontainer, editable);
                break;
            }
            case APPEND: {
                this.modeAddAppend(l, ctlcontainer, editable);
                break;
            }
            case APPEND_INTO: {
                this.modeAppendInto(l, ctlcontainer, editable);
            }
        }
        if (this.m_nextMode != null) {
            this.m_nextNodeMode = this.m_nextMode;
            this.m_nextMode = null;
        }
        this.m_nextColSpan = 1;
        this.m_appendIntoSeparator = this.m_appendIntoDefaultSeparator;
    }

    @Deprecated
    private void addCells(TR tr, NodeBase l, NodeBase[] c, boolean editable) {
        TD lcell = new TD();
        tr.add(lcell);
        lcell.setCssClass("ui-f-lbl");
        if (l != null) {
            lcell.add(l);
        }
        TD ccell = new TD();
        tr.add(ccell);
        ccell.setCssClass(editable ? "ui-f-in" : "ui-f-do");
        for (NodeBase ch : c) {
            ccell.add(ch);
        }
    }

    private TD selectCell(TR row, int cellindex) {
        int curx = 0;
        int actix = 0;
        while (true) {
            int csp;
            TD td;
            if (actix >= row.getChildCount()) {
                td = new TD();
                td.setCssClass("ui-f-empty");
                row.add(td);
                ++actix;
                if (curx >= cellindex) {
                    return td;
                }
                ++curx;
                continue;
            }
            if ((csp = (td = (TD)row.getChild(actix++)).getColspan()) <= 0) {
                csp = 1;
            }
            if (curx == cellindex) {
                return td;
            }
            if (curx > cellindex) {
                throw new IllegalStateException("Internal: cellindex=" + cellindex + ", curx=" + curx + ", actual=" + actix);
            }
            if ((curx += csp) > cellindex) break;
        }
        return null;
    }

    private boolean mergeCells(TD corecell, int numcols) {
        if (numcols <= 0) {
            throw new IllegalArgumentException();
        }
        if (numcols == 1) {
            return true;
        }
        TR row = (TR)corecell.getParent();
        int ix = row.findChildIndex(corecell);
        if (ix < 0) {
            throw new IllegalStateException();
        }
        ++ix;
        TD[] cand = new TD[numcols];
        int remove = 0;
        int nleft = numcols - 1;
        while (ix < row.getChildCount() && nleft > 0) {
            TD td;
            if ((td = (TD)row.getChild(ix++)).getChildCount() != 0) {
                return false;
            }
            int csp = td.getColspan();
            if (csp <= 0) {
                csp = 1;
            }
            if ((nleft -= csp) < 0) {
                return false;
            }
            cand[remove++] = td;
        }
        while (remove > 0) {
            row.removeChild(cand[--remove]);
        }
        corecell.setColspan(numcols);
        return true;
    }

    protected void modeAddNormal(NodeBase l, NodeBase[] c, boolean editable) {
        TD inptd;
        int rowix;
        TR row;
        TD lbltd;
        this.tbody();
        int tcellix = this.m_colCol * 2;
        while ((lbltd = this.selectCell(row = this.selectRow(rowix = this.m_columnRowCount[this.m_colCol]), tcellix)) == null || (inptd = this.selectCell(row, tcellix + 1)) == null || !this.mergeCells(inptd, this.m_nextColSpan * 2 - 1)) {
        }
        this.addNodes(lbltd, inptd, l, c, editable);
        this.setLastUsedRow(row);
        this.setLastUsedCell(inptd);
    }

    private void addNodes(TD lbltd, TD inptd, NodeBase l, NodeBase[] c, boolean editable) {
        lbltd.setCssClass("ui-f-lbl");
        if (l != null) {
            lbltd.add(l);
        }
        inptd.setCssClass(editable ? "ui-f-in" : "ui-f-do");
        for (NodeBase ch : c) {
            inptd.add(ch);
        }
    }

    protected void modeAddAppend(NodeBase l, NodeBase[] c, boolean editable) {
        if (this.tbody().getChildCount() == 0 || this.getLastUsedRow() == null) {
            this.addRow();
        }
        this.addCells(this.row(), l, c, editable);
    }

    protected void modeAppendInto(NodeBase l, NodeBase[] c, boolean editable) {
        TR tr = this.row();
        if (tr.getChildCount() == 0) {
            this.modeAddNormal(l, c, editable);
            return;
        }
        TD td = (TD)tr.getChild(tr.getChildCount() - 1);
        if (this.m_appendIntoSeparator != null && this.m_appendIntoSeparator.length() > 0) {
            td.add(this.m_appendIntoSeparator);
        }
        if (l != null) {
            l.setCssClass("ui-f-lbl");
            td.add(l);
            if (this.m_appendIntoSeparator != null && this.m_appendIntoSeparator.length() > 0) {
                td.add(this.m_appendIntoSeparator);
            }
        }
        for (NodeBase nb : c) {
            td.add(nb);
        }
    }

    @Override
    public void onRowAdded(TR row) {
        int n = this.m_colCol;
        this.m_columnRowCount[n] = this.m_columnRowCount[n] + 1;
    }

    private static enum Mode {
        NORM,
        APPEND,
        APPEND_INTO;

    }
}

