/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.graph;

import javax.annotation.Nullable;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.HiddenInput;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasChangeListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Input;
import to.etc.domui.dom.html.Page;

public class ColorPickerButton
extends Div
implements IHasChangeListener,
IControl<String> {
    private Input m_hidden = new HiddenInput();
    private Div m_coldiv = new Div();
    private IValueChanged<?> m_onValueChanged;
    private boolean m_mandatory;

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-cpbt-btn");
        this.add(this.m_hidden);
        this.add(this.m_coldiv);
        if (this.m_hidden.getRawValue() == null) {
            this.m_hidden.setRawValue("ffffff");
        }
        this.m_coldiv.setBackgroundColor("#" + this.m_hidden.getRawValue());
        this.appendCreateJS("WebUI.colorPickerButton('#" + this.getActualID() + "','#" + this.m_hidden.getActualID() + "','" + this.m_hidden.getRawValue() + "'," + Boolean.valueOf(this.getOnValueChanged() != null) + ");");
    }

    @Override
    public void onAddedToPage(Page p) {
        p.addHeaderContributor(HeaderContributor.loadJavascript("$js/colorpicker.js"), 100);
    }

    @Override
    public String getValue() {
        return this.m_hidden.getRawValue();
    }

    @Override
    public String getValueSafe() {
        return this.getValue();
    }

    @Override
    public void setValue(@Nullable String value) {
        if (value == null) {
            value = "000000";
        }
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        this.m_hidden.setRawValue(value);
        this.m_coldiv.setBackgroundColor("#" + this.m_hidden.getRawValue());
        if (!this.isBuilt()) {
            return;
        }
        this.appendJavascript("$('#" + this.getActualID() + "').ColorPickerSetColor('" + value + "');");
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public void setDisabled(boolean d) {
    }

    @Override
    public boolean isReadOnly() {
        return this.isDisabled();
    }

    @Override
    public void setReadOnly(boolean ro) {
        this.setDisabled(ro);
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean ro) {
        this.m_mandatory = ro;
    }
}

