/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.graph;

import javax.annotation.Nullable;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.Input;
import to.etc.domui.dom.html.Page;

public class ColorPickerInput
extends Input
implements IControl<String> {
    private final Div m_coldiv = new Div();
    private boolean m_mandatory = true;

    @Override
    public void createContent() throws Exception {
        this.setMaxLength(6);
        this.setSize(6);
        this.m_coldiv.setCssClass("ui-cpin-div");
        this.appendAfterMe(this.m_coldiv);
        if (!this.isOff()) {
            this.appendCreateJS("WebUI.colorPickerInput('#" + this.getActualID() + "','#" + this.m_coldiv.getActualID() + "','" + this.getRawValue() + "'," + Boolean.valueOf(this.getOnValueChanged() != null) + ");");
        }
    }

    private boolean isOff() {
        return this.isDisabled() || this.isReadOnly();
    }

    @Override
    public void onAddedToPage(Page p) {
        p.addHeaderContributor(HeaderContributor.loadJavascript("$js/colorpicker.js"), 100);
    }

    @Override
    public void onRemoveFromPage(Page p) {
        this.m_coldiv.remove();
    }

    @Override
    public void setValue(@Nullable String value) {
        if (value == null) {
            value = "000000";
        }
        if (value.startsWith("#")) {
            value = value.substring(1);
        }
        this.setRawValue(value);
        this.m_coldiv.setBackgroundColor("#" + value);
        if (!this.isBuilt()) {
            return;
        }
        if (!this.isOff()) {
            this.appendJavascript("$('#" + this.getActualID() + "').ColorPickerSetColor('" + value + "');");
        }
    }

    @Override
    public String getValue() {
        String v = this.getRawValue();
        if (v == null || v.length() == 0) {
            v = "000000";
        }
        return v;
    }

    @Override
    public String getValueSafe() {
        return this.getValue();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean ro) {
        this.m_mandatory = ro;
    }

    @Override
    public void setDisabled(boolean disabled) {
        boolean wasoff = this.isOff();
        super.setDisabled(disabled);
        this.update(wasoff);
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        boolean wasoff = this.isOff();
        super.setReadOnly(readOnly);
        this.update(wasoff);
    }

    private void update(boolean old) {
        if (this.isOff() == old) {
            return;
        }
        if (this.isOff()) {
            this.appendJavascript("WebUI.colorPickerDisable('#" + this.getActualID() + "');");
        } else {
            this.appendCreateJS("WebUI.colorPickerInput('#" + this.getActualID() + "','#" + this.m_coldiv.getActualID() + "','" + this.getRawValue() + "'," + Boolean.valueOf(this.getOnValueChanged() != null) + ");");
        }
    }
}

