/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.headers;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.headers.HamburgerMenu;
import to.etc.domui.component.layout.MessageLine;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.DomUtil;

public class ExpandHeader
extends Div {
    @Nullable
    private String m_caption;
    @Nullable
    private NodeBase m_captionNode;
    private List<IUIAction<?>> m_actionList = new ArrayList();
    @Nullable
    private HoverButton m_expandButton;
    @Nullable
    private HoverButton m_hamburgerButton;
    private boolean m_expanded;
    private final Div m_content = new Div();
    @Nullable
    private INotify<Div> m_onExpand;
    @Nullable
    private HamburgerMenu m_menu;
    @Nullable
    private TD m_titleNode;
    private Type m_type = Type.NORMAL;

    public ExpandHeader() {
    }

    public ExpandHeader(String title) {
        this.m_caption = title;
    }

    public ExpandHeader(Type type, String title) {
        this.m_caption = title;
        this.m_type = type;
    }

    private String getImage(boolean expanded) {
        String base = expanded ? "THEME/btnHeaderExpanded" : "THEME/btnHeaderCollapsed";
        return base + this.m_type.name() + ".png";
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-xphd ui-xphd-" + this.m_type.name().toLowerCase());
        TBody body = this.addTable(new String[0]);
        Table table = body.getTable();
        table.setTableWidth("100%");
        table.setCssClass("ui-xphd-bar");
        HoverButton sib = this.m_expandButton = new HoverButton(this.getImage(false), new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton clickednode) throws Exception {
                ExpandHeader.this.toggleExpansion();
            }
        });
        TD td = body.addRowAndCell("ui-xphd-expandbutton");
        td.add(sib);
        td.setCellWidth("16");
        this.m_titleNode = td = body.addCell();
        NodeBase titleNode = this.getCaptionNode();
        if (null != titleNode) {
            td.add(titleNode);
        } else {
            String title = this.m_caption;
            if (null != title) {
                td.add(title);
            }
        }
        td.setCssClass("ui-xphd-ttl");
        td.setCellWidth("*");
        if (this.m_actionList.size() > 0) {
            td = body.addCell("ui-xphd-menubutton");
            td.setCellWidth("16");
            this.m_hamburgerButton = sib = new HoverButton("THEME/btnHeaderHamburger.png", new IClicked<HoverButton>(){

                @Override
                public void clicked(@Nonnull HoverButton clickednode) throws Exception {
                    ExpandHeader.this.toggleMenu();
                }
            });
            td.add(sib);
        }
        this.add(this.m_content);
        if (this.m_expanded) {
            this.expand(true);
        }
    }

    private void toggleMenu() {
        HamburgerMenu menu = this.m_menu;
        if (null == menu || menu.isClosed()) {
            System.out.println("Rendering menu");
            this.m_menu = menu = new HamburgerMenu(this.m_actionList);
            DomUtil.nullChecked(this.m_hamburgerButton).appendAfterMe(menu);
            menu.setOnSelection(action -> {
                this.m_menu = null;
                action.execute(this, null);
            });
        } else {
            menu.remove();
            this.m_menu = null;
        }
    }

    public void closeMenu() {
        HamburgerMenu menu = this.m_menu;
        if (null != menu) {
            this.m_menu = null;
            menu.remove();
        }
    }

    public void toggleExpansion() throws Exception {
        this.setExpanded(!this.m_expanded);
    }

    public void setExpanded(boolean expanded) throws Exception {
        if (this.m_expanded == expanded) {
            return;
        }
        this.expand(expanded);
    }

    private void expand(boolean expanded) throws Exception {
        this.m_expanded = expanded;
        HoverButton expandButton = this.m_expandButton;
        if (null == expandButton) {
            return;
        }
        expandButton.setSrc(this.getImage(expanded));
        if (expanded) {
            INotify<Div> onExpand = this.getOnExpand();
            if (null == onExpand) {
                this.m_content.add(new MessageLine(MsgType.ERROR, "The onExpand property, which tells me what to do when expand is pressed, is not set."));
            } else {
                onExpand.onNotify(this.m_content);
            }
            this.m_content.setDisplay(DisplayType.BLOCK);
        } else {
            this.m_content.removeAllChildren();
            this.m_content.setDisplay(DisplayType.NONE);
        }
    }

    public void setContent(@Nullable NodeBase node) {
        this.m_content.removeAllChildren();
        if (null != node) {
            this.m_content.add(node);
        }
    }

    @Nullable
    public String getCaption() {
        return this.m_caption;
    }

    public void setCaption(@Nullable String title) {
        this.m_caption = title;
        TD titleNode = this.m_titleNode;
        if (this.isBuilt() && titleNode != null) {
            titleNode.removeAllChildren();
            titleNode.add(title);
        }
    }

    public boolean isExpanded() {
        return this.m_expanded;
    }

    @Nullable
    public NodeBase getCaptionNode() {
        return this.m_captionNode;
    }

    public void setCaptionNode(@Nullable NodeBase captionNode) {
        this.m_captionNode = captionNode;
        TD titleNode = this.m_titleNode;
        if (this.isBuilt() && titleNode != null) {
            titleNode.removeAllChildren();
            if (null != captionNode) {
                titleNode.add(captionNode);
            }
        }
    }

    public List<IUIAction<?>> getActionList() {
        return this.m_actionList;
    }

    public void setActionList(List<IUIAction<?>> actionList) {
        this.forceRebuild();
        this.m_actionList = actionList;
    }

    public void clearActions() {
        this.closeMenu();
        this.m_actionList.clear();
    }

    public void addAction(IUIAction<?> action) {
        this.m_actionList.add(action);
    }

    @Nullable
    public INotify<Div> getOnExpand() {
        return this.m_onExpand;
    }

    public void setOnExpand(@Nullable INotify<Div> onExpand) {
        this.m_onExpand = onExpand;
    }

    public static enum Type {
        NORMAL,
        SMALL;

    }
}

