/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.headers;

import java.util.List;
import javax.annotation.DefaultNonNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.event.INotify;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.component.misc.CloseOnClickPanel;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Span;
import to.etc.domui.parts.GrayscalerPart;

@DefaultNonNull
public class HamburgerMenu
extends CloseOnClickPanel {
    private final List<IUIAction<?>> m_actionList;
    @Nullable
    private INotify<IUIAction<?>> m_onSelection;

    public HamburgerMenu(List<IUIAction<?>> actionList) {
        this.m_actionList = actionList;
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-hmbrg-menu");
        boolean hasicon = false;
        for (IUIAction<?> action : this.m_actionList) {
            if (action.getIcon(null) == null) continue;
            hasicon = true;
        }
        for (IUIAction<?> action : this.m_actionList) {
            this.renderAction(action, hasicon);
        }
        super.createContent();
    }

    private void renderAction(final IUIAction<?> action, boolean hasicon) throws Exception {
        Div sel = new Div();
        this.add(sel);
        sel.setCssClass("ui-hmbrg-item" + (hasicon ? " ui-hmbrg-icon" : ""));
        String icon = action.getIcon(null);
        String disable = action.getDisableReason(null);
        if (null != icon) {
            icon = this.getThemedResourceRURL(icon);
            sel.setBackgroundImage(disable == null ? icon : GrayscalerPart.getURL(icon));
        }
        Span sp = new Span("ui-hmbrg-txt", action.getName(null));
        sel.add(sp);
        if (null != disable) {
            sel.addCssClass("ui-hmbrg-disabled");
            sel.setTitle(disable);
        } else {
            sel.setClicked(new IClicked<Div>(){

                @Override
                public void clicked(@Nonnull Div clickednode) throws Exception {
                    HamburgerMenu.this.handleSelection(action);
                }
            });
        }
    }

    private void handleSelection(IUIAction<?> action) throws Exception {
        this.close();
        INotify<IUIAction<?>> onSelection = this.m_onSelection;
        if (null != onSelection) {
            onSelection.onNotify(action);
        }
    }

    @Nullable
    public INotify<IUIAction<?>> getOnSelection() {
        return this.m_onSelection;
    }

    public void setOnSelection(@Nullable INotify<IUIAction<?>> onSelection) {
        this.m_onSelection = onSelection;
    }
}

