/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.htmleditor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IDisplayControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.XmlTextNode;
import to.etc.domui.util.HtmlUtil;

public class DisplayHtml
extends Div
implements IDisplayControl<String> {
    @Nonnull
    private final XmlTextNode m_xtn = new XmlTextNode();
    private boolean m_unchecked;
    private Mode m_mode = Mode.BLOCK;

    public DisplayHtml() {
    }

    public DisplayHtml(@Nullable String value) {
        this.setValue(value);
    }

    @Override
    public void createContent() throws Exception {
        switch (this.m_mode) {
            default: {
                this.addCssClass("ui-dhtml-blk");
                break;
            }
            case INLINE: {
                this.addCssClass("ui-dhtml-inl");
                break;
            }
            case INLINEBLOCK: {
                this.addCssClass("ui-dhtml-ibl");
            }
        }
        this.add(this.m_xtn);
    }

    @Override
    public String getValue() {
        return this.m_xtn.getText();
    }

    @Override
    public void setValue(@Nullable String v) {
        if (!this.m_unchecked) {
            v = HtmlUtil.removeUnsafe(v);
        }
        this.m_xtn.setText(v);
    }

    public boolean isUnchecked() {
        return this.m_unchecked;
    }

    public void setUnchecked(boolean unchecked) {
        this.m_unchecked = unchecked;
    }

    public Mode getMode() {
        return this.m_mode;
    }

    public void setMode(Mode mode) {
        if (mode == this.m_mode) {
            return;
        }
        this.m_mode = mode;
        this.forceRebuild();
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return null;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        throw new UnsupportedOperationException("Display control");
    }

    @Override
    public String getValueSafe() {
        return this.getValue();
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void setReadOnly(boolean ro) {
    }

    @Override
    public boolean isDisabled() {
        return false;
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setMandatory(boolean ro) {
    }

    @Override
    public void setDisabled(boolean d) {
    }

    public static enum Mode {
        BLOCK,
        INLINE,
        INLINEBLOCK;

    }
}

