/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.htmleditor;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import to.etc.domui.component.htmleditor.EditorFile;
import to.etc.domui.component.htmleditor.EditorFolder;
import to.etc.domui.component.htmleditor.EditorResourceType;
import to.etc.domui.component.htmleditor.IEditorFileRef;
import to.etc.domui.component.htmleditor.IEditorFileSystem;
import to.etc.util.FileTool;
import to.etc.webapp.core.ServerTools;

public class FileBasedEditorFileSystem
implements IEditorFileSystem {
    private File m_imageRoot;
    private List<EditorResourceType> m_resources;
    private Set<String> m_imageAllowed = new HashSet<String>();
    private Set<String> m_imageDenied = new HashSet<String>();

    public FileBasedEditorFileSystem() {
        this.m_imageAllowed.add("jpg");
        this.m_imageAllowed.add("jpeg");
        this.m_imageAllowed.add("gif");
        this.m_imageAllowed.add("png");
    }

    public FileBasedEditorFileSystem(File f) {
        this();
        this.m_imageRoot = f;
    }

    @Override
    public List<?> getFilesAndFolders(String type, String path) throws Exception {
        ArrayList<Object> res = new ArrayList<Object>();
        File root = new File(this.m_imageRoot, path);
        if (root.exists() && root.isDirectory()) {
            File[] far;
            for (File f : far = root.listFiles()) {
                String name;
                String ext;
                if (f.isDirectory()) {
                    EditorFolder ef = new EditorFolder(f.getName(), f.list().length > 0, 255);
                    res.add(ef);
                    continue;
                }
                if (!f.isFile() || this.m_imageDenied.contains(ext = FileTool.getFileExtension((String)(name = f.getName())).toLowerCase()) || this.m_imageAllowed.size() != 0 && !this.m_imageAllowed.contains(ext)) continue;
                EditorFile ef = new EditorFile(name, (int)f.length(), new Date(f.lastModified()));
                res.add(ef);
            }
        }
        return res;
    }

    @Override
    public List<EditorResourceType> getResourceTypes() {
        if (this.m_resources == null) {
            this.m_resources = new ArrayList<EditorResourceType>();
            this.m_resources.add(new EditorResourceType("Images", "key=Images", 255, this.m_imageAllowed, this.m_imageDenied));
        }
        return this.m_resources;
    }

    @Override
    public boolean hasThumbnails() {
        return true;
    }

    @Override
    public IEditorFileRef getStreamRef(String type, String path) throws Exception {
        final File root = new File(this.m_imageRoot, path);
        if (!root.exists() || !root.isFile()) {
            return null;
        }
        return new IEditorFileRef(){

            @Override
            public int getSize() throws Exception {
                return (int)root.length();
            }

            @Override
            public String getMimeType() throws Exception {
                String ext = FileTool.getFileExtension((String)root.getName());
                return ServerTools.getExtMimeType((String)ext);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void copyTo(OutputStream os) throws Exception {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(root);
                    FileTool.copyFile((OutputStream)os, (InputStream)is);
                }
                finally {
                    try {
                        if (is != null) {
                            ((InputStream)is).close();
                        }
                    }
                    catch (Exception exception) {}
                }
            }

            @Override
            public void close() {
            }
        };
    }
}

