/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.htmleditor;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.html.TextArea;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.HtmlUtil;
import to.etc.util.StringTool;

public class HtmlEditor
extends TextArea {
    private String m_styleSheet;
    private String m_updateValueJS;

    @Override
    public void createContent() throws Exception {
        StringBuilder sb = new StringBuilder();
        this.appendJQuerySelector(sb);
        sb.append(".wysiwyg({css:");
        String css = this.getStyleSheet();
        StringTool.strToJavascriptString((Appendable)sb, (String)css, (boolean)false);
        sb.append(", controls: {");
        HtmlEditor.disable(sb, "separator05");
        sb.append(",");
        HtmlEditor.disable(sb, "createLink");
        sb.append(",");
        HtmlEditor.disable(sb, "insertImage");
        sb.append(",");
        HtmlEditor.disable(sb, "separator06");
        sb.append(",");
        HtmlEditor.disable(sb, "h1mozilla");
        sb.append(",");
        HtmlEditor.disable(sb, "h2mozilla");
        sb.append(",");
        HtmlEditor.disable(sb, "h3mozilla");
        sb.append(",");
        HtmlEditor.disable(sb, "h1");
        sb.append(",");
        HtmlEditor.disable(sb, "h2");
        sb.append(",");
        HtmlEditor.disable(sb, "h3");
        sb.append(",");
        HtmlEditor.disable(sb, "separator08");
        sb.append(",");
        HtmlEditor.disable(sb, "separator09");
        sb.append(",");
        HtmlEditor.disable(sb, "unLink");
        sb.append(",");
        HtmlEditor.enable(sb, "highlight");
        sb.append("}");
        sb.append(", options: {");
        sb.append("autosave: false");
        sb.append("}");
        sb.append(", plugins: {");
        sb.append("rmFormat: {rmMsWordMarkup: {enabled: true, rules: {inlineCSS: true}}}");
        sb.append("}");
        sb.append(", initialContent: ''");
        sb.append("});");
        if (this.isFocusRequested()) {
            sb.append("setTimeout(function() {");
            this.appendJQuerySelector(sb);
            sb.append(".focus();");
            sb.append("}, 500);");
        }
        this.appendCreateJS(sb);
    }

    private static void disable(StringBuilder sb, String what) {
        sb.append(what).append(": {visible:false}");
    }

    private static void enable(StringBuilder sb, String what) {
        sb.append(what).append(": {visible:true}");
    }

    protected String getStyleSheet() throws Exception {
        return this.getThemedResourceRURL(this.m_styleSheet == null ? "THEME/minieditor.css" : this.m_styleSheet);
    }

    public void setStyleSheet(String styleSheet) {
        if (DomUtil.isEqual((Object)styleSheet, (Object)this.m_styleSheet)) {
            return;
        }
        this.m_styleSheet = styleSheet;
        this.changed();
    }

    @Override
    public void onBeforeFullRender() throws Exception {
        this.setDisplay(DisplayType.BLOCK);
    }

    @Override
    public void setValue(@Nullable String v) {
        if (null != v) {
            v = HtmlUtil.removeUnsafe(v);
        }
        if (this.isBuilt()) {
            this.m_updateValueJS = v;
        }
        super.setValue(v);
    }

    @Override
    public void onBeforeRender() throws Exception {
        if (null != this.m_updateValueJS) {
            StringBuilder sb = new StringBuilder();
            this.appendJQuerySelector(sb);
            sb.append(".wysiwyg('setContent', ");
            StringTool.strToJavascriptString((Appendable)sb, (String)this.m_updateValueJS, (boolean)true);
            sb.append(");");
            this.appendJavascript(sb);
            this.m_updateValueJS = null;
        }
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) throws Exception {
        this.setDisplay(DisplayType.NONE);
        for (int i = 0; i < values.length; ++i) {
            String s = values[i];
            try {
                System.out.println("pre-value[" + i + "]=" + s);
                values[i] = HtmlUtil.removeUnsafe(s);
                System.out.println("post-value[" + i + "]=" + values[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                values[i] = e.toString();
            }
        }
        return super.acceptRequestParameter(values);
    }
}

