/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.image;

import java.io.InputStream;
import javax.annotation.Nonnull;
import to.etc.domui.caches.images.FullImage;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.IUIImageInstance;
import to.etc.domui.util.images.machines.OriginalImagePage;

public final class CachedImageInstance
implements IUIImageInstance {
    @Nonnull
    private final FullImage m_image;

    public CachedImageInstance(@Nonnull FullImage image) {
        this.m_image = image;
    }

    @Override
    public InputStream getImage() throws Exception {
        return this.m_image.getSource().getImageStream();
    }

    @Override
    public Dimension getDimension() throws Exception {
        OriginalImagePage page = this.m_image.getInfo().getPageList().get(0);
        return new Dimension(page.getWidth(), page.getHeight());
    }

    @Override
    public int getImageSize() {
        return -1;
    }

    @Override
    public String getMimeType() {
        OriginalImagePage page = this.m_image.getInfo().getPageList().get(0);
        return page.getMimeType();
    }
}

