/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.image;

import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.IUIImage;
import to.etc.domui.component.image.IUIImageInstance;
import to.etc.domui.component.input.AbstractDivControl;
import to.etc.domui.dom.html.Img;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.PageParameters;
import to.etc.util.FileTool;

public class DisplayImage
extends AbstractDivControl<IUIImage> {
    private boolean m_displayEmpty;
    private boolean m_thumbnail;
    private Dimension m_maxSize;

    public DisplayImage(@Nonnull Dimension size, boolean thumb) {
        this.setCssClass("ui-dsplyima");
        this.m_thumbnail = thumb;
        this.m_maxSize = size;
    }

    public DisplayImage() {
        this(Dimension.ICON, true);
    }

    @Override
    public void createContent() throws Exception {
        if (this.getValueSafe() == null) {
            if (this.m_displayEmpty) {
                Img img = new Img();
                this.add(img);
                img.setSrc("THEME/isct_empty.png");
            }
        } else {
            Img img = new Img();
            this.add(img);
            String url = this.getComponentDataURL("THUMB", new PageParameters("datx", System.currentTimeMillis() + ""));
            img.setSrc(url);
        }
    }

    @Override
    public void componentHandleWebDataRequest(RequestContextImpl ctx, String action) throws Exception {
        if ("THUMB".equals(action)) {
            IUIImage image = (IUIImage)this.getValueSafe();
            if (null != image) {
                this.renderImage(ctx, image);
            }
            return;
        }
        super.componentHandleWebDataRequest(ctx, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(@Nonnull RequestContextImpl ctx, @Nonnull IUIImage thumbnail) throws Exception {
        IUIImageInstance ii = thumbnail.getImage(this.m_maxSize, this.m_thumbnail);
        OutputStream os = ctx.getRequestResponse().getOutputStream(ii.getMimeType(), null, ii.getImageSize());
        InputStream is = ii.getImage();
        try {
            FileTool.copyFile((OutputStream)os, (InputStream)is);
            os.close();
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{os, is});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{os, is});
    }

    public boolean isDisplayEmpty() {
        return this.m_displayEmpty;
    }

    public void setDisplayEmpty(boolean displayEmpty) {
        if (this.m_displayEmpty == displayEmpty) {
            return;
        }
        this.m_displayEmpty = displayEmpty;
        this.forceRebuild();
    }

    public void setSize(@Nullable Dimension dimension) {
        this.m_maxSize = dimension;
        this.forceRebuild();
    }

    public void setThumbnail(@Nullable Dimension size) {
        this.m_maxSize = size == null ? Dimension.ICON : size;
        this.m_thumbnail = true;
        this.forceRebuild();
    }
}

