/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.image;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.IUIImage;
import to.etc.domui.component.image.IUIImageInstance;
import to.etc.domui.component.image.LoadedImage;
import to.etc.domui.component.misc.MessageFlare;
import to.etc.domui.component.upload.IUploadAcceptingComponent;
import to.etc.domui.component.upload.UploadPart;
import to.etc.domui.dom.errors.MsgType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.FileInput;
import to.etc.domui.dom.html.Form;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.ImgAlign;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.parts.ComponentPartRenderer;
import to.etc.domui.server.RequestContextImpl;
import to.etc.domui.state.ConversationContext;
import to.etc.domui.state.PageParameters;
import to.etc.domui.state.UIContext;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.domui.util.upload.FileUploadException;
import to.etc.domui.util.upload.UploadItem;
import to.etc.util.FileTool;
import to.etc.webapp.nls.BundleRef;

public class ImageSelectControl
extends Div
implements IUploadAcceptingComponent,
IControl<IUIImage> {
    private static final Logger LOG = LoggerFactory.getLogger(ImageSelectControl.class);
    private static final BundleRef BUNDLE = BundleRef.create(ImageSelectControl.class, (String)"messages");
    @Nullable
    private String m_emptyIcon;
    @Nonnull
    private Dimension m_displayDimensions = new Dimension(32, 32);
    @Nonnull
    private Dimension m_maxDimensions = new Dimension(1024, 1024);
    @Nullable
    private IUIImage m_value;
    private boolean m_disabled;
    private boolean m_mandatory;
    @Nullable
    private FileInput m_input;
    private boolean m_readOnly;
    private IValueChanged<?> m_onValueChanged;

    public ImageSelectControl(@Nullable IUIImage value) {
        this.m_value = value;
    }

    public ImageSelectControl() {
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-isct");
        Img img = new Img();
        this.add(img);
        img.setImgWidth(Integer.toString(this.m_displayDimensions.getWidth()));
        img.setImgHeight(Integer.toString(this.m_displayDimensions.getHeight()));
        img.setAlign(ImgAlign.LEFT);
        if (this.m_value == null) {
            String emptyIcon = this.getEmptyIcon();
            if (null == emptyIcon) {
                img.setSrc("THEME/isct_empty.png");
            } else {
                img.setSrc(emptyIcon);
            }
        } else {
            String url = this.getComponentDataURL("THUMB", new PageParameters("datx", System.currentTimeMillis() + ""));
            img.setSrc(url);
        }
        if (!this.isDisabled() && !this.isReadOnly()) {
            FileInput fi;
            this.add(" ");
            HoverButton sib = new HoverButton("THEME/48x16_isct_erase.png", new IClicked<HoverButton>(){

                @Override
                public void clicked(HoverButton clickednode) throws Exception {
                    ImageSelectControl.this.setValue(null);
                    ImageSelectControl.this.forceRebuild();
                    ImageSelectControl.this.setImageChanged();
                }
            });
            this.add(sib);
            sib.setTitle(Msgs.BUNDLE.getString("isct.empty.title"));
            this.add(" ");
            Form f = new Form();
            this.add(f);
            f.setCssClass("ui-szless ui-isct-form");
            f.setEnctype("multipart/form-data");
            f.setMethod("POST");
            StringBuilder sb = new StringBuilder();
            ComponentPartRenderer.appendComponentURL(sb, UploadPart.class, this, UIContext.getRequestContext());
            sb.append("?uniq=" + System.currentTimeMillis());
            f.setAction(sb.toString());
            this.m_input = fi = new FileInput();
            f.add(fi);
            fi.setSpecialAttribute("onchange", "WebUI.fileUploadChange(event)");
            fi.setSpecialAttribute("fuallowed", "jpg,jpeg,png");
        }
    }

    @Override
    public void componentHandleWebDataRequest(RequestContextImpl ctx, String action) throws Exception {
        if ("THUMB".equals(action)) {
            IUIImage image = this.m_value;
            if (null != image) {
                this.renderImage(ctx, image);
            }
            return;
        }
        super.componentHandleWebDataRequest(ctx, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderImage(@Nonnull RequestContextImpl ctx, @Nonnull IUIImage thumbnail) throws Exception {
        IUIImageInstance ii = thumbnail.getImage(this.m_displayDimensions, true);
        OutputStream os = ctx.getRequestResponse().getOutputStream(ii.getMimeType(), null, ii.getImageSize());
        InputStream is = ii.getImage();
        try {
            FileTool.copyFile((OutputStream)os, (InputStream)is);
            os.close();
        }
        catch (Throwable throwable) {
            FileTool.closeAll((Object[])new Object[]{os, is});
            throw throwable;
        }
        FileTool.closeAll((Object[])new Object[]{os, is});
    }

    @Override
    public boolean handleUploadRequest(RequestContextImpl param, ConversationContext conversation) throws Exception {
        FileInput fi = this.m_input;
        if (null == fi) {
            return true;
        }
        try {
            UploadItem[] uiar = param.getFileParameter(fi.getActualID());
            if (uiar != null) {
                if (uiar.length != 1) {
                    throw new IllegalStateException("Upload presented <> 1 file!?");
                }
                this.updateImage(conversation, uiar[0]);
            }
        }
        catch (FileUploadException fxu) {
            this.forceRebuild();
            MessageFlare.display((NodeContainer)this, fxu.getMessage());
            return true;
        }
        this.forceRebuild();
        this.setImageChanged();
        return true;
    }

    private void setImageChanged() throws Exception {
        if (this.m_onValueChanged != null) {
            this.m_onValueChanged.onValueChanged(this);
        }
    }

    private void updateImage(@Nonnull ConversationContext cc, @Nonnull UploadItem ui) throws Exception {
        File newUploadedImage = ui.getFile();
        cc.registerTempFile(newUploadedImage);
        try {
            this.m_value = LoadedImage.create(newUploadedImage, this.m_maxDimensions, null);
        }
        catch (Exception x) {
            MessageFlare.display(this, MsgType.ERROR, BUNDLE.getString("image.invalid"));
            LOG.error("File: " + newUploadedImage.getName() + " can't be uploaded. Looks like corrupted file", (Throwable)x);
        }
    }

    @Nonnull
    public Dimension getDisplayDimensions() {
        return this.m_displayDimensions;
    }

    public void setDisplayDimensions(@Nonnull Dimension displayDimensions) {
        this.m_displayDimensions = displayDimensions;
    }

    @Nonnull
    public Dimension getMaxDimensions() {
        return this.m_maxDimensions;
    }

    public void setMaxDimensions(@Nonnull Dimension maxDimensions) {
        this.m_maxDimensions = maxDimensions;
    }

    @Override
    @Nullable
    public IUIImage getValue() {
        return this.m_value;
    }

    @Override
    public void setValue(@Nullable IUIImage value) {
        this.m_value = value;
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public IUIImage getValueSafe() {
        return DomUtil.getValueSafe(this);
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean ro) {
        if (this.m_readOnly == ro) {
            return;
        }
        this.m_readOnly = ro;
        this.forceRebuild();
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean ro) {
        if (this.m_mandatory == ro) {
            return;
        }
        this.m_mandatory = ro;
        this.forceRebuild();
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (disabled == this.m_disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.forceRebuild();
    }

    @Nullable
    public String getEmptyIcon() {
        return this.m_emptyIcon;
    }

    public void setEmptyIcon(@Nonnull String src) {
        if (!DomUtil.isEqual((Object)src, (Object)this.m_emptyIcon)) {
            this.changed();
        }
        this.m_emptyIcon = src;
    }

    public void setEmptyIcon(@Nonnull Class<?> base, @Nonnull String resurl) {
        String s = DomUtil.getJavaResourceRURL(base, resurl);
        this.setEmptyIcon(s);
    }
}

