/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.image;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.IUIImage;
import to.etc.domui.component.image.IUIImageInstance;
import to.etc.domui.component.image.ImageSelectControl;
import to.etc.domui.component.image.LoadedImageInstance;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.images.converters.ImageConverterHelper;
import to.etc.domui.util.images.converters.ImageSpec;
import to.etc.domui.util.images.machines.ImageInfo;
import to.etc.domui.util.images.machines.ImageMagicImageHandler;
import to.etc.domui.util.images.machines.OriginalImagePage;
import to.etc.sjit.ImaTool;
import to.etc.webapp.nls.BundleRef;

public final class LoadedImage
implements IUIImage {
    private static final BundleRef BUNDLE = BundleRef.create(ImageSelectControl.class, (String)"messages");
    @Nullable
    private Long m_id;
    @Nonnull
    private final File m_source;
    @Nonnull
    private final Dimension m_dimension;
    @Nonnull
    private final String m_mime;
    @Nonnull
    private final Map<Dimension, LoadedImageInstance> m_sizeMap = new HashMap<Dimension, LoadedImageInstance>();
    @Nullable
    private final List<Object> m_resourceList;

    @Nonnull
    public static LoadedImage create(@Nonnull File original, @Nullable Dimension maxSize, @Nullable List<Object> resourceList) throws Exception {
        ImageInfo identify = ImageMagicImageHandler.getInstance().identify(original);
        if (identify.getPageCount() != 1) {
            throw new UIException(BUNDLE, "image.invalid", new Object[0]);
        }
        OriginalImagePage page = identify.getPageList().get(0);
        Dimension dimension = new Dimension(page.getWidth(), page.getHeight());
        if (maxSize != null && !maxSize.contains(dimension)) {
            ImageSpec spec = new ImageSpec(original, identify);
            ImageConverterHelper h = new ImageConverterHelper();
            ImageSpec resized = ImageMagicImageHandler.getInstance().thumbnail(h, spec, 0, maxSize.getWidth(), maxSize.getHeight(), "image/png");
            original = resized.getSource();
            if (null != resourceList) {
                resourceList.add(original);
            }
            LoadedImageInstance oli = new LoadedImageInstance(original, identify.getMime(), dimension);
            return new LoadedImage(original, resized.getMime(), new Dimension(resized.getInfo().getPage(0).getWidth(), resized.getInfo().getPage(0).getHeight()), resourceList);
        }
        return new LoadedImage(original, page.getMimeType(), new Dimension(page.getWidth(), page.getHeight()), resourceList);
    }

    private LoadedImage(@Nonnull File source, @Nonnull String mime, @Nonnull Dimension size, @Nullable List<Object> resourceList) {
        this.m_source = source;
        this.m_mime = mime;
        this.m_dimension = size;
        this.m_resourceList = resourceList;
    }

    @Override
    @Nonnull
    public IUIImageInstance getImage(@Nullable Dimension size, boolean thumbNail) throws Exception {
        java.awt.Dimension od;
        LoadedImageInstance ii;
        if (size == null) {
            Dimension dimension = size = thumbNail ? Dimension.ICON : this.m_dimension;
        }
        if (null == (ii = this.m_sizeMap.get(size = new Dimension(od = ImaTool.resizeWithAspect((int)size.getWidth(), (int)size.getHeight(), (int)this.m_dimension.getWidth(), (int)this.m_dimension.getHeight()))))) {
            if (this.m_dimension.equals(size) || size.contains(this.m_dimension)) {
                ii = new LoadedImageInstance(this.m_source, this.m_mime, this.m_dimension);
            } else {
                ImageSpec spec = new ImageSpec(this.m_source, this.m_mime, this.m_dimension.getWidth(), this.m_dimension.getHeight());
                ImageConverterHelper h = new ImageConverterHelper();
                ImageSpec resized = thumbNail ? ImageMagicImageHandler.getInstance().thumbnail(h, spec, 0, size.getWidth(), size.getHeight(), "image/png") : ImageMagicImageHandler.getInstance().scale(h, spec, 0, size.getWidth(), size.getHeight(), "image/png");
                List<Object> resourceList = this.m_resourceList;
                if (null != resourceList) {
                    resourceList.add(resized.getSource());
                }
                ii = new LoadedImageInstance(resized.getSource(), resized.getMime(), new Dimension(resized.getInfo().getPage(0).getWidth(), resized.getInfo().getPage(0).getHeight()));
            }
            this.m_sizeMap.put(size, ii);
        }
        return ii;
    }

    @Override
    @Nullable
    public Long getId() {
        return this.m_id;
    }

    @Override
    public void setId(Long id) {
        this.m_id = id;
    }

    @Nonnull
    public File getSource() {
        return this.m_source;
    }

    @Nonnull
    public String getMime() {
        return this.m_mime;
    }

    @Nonnull
    public Dimension getDimension() {
        return this.m_dimension;
    }
}

