/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.image;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import to.etc.domui.component.image.Dimension;
import to.etc.domui.component.image.IUIImageInstance;

@Immutable
public class LoadedImageInstance
implements IUIImageInstance {
    @Nonnull
    private final File m_imageFile;
    @Nonnull
    private final String m_mime;
    @Nonnull
    private final Dimension m_dimension;

    public LoadedImageInstance(@Nonnull File imageFile, @Nonnull String mime, @Nonnull Dimension dimension) {
        this.m_imageFile = imageFile;
        this.m_mime = mime;
        this.m_dimension = dimension;
    }

    @Override
    public InputStream getImage() throws Exception {
        return new FileInputStream(this.m_imageFile);
    }

    @Override
    public Dimension getDimension() {
        return this.m_dimension;
    }

    @Override
    public int getImageSize() {
        return (int)this.m_imageFile.length();
    }

    @Override
    public String getMimeType() {
        return this.m_mime;
    }
}

