/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Objects;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;

public abstract class AbstractDivControl<T>
extends Div
implements IControl<T> {
    private boolean m_readOnly;
    private boolean m_disabled;
    private String m_disabledBecause;
    private boolean m_mandatory;
    private IValueChanged<?> m_valueChanged;
    private T m_value;

    @Override
    public abstract void createContent() throws Exception;

    @Override
    public T getValueSafe() {
        try {
            return this.getValue();
        }
        catch (Exception x) {
            return null;
        }
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean m) {
        if (this.m_mandatory == m) {
            return;
        }
        this.m_mandatory = m;
        this.mandatoryChanged();
    }

    protected void mandatoryChanged() {
        this.forceRebuild();
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean ro) {
        if (ro == this.m_readOnly) {
            return;
        }
        this.m_readOnly = ro;
        this.readOnlyChanged();
    }

    protected void readOnlyChanged() {
        this.forceRebuild();
    }

    @Override
    public T getValue() {
        this.validate();
        return this.m_value;
    }

    @Nullable
    protected T internalGetValue() {
        return this.m_value;
    }

    protected void internalSetValue(@Nullable T value) {
        this.m_value = value;
    }

    protected void validate() {
    }

    @Override
    public void setValue(@Nullable T v) {
        if (MetaManager.areObjectsEqual(v, this.m_value)) {
            return;
        }
        this.m_value = v;
        this.onValueSet(v);
    }

    protected void onValueSet(@Nullable T value) {
        this.forceRebuild();
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean d) {
        if (this.m_disabled == d) {
            return;
        }
        this.m_disabled = d;
        this.disabledChanged();
    }

    @Nullable
    public final String getDisabledBecause() {
        return this.m_disabledBecause;
    }

    public final void setDisabledBecause(@Nullable String msg) {
        if (Objects.equals(msg, this.m_disabledBecause)) {
            return;
        }
        this.m_disabledBecause = msg;
        this.setOverrideTitle(msg);
        this.setDisabled(msg != null);
    }

    protected void disabledChanged() {
        this.forceRebuild();
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_valueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_valueChanged = onValueChanged;
    }
}

