/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.AbstractDivControl;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.html.Checkbox;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.SelectOption;
import to.etc.domui.util.INodeContentRenderer;

public abstract class CheckboxSetInputBase<V, T>
extends AbstractDivControl<Set<V>> {
    private List<T> m_data;
    private INodeContentRenderer<T> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Map<V, Checkbox> m_checkMap = new HashMap<V, Checkbox>();

    @Nonnull
    protected abstract V listToValue(@Nonnull T var1) throws Exception;

    public CheckboxSetInputBase() {
    }

    public CheckboxSetInputBase(@Nonnull List<T> data) {
        this.m_data = data;
    }

    public void setData(@Nullable List<T> data) {
        if (this.m_data != data) {
            this.forceRebuild();
            this.m_actualContentRenderer = null;
        }
        this.m_data = data;
    }

    @Nullable
    public List<T> getData() throws Exception {
        return this.m_data;
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-cbis");
        this.m_checkMap.clear();
        List<T> data = this.getData();
        int count = 0;
        if (null != data) {
            for (T lv : data) {
                if (count++ != 0) {
                    this.add(" ");
                }
                this.renderCheckbox(lv);
            }
        }
    }

    private void renderCheckbox(@Nonnull T lv) throws Exception {
        V listval = this.listToValue(lv);
        Checkbox cb = new Checkbox();
        Object value = this.getValue();
        if (value != null && value.contains(lv)) {
            cb.setChecked(true);
        }
        boolean disa = this.isDisabled() || this.isReadOnly();
        cb.setReadOnly(disa);
        this.add(cb);
        INodeContentRenderer<T> cr = this.m_actualContentRenderer;
        if (cr == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(lv);
            cr = this.m_actualContentRenderer;
        }
        cr.renderNodeContent(this, this, lv, cb);
        this.m_checkMap.put((Checkbox)listval, cb);
        final IValueChanged<?> ovc = this.getOnValueChanged();
        if (ovc != null) {
            cb.setClicked(new IClicked<Checkbox>(){

                @Override
                public void clicked(@Nonnull Checkbox clickednode) throws Exception {
                    ovc.onValueChanged(CheckboxSetInputBase.this);
                }
            });
        }
    }

    private INodeContentRenderer<T> calculateContentRenderer(T val) {
        if (this.m_contentRenderer != null) {
            return this.m_contentRenderer;
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(null, cmm);
    }

    protected void renderOptionLabel(SelectOption o, T object) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(object);
        }
        this.m_actualContentRenderer.renderNodeContent(this, o, object, this);
    }

    @Override
    public Set<V> getValue() {
        Set value = (Set)super.getValue();
        if (null == value) {
            value = Collections.EMPTY_SET;
        }
        this.updateValue(value);
        return value;
    }

    private void updateValue(@Nonnull Set<V> value) {
        for (Map.Entry<V, Checkbox> me : this.m_checkMap.entrySet()) {
            if (me.getValue().isChecked()) {
                value.add(me.getKey());
                continue;
            }
            value.remove(me.getKey());
        }
    }

    @Override
    public void setValue(@Nullable Set<V> v) {
        this.getValue();
        super.setValue(v);
    }

    @Override
    protected void disabledChanged() {
        boolean disa = this.isDisabled() || this.isReadOnly();
        for (Checkbox cb : this.m_checkMap.values()) {
            cb.setReadOnly(disa);
        }
    }

    @Override
    protected void readOnlyChanged() {
        this.disabledChanged();
    }
}

