/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import to.etc.domui.component.input.CriteriaComboDataSet;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.Select;
import to.etc.domui.dom.html.SelectOption;
import to.etc.domui.server.DomApplication;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.IListMaker;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.domui.util.Msgs;
import to.etc.util.WrappedException;
import to.etc.webapp.query.QCriteria;

public class ComboComponentBase<T, V>
extends Select
implements IControl<V>,
IHasModifiedIndication {
    private String m_emptyText;
    private V m_currentValue;
    private SelectOption m_emptyOption;
    private List<T> m_data;
    private INodeContentRenderer<T> m_contentRenderer;
    private INodeContentRenderer<T> m_actualContentRenderer;
    private Class<? extends INodeContentRenderer<T>> m_contentRendererClass;
    private PropertyMetaModel<?> m_propertyMetaModel;
    private IListMaker<T> m_listMaker;
    private Class<? extends IComboDataSet<T>> m_dataSetClass;
    private IComboDataSet<T> m_dataSet;
    private IValueTransformer<V> m_valueTransformer;

    public ComboComponentBase() {
    }

    public ComboComponentBase(IListMaker<T> maker) {
        this.m_listMaker = maker;
    }

    public ComboComponentBase(IComboDataSet<T> dataSet) {
        this.m_dataSet = dataSet;
    }

    public ComboComponentBase(QCriteria<T> query) {
        this.m_dataSet = new CriteriaComboDataSet<T>(query);
    }

    public ComboComponentBase(Class<? extends IComboDataSet<T>> dataSetClass) {
        this.m_dataSetClass = dataSetClass;
    }

    public ComboComponentBase(List<T> in) {
        this.m_data = in;
    }

    public ComboComponentBase(Class<? extends IComboDataSet<T>> set, INodeContentRenderer<T> r) {
        this.m_dataSetClass = set;
        this.m_contentRenderer = r;
    }

    @Override
    public void createContent() throws Exception {
        List<T> list = this.getData();
        V raw = this.internalGetCurrentValue();
        boolean isvalidselection = false;
        int ix = 0;
        ClassMetaModel cmm = null;
        for (T val : list) {
            SelectOption o = new SelectOption();
            this.add(o);
            this.renderOptionLabel(o, val);
            if (null != raw) {
                boolean eq;
                V res = this.listToValue(val);
                if (cmm == null) {
                    cmm = MetaManager.findClassMeta(raw.getClass());
                }
                if (eq = MetaManager.areObjectsEqual(res, raw, cmm)) {
                    o.setSelected(eq);
                    this.internalSetSelectedIndex(ix);
                    isvalidselection = true;
                }
            }
            ++ix;
        }
        this.setEmptyOption(null);
        if (!this.isMandatory() || !isvalidselection) {
            SelectOption o = new SelectOption();
            if (this.getEmptyText() != null) {
                o.setText(this.getEmptyText());
            }
            this.add(0, o);
            this.setEmptyOption(o);
            if (!isvalidselection) {
                o.setSelected(true);
                this.internalSetSelectedIndex(0);
            } else {
                this.internalSetSelectedIndex(this.getSelectedIndex() + 1);
            }
        }
    }

    @Override
    public final V getValue() {
        if (this.isMandatory() && this.m_currentValue == null) {
            this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.mandatory", new Object[0]));
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        this.clearMessage();
        return this.m_currentValue;
    }

    @Override
    public final void setValue(@Nullable V v) {
        V currentValue = this.m_currentValue;
        ClassMetaModel cmm = v != null ? MetaManager.findClassMeta(v.getClass()) : null;
        if (MetaManager.areObjectsEqual(v, currentValue, cmm)) {
            return;
        }
        this.m_currentValue = v;
        if (!this.isBuilt()) {
            return;
        }
        int ix = this.findListIndexForValue(v);
        if (null == v || ix < 0) {
            if (this.getEmptyOption() == null) {
                SelectOption o = new SelectOption();
                if (this.getEmptyText() != null) {
                    o.setText(this.getEmptyText());
                }
                this.add(0, o);
                this.setEmptyOption(o);
            }
            this.setSelectedIndex(0);
            return;
        }
        if (this.getEmptyOption() != null) {
            ++ix;
        }
        this.setSelectedIndex(ix);
    }

    @Override
    protected boolean internalOnUserInput(int oldindex, int nindex) {
        Object newval = nindex < 0 ? null : (this.getEmptyOption() != null ? (nindex <= 0 ? null : this.findListValueByIndex(--nindex)) : this.findListValueByIndex(nindex));
        ClassMetaModel cmm = newval == null ? null : MetaManager.findClassMeta(newval.getClass());
        V currentValue = this.m_currentValue;
        if (MetaManager.areObjectsEqual(newval, currentValue, cmm)) {
            return false;
        }
        this.m_currentValue = newval;
        return true;
    }

    private int findListIndexForValue(V newvalue) {
        if (null == newvalue) {
            return -1;
        }
        try {
            ClassMetaModel cmm = MetaManager.findClassMeta(newvalue.getClass());
            List<T> data = this.getData();
            for (int ix = 0; ix < data.size(); ++ix) {
                V value = this.listToValue(data.get(ix));
                if (!MetaManager.areObjectsEqual(value, newvalue, cmm)) continue;
                return ix;
            }
            return -1;
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    private V findListValueByIndex(int ix) {
        try {
            List<T> data = this.getData();
            if (ix < 0 || ix >= data.size()) {
                return null;
            }
            return this.listToValue(data.get(ix));
        }
        catch (Exception x) {
            throw WrappedException.wrap((Exception)x);
        }
    }

    protected V listToValue(T in) throws Exception {
        if (this.m_valueTransformer == null) {
            return (V)in;
        }
        return this.m_valueTransformer.getValue(in);
    }

    private INodeContentRenderer<T> calculateContentRenderer(Object val) {
        if (this.m_contentRenderer != null) {
            return this.m_contentRenderer;
        }
        if (this.m_contentRendererClass != null) {
            return DomApplication.get().createInstance(this.m_contentRendererClass, new Object[0]);
        }
        if (val == null) {
            throw new IllegalStateException("Cannot calculate content renderer for null value");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(val.getClass());
        return MetaManager.createDefaultComboRenderer(this.m_propertyMetaModel, cmm);
    }

    protected void renderOptionLabel(SelectOption o, T object) throws Exception {
        if (this.m_actualContentRenderer == null) {
            this.m_actualContentRenderer = this.calculateContentRenderer(object);
        }
        this.m_actualContentRenderer.renderNodeContent(this, o, object, this);
    }

    public void setData(List<T> data) {
        if (this.m_data != data) {
            this.forceRebuild();
            this.m_actualContentRenderer = null;
        }
        this.m_data = data;
    }

    public List<T> getData() throws Exception {
        if (this.m_data == null) {
            this.m_data = this.provideData();
        }
        return this.m_data;
    }

    protected List<T> provideData() throws Exception {
        if (this.m_listMaker != null) {
            return DomApplication.get().getCachedList(this.m_listMaker);
        }
        IComboDataSet<T> builder = this.m_dataSet;
        if (builder == null && this.m_dataSetClass != null) {
            builder = DomApplication.get().createInstance(this.m_dataSetClass, new Object[0]);
        }
        if (builder != null) {
            return builder.getComboDataSet(this.getPage().getBody());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public V getValueSafe() {
        return (V)DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    public Class<? extends INodeContentRenderer<T>> getContentRendererClass() {
        return this.m_contentRendererClass;
    }

    public void setContentRendererClass(Class<? extends INodeContentRenderer<T>> contentRendererClass) {
        this.m_contentRendererClass = contentRendererClass;
    }

    public PropertyMetaModel<?> getPropertyMetaModel() {
        return this.m_propertyMetaModel;
    }

    public void setPropertyMetaModel(PropertyMetaModel<?> propertyMetaModel) {
        this.m_propertyMetaModel = propertyMetaModel;
    }

    public IListMaker<T> getListMaker() {
        return this.m_listMaker;
    }

    public void setListMaker(IListMaker<T> listMaker) {
        this.m_listMaker = listMaker;
    }

    public IValueTransformer<V> getValueTransformer() {
        return this.m_valueTransformer;
    }

    public void setValueTransformer(IValueTransformer<V> valueTransformer) {
        this.m_valueTransformer = valueTransformer;
    }

    public String getEmptyText() {
        return this.m_emptyText;
    }

    public void setEmptyText(String emptyText) {
        this.m_emptyText = emptyText;
    }

    protected SelectOption getEmptyOption() {
        return this.m_emptyOption;
    }

    protected void setEmptyOption(SelectOption emptyOption) {
        this.m_emptyOption = emptyOption;
    }

    protected V internalGetCurrentValue() {
        return this.m_currentValue;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.isMandatory() == mandatory) {
            return;
        }
        super.setMandatory(mandatory);
        this.forceRebuild();
    }
}

