/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.ComboComponentBase;
import to.etc.domui.component.input.ValueLabelPair;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.trouble.UIException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.IComboDataSet;
import to.etc.domui.util.IListMaker;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.webapp.nls.NlsContext;

public class ComboFixed<T>
extends ComboComponentBase<ValueLabelPair<T>, T> {
    private static final INodeContentRenderer<ValueLabelPair<Object>> STATICRENDERER = new INodeContentRenderer<ValueLabelPair<Object>>(){

        @Override
        public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable ValueLabelPair<Object> object, @Nullable Object parameters) throws Exception {
            if (object != null) {
                node.setText(object.getLabel());
            }
        }
    };
    @Nonnull
    private static final IObjectToStringConverter<Object> TOSTRING_CV = new IObjectToStringConverter<Object>(){

        @Override
        public String convertObjectToString(Locale loc, Object in) throws UIException {
            if (null == in) {
                return "";
            }
            return String.valueOf(in);
        }
    };

    public ComboFixed() {
        this.initRenderer();
    }

    public ComboFixed(Class<? extends IComboDataSet<ValueLabelPair<T>>> set, INodeContentRenderer<ValueLabelPair<T>> r) {
        super(set, r);
    }

    public ComboFixed(Class<? extends IComboDataSet<ValueLabelPair<T>>> dataSetClass) {
        super(dataSetClass);
        this.initRenderer();
    }

    public ComboFixed(IComboDataSet<ValueLabelPair<T>> dataSet) {
        super(dataSet);
        this.initRenderer();
    }

    public ComboFixed(IListMaker<ValueLabelPair<T>> maker) {
        super(maker);
        this.initRenderer();
    }

    public ComboFixed(List<ValueLabelPair<T>> in) {
        super(in);
        this.initRenderer();
    }

    @Override
    protected T listToValue(ValueLabelPair<T> in) throws Exception {
        return in.getValue();
    }

    private void initRenderer() {
        INodeContentRenderer<ValueLabelPair<Object>> r = STATICRENDERER;
        this.setContentRenderer(r);
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(Class<T> clz, T ... exceptions) {
        Enum[] ar;
        ClassMetaModel cmm = MetaManager.findClassMeta(clz);
        ArrayList<ValueLabelPair<T>> l = new ArrayList<ValueLabelPair<T>>();
        for (Enum v : ar = (Enum[])clz.getEnumConstants()) {
            if (DomUtil.contains(exceptions, v)) continue;
            String label = cmm.getDomainLabel(NlsContext.getLocale(), v);
            if (label == null) {
                label = v.name();
            }
            l.add(new ValueLabelPair<Enum>(v, label));
        }
        return new ComboFixed<T>(l);
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(Class<?> base, String property) {
        return ComboFixed.createEnumCombo(MetaManager.getPropertyMeta(base, property));
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(PropertyMetaModel<?> pmm) {
        Enum[] var = (Enum[])pmm.getDomainValues();
        if (var == null) {
            throw new IllegalArgumentException(pmm + " is not a list-of-values domain property");
        }
        ArrayList<ValueLabelPair<T>> l = new ArrayList<ValueLabelPair<T>>();
        for (Enum v : var) {
            String label = MetaManager.getEnumLabel(pmm, v);
            l.add(new ValueLabelPair<Enum>(v, label));
        }
        return new ComboFixed<T>(l);
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(T ... items) {
        List l = ComboFixed.createEnumValueList(items);
        return new ComboFixed<T>(l);
    }

    @Nonnull
    public static <T extends Enum<T>> List<ValueLabelPair<T>> createEnumValueList(T ... items) {
        if (items.length == 0) {
            throw new IllegalArgumentException("Missing parameters");
        }
        ClassMetaModel cmm = MetaManager.findClassMeta(items[0].getClass());
        ArrayList<ValueLabelPair<T>> l = new ArrayList<ValueLabelPair<T>>();
        for (T v : items) {
            String label = cmm.getDomainLabel(NlsContext.getLocale(), v);
            if (label == null) {
                label = ((Enum)v).name();
            }
            l.add(new ValueLabelPair<T>(v, label));
        }
        return l;
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(Class<?> base, String property, T ... domainvalues) {
        return ComboFixed.createEnumCombo(MetaManager.getPropertyMeta(base, property), domainvalues);
    }

    public static <T extends Enum<T>> ComboFixed<T> createEnumCombo(PropertyMetaModel<?> pmm, T ... domainvalues) {
        if (domainvalues.length == 0) {
            throw new IllegalArgumentException("Missing parameters");
        }
        ArrayList<ValueLabelPair<T>> l = new ArrayList<ValueLabelPair<T>>();
        for (T v : domainvalues) {
            String label = MetaManager.getEnumLabel(pmm, v);
            l.add(new ValueLabelPair<T>(v, label));
        }
        return new ComboFixed<T>(l);
    }

    public static <T> ComboFixed<T> createCombo(T ... items) {
        return ComboFixed.createCombo(TOSTRING_CV, items);
    }

    public static <T> ComboFixed<T> createCombo(@Nonnull IObjectToStringConverter<T> converter, T ... items) {
        ArrayList<ValueLabelPair<T>> values = new ArrayList<ValueLabelPair<T>>();
        for (T item : items) {
            String v = converter.convertObjectToString(NlsContext.getLocale(), item);
            if (null == v) {
                v = "";
            }
            values.add(new ValueLabelPair<T>(item, v));
        }
        return new ComboFixed<T>(values);
    }
}

