/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Date;
import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.input.Text;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.TemporalPresentationType;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.DateConverter;
import to.etc.domui.converter.DateTimeConverter;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.Page;
import to.etc.domui.util.DomUtil;
import to.etc.util.DateUtil;

public class DateInput
extends Text<Date> {
    private HoverButton m_selCalButton;
    private HoverButton m_todayButton;
    private boolean m_withTime;
    private boolean m_withSeconds;
    private boolean m_hideTodayButton;

    public DateInput() {
        this(false);
    }

    public DateInput(boolean withtime) {
        super(Date.class);
        this.setCssClass("ui-di");
        this.setMaxLength(10);
        this.setSize(10);
        this.setConverter(ConverterRegistry.getConverterInstance(DateConverter.class));
        this.m_selCalButton = new HoverButton("THEME/btn-datein.png");
        this.m_selCalButton.setCssClass("ui-di-sib");
        this.setWithTime(withtime);
    }

    @Override
    public void createContent() throws Exception {
        this.m_selCalButton.setOnClickJS("WebUI.showCalendar('" + this.getActualID() + "'," + this.isWithTime() + ")");
        this.setSpecialAttribute("onblur", "WebUI.dateInputCheckInput(event);");
    }

    @Override
    public void onAddedToPage(Page p) {
        this.appendAfterMe(this.m_selCalButton);
        if (!this.m_hideTodayButton) {
            if (this.m_todayButton == null) {
                this.m_todayButton = new HoverButton("THEME/btnToday.png", new IClicked<HoverButton>(){

                    @Override
                    public void clicked(@Nonnull HoverButton b) throws Exception {
                        Date currentDate = new Date();
                        if (!DateInput.this.m_withTime) {
                            currentDate = DateUtil.truncateDate((Date)currentDate);
                        } else if (!DateInput.this.m_withSeconds) {
                            currentDate = DateUtil.truncateSeconds((Date)currentDate);
                        }
                        DomUtil.setModifiedFlag(DateInput.this);
                        DateInput.this.setValue(currentDate);
                        if (DateInput.this.getOnValueChanged() != null) {
                            DateInput.this.getOnValueChanged().onValueChanged(DateInput.this);
                        }
                    }
                });
                this.m_todayButton.setCssClass("ui-di-sib");
                this.m_todayButton.setDisplay(this.isReadOnly() || this.isDisabled() ? DisplayType.NONE : null);
            }
            this.m_selCalButton.appendAfterMe(this.m_todayButton);
        }
    }

    @Override
    public void onRemoveFromPage(Page p) {
        this.m_selCalButton.remove();
        if (this.m_todayButton != null) {
            this.m_todayButton.remove();
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        super.setReadOnly(readOnly);
        super.setDisabled(readOnly);
        this.updateCalendarButtons(readOnly ? DisplayType.NONE : DisplayType.INLINE);
    }

    @Override
    public void setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        this.updateCalendarButtons(disabled ? DisplayType.NONE : DisplayType.INLINE);
    }

    private void updateCalendarButtons(@Nonnull DisplayType displayType) {
        this.m_selCalButton.setDisplay(displayType);
        if (null != this.m_todayButton) {
            this.m_todayButton.setDisplay(displayType);
        }
    }

    public boolean isWithTime() {
        return this.m_withTime;
    }

    public void setWithTime(boolean withTime) {
        if (this.m_withTime == withTime) {
            return;
        }
        this.m_withTime = withTime;
        int len = 10;
        if (this.isWithTime()) {
            len += 6;
            if (this.isWithSeconds()) {
                len += 3;
            }
            this.setSpecialAttribute("withtime", "true");
        }
        this.setMaxLength(len);
        this.setSize(len + 1);
        if (this.isWithTime()) {
            this.setConverter(ConverterRegistry.getConverterInstance(DateTimeConverter.class));
        } else {
            this.setConverter(ConverterRegistry.getConverterInstance(DateConverter.class));
        }
    }

    public boolean isWithSeconds() {
        return this.m_withSeconds;
    }

    public void setWithSeconds(boolean withSeconds) {
        this.m_withSeconds = withSeconds;
    }

    public boolean isHideTodayButton() {
        return this.m_hideTodayButton;
    }

    public void setHideTodayButton(boolean hideTodayButton) {
        this.m_hideTodayButton = hideTodayButton;
    }

    @Nonnull
    public static DateInput createDateInput(Class<?> clz, String property, boolean editable) {
        PropertyMetaModel<Date> pmm = MetaManager.getPropertyMeta(clz, property);
        Class<?> aclz = pmm.getActualType();
        if (!Date.class.isAssignableFrom(aclz)) {
            throw new IllegalStateException("Invalid class type=" + Date.class + " for property " + pmm);
        }
        return DateInput.createDateInput(pmm, editable);
    }

    @Nonnull
    public static DateInput createDateInput(PropertyMetaModel<Date> pmm, boolean editable) {
        return DateInput.createDateInput(pmm, editable, false);
    }

    @Nonnull
    public static DateInput createDateInput(PropertyMetaModel<Date> pmm, boolean editable, boolean setDefaultErrorLocation) {
        String s;
        DateInput di = new DateInput();
        if (pmm.isRequired()) {
            di.setMandatory(true);
        }
        if (!editable) {
            di.setDisabled(true);
        }
        if (pmm.getTemporal() == TemporalPresentationType.DATETIME) {
            di.setWithTime(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            di.setTitle(s);
        }
        if (setDefaultErrorLocation) {
            di.setErrorLocation(pmm.getDefaultLabel());
        }
        return di;
    }
}

