/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.SmallImgButton;
import to.etc.domui.component.event.INotifyEvent;
import to.etc.domui.component.input.ComboLookup;
import to.etc.domui.component.layout.Window;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IReturnPressed;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.Select;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.util.DomUtil;

public class DropDownPicker<T>
extends SmallImgButton
implements IControl<T> {
    public static final int DEFAULT_COMBO_SIZE = 8;
    @Nullable
    private IValueChanged<DropDownPicker<T>> m_onValueChanged;
    @Nullable
    private List<T> m_data;
    @Nonnull
    private final ComboLookup<T> m_picker;
    private int m_size = 8;
    private int m_offsetX = 0;
    private int m_offsetY = 0;
    @Nullable
    private T m_selected;
    private boolean m_mandatory = true;
    @Nullable
    private INotifyEvent<DropDownPicker<T>, ComboLookup<T>> m_onBeforeShow;
    @Nonnull
    private HAlign m_halign = HAlign.LEFT;
    @Nullable
    private NodeBase m_alignmentBase;
    @Nonnull
    private final IClicked<SmallImgButton> m_defaultClickHandler = new IClicked<SmallImgButton>(){

        @Override
        public void clicked(@Nonnull SmallImgButton clickednode) throws Exception {
            INotifyEvent<DropDownPicker<DropDownPicker>, ComboLookup<DropDownPicker>> onBeforeShow = DropDownPicker.this.getOnBeforeShow();
            if (onBeforeShow != null) {
                onBeforeShow.onNotify(DropDownPicker.this, DropDownPicker.this.m_picker);
            }
            DropDownPicker.this.positionPicker();
            DropDownPicker.this.appendJavascript("$('#" + DropDownPicker.this.m_picker.getActualID() + "').css('display', 'inline');");
            DropDownPicker.this.appendJavascript("$('#" + DropDownPicker.this.m_picker.getActualID() + "').focus();");
            if (DropDownPicker.this.m_picker.getSelectedIndex() >= 0) {
                DropDownPicker.this.appendJavascript("WebUI.makeOptionVisible('" + DropDownPicker.this.m_picker.getOption(DropDownPicker.this.m_picker.getSelectedIndex()).getActualID() + "');");
            }
        }
    };

    public DropDownPicker() {
        this.m_picker = new ComboLookup();
    }

    public DropDownPicker(@Nonnull List<T> data) {
        this(data, 8);
    }

    public DropDownPicker(@Nonnull List<T> data, int size) {
        this.m_data = data;
        this.m_size = size;
        this.m_picker = new ComboLookup<T>(this.m_data);
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        if (this.getSrc() == null) {
            this.setSrc("THEME/btnFind.png");
        }
        this.m_picker.setDisplay(DisplayType.NONE);
        this.m_picker.setPosition(PositionType.ABSOLUTE);
        NodeBase zIndexNode = this.getParentOfTypes(Window.class, UrlPage.class);
        if (zIndexNode == null) {
            zIndexNode = this.getParent();
        }
        if (zIndexNode.getZIndex() > Integer.MIN_VALUE) {
            this.m_picker.setZIndex(zIndexNode.getZIndex() + 10);
        } else {
            this.m_picker.setZIndex(10);
        }
        this.m_picker.setSize(this.m_size);
        this.m_picker.setHeight("auto");
        this.m_picker.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase node) throws Exception {
                DropDownPicker.this.handlePickerValueChanged();
            }
        });
        this.m_picker.setReturnPressed(new IReturnPressed<Select>(){

            @Override
            public void returnPressed(@Nonnull Select node) throws Exception {
                DropDownPicker.this.handlePickerValueChanged();
            }
        });
        List<T> data = this.m_data;
        if (this.m_selected != null) {
            this.m_picker.setValue(this.m_selected);
        } else if (data != null && data.size() > 0 && this.isMandatory()) {
            this.m_picker.setValue(data.get(0));
        }
        this.m_picker.setMandatory(this.isMandatory());
        this.m_picker.setSpecialAttribute("onblur", "$(this).css('display','none');$(this).triggerHandler('click')");
        if (this.getClicked() == null) {
            this.setClicked(this.m_defaultClickHandler);
        }
        this.appendAfterMe(this.m_picker);
        this.positionPicker();
    }

    void handlePickerValueChanged() throws Exception {
        this.appendJavascript("$('#" + this.m_picker.getActualID() + "').css('display', 'none');");
        this.m_selected = this.m_picker.getValue();
        IValueChanged<DropDownPicker<DropDownPicker>> onValueChanged = this.getOnValueChanged();
        if (onValueChanged != null) {
            onValueChanged.onValueChanged(this);
        }
    }

    private void positionPicker() {
        NodeBase alignBase = this.getAlignmentBase();
        if (alignBase == null) {
            alignBase = this;
        }
        this.m_picker.alignTopToBottom(alignBase, this.m_offsetY, false);
        switch (this.m_halign) {
            case LEFT: {
                this.m_picker.alignToLeft(alignBase, this.m_offsetX, false);
                break;
            }
            case RIGHT: {
                this.m_picker.alignToRight(alignBase, this.m_offsetX, false);
                break;
            }
            case MIDDLE: {
                this.m_picker.alignToMiddle(alignBase, this.m_offsetX, false);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown horizontal alignment? Found : " + (Object)((Object)this.m_halign));
            }
        }
    }

    public int getSize() {
        return this.m_size;
    }

    public void setSize(int size) {
        this.m_size = size;
        if (this.m_picker != null) {
            this.m_picker.setSize(this.m_size);
        }
    }

    public int getOffsetX() {
        return this.m_offsetX;
    }

    public void setOffsetX(int offsetX) {
        if (this.m_offsetX != offsetX) {
            this.m_offsetX = offsetX;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public int getOffsetY() {
        return this.m_offsetY;
    }

    public void setOffsetY(int offsetY) {
        if (this.m_offsetY != offsetY) {
            this.m_offsetY = offsetY;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    @Override
    public void setValue(@Nullable T value) {
        this.m_selected = value;
        if (this.m_picker != null) {
            this.m_picker.setValue(value);
        }
    }

    @Override
    @Nullable
    public T getValue() {
        return this.m_selected;
    }

    @Nullable
    public INotifyEvent<DropDownPicker<T>, ComboLookup<T>> getOnBeforeShow() {
        return this.m_onBeforeShow;
    }

    public void setOnBeforeShow(@Nullable INotifyEvent<DropDownPicker<T>, ComboLookup<T>> onBeforeShow) {
        this.m_onBeforeShow = onBeforeShow;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (this.m_mandatory == mandatory) {
            return;
        }
        this.m_mandatory = mandatory;
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    @Nonnull
    public HAlign getHalign() {
        return this.m_halign;
    }

    public void setHalign(@Nonnull HAlign halign) {
        this.m_halign = halign;
        if (this.isBuilt()) {
            this.positionPicker();
        }
    }

    @Nullable
    public NodeBase getAlignmentBase() {
        return this.m_alignmentBase;
    }

    public void setAlignmentBase(@Nullable NodeBase halignmentBase) {
        this.m_alignmentBase = halignmentBase;
    }

    @Nonnull
    public Select getSelectControl() throws Exception {
        return this.m_picker;
    }

    @Nonnull
    private List<T> getData() {
        List<T> data = this.m_data;
        if (null == data) {
            throw new IllegalStateException("Data is null");
        }
        return data;
    }

    public boolean hasData() {
        return this.m_data != null;
    }

    public void setData(@Nonnull List<T> data) {
        if (this.m_data != data) {
            this.m_data = data;
            this.m_picker.setData(data);
            if (this.m_selected != null && !data.contains(this.m_selected)) {
                this.m_selected = null;
                this.m_picker.setValue(null);
            }
        }
    }

    @Nullable
    public IValueChanged<DropDownPicker<T>> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(@Nullable IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public T getValueSafe() {
        return DomUtil.getValueSafe(this);
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public void setReadOnly(boolean ro) {
        throw new UnsupportedOperationException("setReadOnly() not supported in " + this.getClass().getName());
    }

    public static enum HAlign {
        LEFT,
        MIDDLE,
        RIGHT;

    }
}

