/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.event.INotifyEvent;
import to.etc.domui.component.input.AutocompleteText;
import to.etc.domui.component.input.ComboLookup;
import to.etc.domui.component.input.DropDownPicker;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.util.DomUtil;
import to.etc.webapp.nls.NlsContext;

public class EditableDropDownPicker<T>
extends AutocompleteText {
    @Nullable
    private DropDownPicker<T> m_picker;
    @Nonnull
    private List<T> m_data = Collections.EMPTY_LIST;
    @Nullable
    private String m_dropDownIcon;
    @Nonnull
    private DropDownPicker.HAlign m_halign = DropDownPicker.HAlign.LEFT;
    @Nullable
    private IObjectToStringConverter<T> m_toStringConverter;
    @Nullable
    private T m_object;
    @Nonnull
    private final Class<T> m_type;

    public EditableDropDownPicker(@Nonnull Class<T> type) {
        this.m_type = type;
    }

    public EditableDropDownPicker(@Nonnull Class<T> type, @Nonnull List<T> data, @Nonnull String dropDownIcon, @Nullable IObjectToStringConverter<T> toStringConverter) {
        this(type);
        this.m_data = data;
        this.m_dropDownIcon = dropDownIcon;
        this.m_toStringConverter = toStringConverter;
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.m_picker = new DropDownPicker<T>(this.m_data);
        DropDownPicker<T> picker = this.m_picker;
        if (this.m_dropDownIcon != null && !this.isReadOnly()) {
            picker.setSrc(this.m_dropDownIcon);
        }
        picker.setMandatory(this.isMandatory());
        picker.setValue(null);
        picker.setDisabled(this.isDisabled());
        picker.setHalign(this.m_halign);
        picker.setAlignmentBase(this);
        picker.setOnBeforeShow(new INotifyEvent<DropDownPicker<T>, ComboLookup<T>>(){

            @Override
            public void onNotify(@Nonnull DropDownPicker<T> sender, @Nullable ComboLookup<T> combo) throws Exception {
                String text = (String)EditableDropDownPicker.this.getValueSafe();
                EditableDropDownPicker.this.clearMessage();
                EditableDropDownPicker.this.adjustSelection(combo, text);
            }
        });
        picker.setOnValueChanged(new IValueChanged<DropDownPicker<T>>(){

            @Override
            public void onValueChanged(@Nonnull DropDownPicker<T> component) throws Exception {
                Object value = EditableDropDownPicker.this.m_object = component.getValueSafe();
                EditableDropDownPicker.this.setValue(EditableDropDownPicker.this.convertObjectToString(NlsContext.getCurrencyLocale(), value));
                IValueChanged<?> onValueChanged = EditableDropDownPicker.this.getOnValueChanged();
                if (onValueChanged != null) {
                    onValueChanged.onValueChanged(EditableDropDownPicker.this);
                }
            }
        });
        this.setSelect(picker.getSelectControl());
        this.appendAfterMe(picker);
        picker.build();
        this.initializeJS();
    }

    protected String convertObjectToString(Locale currencyLocale, T val) {
        if (this.m_toStringConverter != null) {
            return this.m_toStringConverter.convertObjectToString(NlsContext.getCurrencyLocale(), val);
        }
        return ConverterRegistry.getConverter(this.m_type, null).convertObjectToString(NlsContext.getCurrencyLocale(), val);
    }

    private void adjustSelection(ComboLookup<T> combo, String text) throws Exception {
        boolean found = false;
        DropDownPicker<T> picker = DomUtil.nullChecked(this.m_picker);
        for (int i = 0; i < combo.getData().size(); ++i) {
            Object val = combo.getData().get(i);
            String optionText = this.convertObjectToString(NlsContext.getCurrencyLocale(), val);
            if (text == null || !text.equals(optionText)) continue;
            combo.setValue(val);
            picker.setButtonValue(text);
            found = true;
            break;
        }
        this.initSelectSizeAndValue();
        if (!found) {
            picker.setButtonValue(null);
        }
    }

    @Nonnull
    public List<T> getData() {
        return this.m_data;
    }

    private void setData(@Nonnull List<T> data) {
        if (this.m_data != data) {
            this.m_data = data;
            if (null != this.m_picker) {
                this.m_picker.setData(data);
            }
        }
    }

    public void updateData(@Nonnull List<T> data) throws Exception {
        this.setData(data);
        this.initSelectSizeAndValue();
    }

    private void initSelectSizeAndValue() throws Exception {
        if (this.isMandatory()) {
            this.setComboSize(this.getData().size());
            if (!this.getData().isEmpty() && this.getData().get(0) != null && this.m_picker != null) {
                ((ComboLookup)this.m_picker.getSelectControl()).setValue(this.getData().get(0));
            }
        } else {
            this.setComboSize(this.getData().size() + 1);
        }
    }

    private void setComboSize(int size) throws Exception {
        int newSize;
        int n = newSize = size > 8 ? 8 : size;
        if (this.m_picker != null) {
            this.m_picker.getSelectControl().setSize(newSize);
        }
    }

    @Nullable
    public String getDropDownIcon() {
        return this.m_dropDownIcon;
    }

    public void setDropDownIcon(@Nullable String dropDownIcon) {
        this.m_dropDownIcon = dropDownIcon;
        if (this.m_picker != null) {
            this.m_picker.setSrc(dropDownIcon);
        }
    }

    @Nonnull
    public DropDownPicker.HAlign getHalign() {
        return this.m_halign;
    }

    public void setHalign(@Nonnull DropDownPicker.HAlign halign) {
        this.m_halign = halign;
        if (this.m_picker != null) {
            this.m_picker.setHalign(halign);
        }
    }

    @Nullable
    public IObjectToStringConverter<T> getToStringConverter() {
        return this.m_toStringConverter;
    }

    public void setToStringConverter(@Nullable IObjectToStringConverter<T> toStringConverter) {
        this.m_toStringConverter = toStringConverter;
    }

    @Nullable
    public T getObject() {
        return this.m_object;
    }

    public void setObject(@Nullable T object) {
        this.m_object = object;
    }
}

