/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.tbl.ColumnContainer;
import to.etc.domui.component.tbl.ColumnDefList;
import to.etc.domui.component.tbl.HeaderContainer;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.SimpleColumnDef;
import to.etc.domui.component.tbl.TableModelTableBase;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IObjectToStringConverter;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.IValueTransformer;
import to.etc.webapp.nls.NlsContext;

final class KeyWordPopupRowRenderer<T>
implements IRowRenderer<T> {
    @Nullable
    private ICellClicked<?> m_rowClicked;
    private boolean m_completed;
    @Nonnull
    private final ColumnDefList<T> m_columnList;

    KeyWordPopupRowRenderer(@Nonnull ClassMetaModel cmm) {
        this.m_columnList = new ColumnDefList(cmm.getActualClass(), cmm);
    }

    private void check() {
        if (this.m_completed) {
            throw new IllegalStateException("Programmer error: This instance has been USED and cannot be changed anymore");
        }
    }

    @Override
    @Nullable
    public ICellClicked<?> getRowClicked() {
        return this.m_rowClicked;
    }

    void setRowClicked(@Nonnull ICellClicked<?> rowClicked) {
        this.m_rowClicked = rowClicked;
    }

    @Override
    public void beforeQuery(@Nonnull TableModelTableBase<T> tbl) throws Exception {
        if (this.m_columnList.size() == 0) {
            this.addDefaultColumns();
        }
        this.m_completed = true;
    }

    @Override
    public void renderHeader(@Nonnull TableModelTableBase<T> tbl, @Nonnull HeaderContainer<T> cc) throws Exception {
    }

    @Override
    public void renderRow(@Nonnull TableModelTableBase<T> tbl, @Nonnull ColumnContainer<T> cc, int index, final @Nonnull T instance) throws Exception {
        Table tblBase;
        ICellClicked<?> rowClicked = this.m_rowClicked;
        if (rowClicked != null) {
            cc.getTR().setClicked(new IClicked<TR>(){

                @Override
                public void clicked(@Nonnull TR b) throws Exception {
                    ICellClicked<?> rowClicked = KeyWordPopupRowRenderer.this.getRowClicked();
                    if (null != rowClicked) {
                        rowClicked.cellClicked(b, instance);
                    }
                }
            });
            cc.getTR().addCssClass("ui-keyword-popup-row");
        }
        if ((tblBase = cc.getTR().findParent(Table.class)) instanceof Table) {
            tblBase.setWidth("100%");
            tblBase.setOverflow(Overflow.HIDDEN);
        }
        for (SimpleColumnDef<?> simpleColumnDef : this.m_columnList) {
            this.renderColumn(tbl, cc, index, instance, simpleColumnDef);
        }
    }

    private <X> void renderColumn(TableModelTableBase<T> tbl, ColumnContainer<T> cc, int index, T instance, SimpleColumnDef<X> cd) throws Exception {
        IValueTransformer<X> vtr = cd.getValueTransformer();
        Object colval = vtr == null ? instance : vtr.getValue(instance);
        Div wrapDiv = new Div();
        wrapDiv.setCssClass("no-wrap");
        TD cell = cc.add((NodeBase)null);
        cell.add(wrapDiv);
        INodeContentRenderer<X> contentRenderer = cd.getContentRenderer();
        if (null != contentRenderer) {
            contentRenderer.renderNodeContent(tbl, wrapDiv, colval, instance);
        } else {
            IObjectToStringConverter<X> presentationConverter;
            String s = colval == null ? null : ((presentationConverter = cd.getPresentationConverter()) != null ? ((IConverter)presentationConverter).convertObjectToString(NlsContext.getLocale(), colval) : String.valueOf(colval));
            if (s != null) {
                wrapDiv.add(s);
            }
        }
        if (cd.getAlign() != null) {
            cell.setTextAlign(cd.getAlign());
        } else {
            String cssc = cd.getCssClass();
            if (cssc != null) {
                cell.addCssClass(cssc);
            }
        }
    }

    public void add(SimpleColumnDef<?> cd) {
        this.check();
        this.m_columnList.add(cd);
    }

    public <R> void addColumns(Object ... cols) {
        this.check();
        if (cols.length != 0) {
            this.m_columnList.addColumns(cols);
        }
    }

    public void addDefaultColumns() {
        this.check();
        this.m_columnList.addDefaultColumns();
    }
}

