/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.TextStr;
import to.etc.domui.component.layout.FloatingWindow;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.ILookupTypingListener;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Img;
import to.etc.domui.util.Msgs;

public class KeyWordSearchInput<T>
extends Div {
    private int m_resultsCount = -1;
    @Nonnull
    private final TextStr m_keySearch = new TextStr();
    private Div m_pnlSearchCount;
    @Nullable
    private IValueChanged<KeyWordSearchInput<T>> m_onLookupTyping;
    @Nullable
    private IValueChanged<KeyWordSearchInput<T>> m_onShowTypingResults;
    @Nullable
    public IRowRenderer<T> m_resultsHintPopupRowRenderer;
    @Nonnull
    private final Img m_imgWaiting = new Img("THEME/lui-keyword-wait.gif");
    private Div m_pnlSearchPopup;
    private int m_popupWidth;
    private boolean m_absolutePopupLayoutQuirkMode;

    public KeyWordSearchInput() {
    }

    public KeyWordSearchInput(String inputCssClass) {
        this.m_keySearch.setCssClass(inputCssClass);
    }

    @Override
    public void createContent() throws Exception {
        if (this.m_absolutePopupLayoutQuirkMode) {
            this.setPosition(PositionType.ABSOLUTE);
        } else {
            this.setPosition(PositionType.RELATIVE);
        }
        this.m_imgWaiting.setCssClass("ui-lui-waiting");
        this.m_imgWaiting.setDisplay(DisplayType.NONE);
        if (this.m_keySearch.getCssClass() == null) {
            this.m_keySearch.setCssClass("ui-lui-keyword");
        }
        this.m_keySearch.setMaxLength(40);
        this.m_keySearch.setSize(14);
        this.m_keySearch.setMarker();
        this.m_keySearch.setOnLookupTyping(new ILookupTypingListener<TextStr>(){

            @Override
            public void onLookupTyping(@Nonnull TextStr component, boolean done) throws Exception {
                if (done) {
                    if (KeyWordSearchInput.this.getOnShowResults() != null) {
                        KeyWordSearchInput.this.getOnShowResults().onValueChanged(KeyWordSearchInput.this);
                    }
                } else {
                    IValueChanged<KeyWordSearchInput<KeyWordSearchInput>> olt = KeyWordSearchInput.this.getOnLookupTyping();
                    if (olt != null) {
                        olt.onValueChanged(KeyWordSearchInput.this);
                    }
                }
            }
        });
        this.add(this.m_imgWaiting);
        this.add(this.m_keySearch);
        this.renderResultsCountPart();
    }

    @Nullable
    public IValueChanged<KeyWordSearchInput<T>> getOnLookupTyping() {
        return this.m_onLookupTyping;
    }

    public void setOnLookupTyping(@Nullable IValueChanged<KeyWordSearchInput<T>> onLookupTyping) {
        this.m_onLookupTyping = onLookupTyping;
    }

    @Nullable
    public String getKeySearchValue() {
        return (String)this.m_keySearch.getValue();
    }

    public void setResultsCount(int results) {
        if (results != this.m_resultsCount) {
            this.m_resultsCount = results;
            if (this.isBuilt()) {
                this.renderResultsCountPart();
            }
        }
    }

    private void renderResultsCountPart() {
        if (this.m_resultsCount == -1 || this.m_resultsCount == 1) {
            if (this.m_pnlSearchCount != null) {
                this.removeChild(this.m_pnlSearchCount);
            }
            this.m_pnlSearchCount = null;
        } else {
            if (this.m_pnlSearchCount == null) {
                this.m_pnlSearchCount = new Div();
                this.add(this.m_pnlSearchCount);
            }
            if (this.m_resultsCount == 0) {
                this.m_pnlSearchCount.setCssClass("ui-lui-keyword-no-res");
                this.m_pnlSearchCount.setText(Msgs.BUNDLE.getString("ui.keyword.search.no.match"));
            } else if (this.m_resultsCount == 1000) {
                this.m_pnlSearchCount.setCssClass("ui-lui-keyword-large");
                this.m_pnlSearchCount.setText(Msgs.BUNDLE.formatMessage("ui.keyword.search.large.match", new Object[]{"1000"}));
            } else {
                if (this.m_resultsCount > 1000) {
                    this.m_pnlSearchCount.setCssClass("ui-lui-keyword-large");
                } else {
                    this.m_pnlSearchCount.setCssClass("ui-lui-keyword-res");
                }
                this.m_pnlSearchCount.setText(Msgs.BUNDLE.formatMessage("ui.keyword.search.count", new Object[]{"" + this.m_resultsCount}));
            }
        }
    }

    public IValueChanged<KeyWordSearchInput<T>> getOnShowResults() {
        return this.m_onShowTypingResults;
    }

    public void setOnShowResults(IValueChanged<KeyWordSearchInput<T>> onShowResults) {
        this.m_onShowTypingResults = onShowResults;
    }

    @Override
    public void setFocus() {
        if (this.m_keySearch != null) {
            this.m_keySearch.setFocus();
        }
    }

    private void fixZIndex() {
        FloatingWindow parentFloatingWindow = this.findParent(FloatingWindow.class);
        int parentWindowZIndex = 0;
        if (parentFloatingWindow != null) {
            parentWindowZIndex = parentFloatingWindow.getZIndex();
        }
        if (parentWindowZIndex < 0) {
            parentWindowZIndex = 0;
        }
        this.setZIndex(parentWindowZIndex);
    }

    public void showResultsHintPopup(@Nullable ITableModel<T> popupResults) throws Exception {
        if (!this.isBuilt()) {
            throw new IllegalStateException("Must be built already!");
        }
        if (popupResults == null) {
            if (this.m_pnlSearchPopup != null) {
                this.removeChild(this.m_pnlSearchPopup);
                this.m_pnlSearchPopup = null;
            }
            this.fixZIndex();
            this.m_keySearch.setZIndex(this.getZIndex());
        } else {
            if (this.m_pnlSearchPopup == null) {
                this.m_pnlSearchPopup = new Div();
                this.m_pnlSearchPopup.setCssClass("ui-lui-keyword-popup");
                if (this.getPopupWidth() > 0) {
                    this.m_pnlSearchPopup.setWidth(this.getPopupWidth() + "px");
                }
                if (this.m_absolutePopupLayoutQuirkMode) {
                    this.m_pnlSearchPopup.setPosition(PositionType.ABSOLUTE);
                }
                this.fixZIndex();
                this.add(this.m_pnlSearchPopup);
            } else {
                this.m_pnlSearchPopup.removeAllChildren();
            }
            IRowRenderer<T> rhpr = this.m_resultsHintPopupRowRenderer;
            if (rhpr == null) {
                throw new IllegalStateException("Undefined m_resultsHintPopupRowRenderer!");
            }
            DataTable<T> tbl = new DataTable<T>(popupResults, rhpr);
            this.m_pnlSearchPopup.add(tbl);
            tbl.setWidth("100%");
            tbl.setOverflow(Overflow.HIDDEN);
            tbl.setPosition(PositionType.RELATIVE);
            this.m_pnlSearchPopup.setDisplay(DisplayType.NONE);
        }
    }

    public IRowRenderer<T> getResultsHintPopupRowRenderer() {
        return this.m_resultsHintPopupRowRenderer;
    }

    public void setResultsHintPopupRowRenderer(IRowRenderer<T> resultsHintPopupRowRenderer) {
        this.m_resultsHintPopupRowRenderer = resultsHintPopupRowRenderer;
    }

    @Nullable
    public String getHint() {
        return this.m_keySearch.getTitle();
    }

    public void setHint(@Nullable String hint) {
        this.m_keySearch.setTitle(hint);
    }

    public int getPopupWidth() {
        return this.m_popupWidth;
    }

    public void setPopupWidth(int popupWidth) {
        this.m_popupWidth = popupWidth;
    }

    public void setAbsolutePopupLayoutQuirkMode(boolean absolutePopupLayoutQuirkMode) {
        this.m_absolutePopupLayoutQuirkMode = absolutePopupLayoutQuirkMode;
    }
}

