/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.input.SearchInput;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Span;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class LabelSelector<T>
extends Div
implements IControl<List<T>>,
ITypedControl<T> {
    private static final int MAX_LABELS_IN_TOOLTIP = 10;
    @Nonnull
    private Class<T> m_actualClass;
    @Nonnull
    private List<T> m_labelList = new ArrayList<T>();
    @Nonnull
    private final Map<T, Span> m_divMap = new HashMap<T, Span>();
    @Nullable
    private SearchInput<T> m_input;
    @Nullable
    private INodeContentRenderer<T> m_contentRenderer;
    @Nonnull
    private final ISearch<T> m_search;
    @Nullable
    private IAllow<T> m_allowCheck;
    @Nullable
    private INew<T> m_instanceFactory;
    @Nullable
    private IValueChanged<?> m_onValueChanged;
    private boolean m_disabled;
    private boolean m_defaultTooltip = true;

    public LabelSelector(@Nonnull Class<T> clz, @Nonnull ISearch<T> search) {
        this.m_actualClass = clz;
        this.m_search = search;
        this.setCssClass("ui-lsel");
        if (search instanceof INew) {
            this.m_instanceFactory = (INew)((Object)search);
        }
    }

    @Override
    public void createContent() throws Exception {
        this.m_divMap.clear();
        for (T lbl : this.m_labelList) {
            this.add(this.createLabel(lbl));
        }
        if (!this.m_disabled) {
            this.m_input = new SearchInput<T>(this.m_actualClass, new Object[0]);
            SearchInput<T> input = this.m_input;
            this.add(input);
            this.updateTooltip();
            input.setHandler(new SearchInput.IQuery<T>(){

                @Override
                public List<T> queryFromString(String input, int max) throws Exception {
                    return LabelSelector.this.queryLabelsOnType(input, max);
                }

                @Override
                public void onSelect(T instance) throws Exception {
                    LabelSelector.this.addLabelOnInput(instance);
                }

                @Override
                public void onEnter(String value) throws Exception {
                    LabelSelector.this.insertLabel(value);
                }
            });
        }
    }

    private void updateTooltip() throws Exception {
        if (this.isDefaultTooltip()) {
            this.fillTooltipWithAvailableLabels();
        }
    }

    private void fillTooltipWithAvailableLabels() throws Exception {
        StringBuilder sb = new StringBuilder();
        List<T> availableLabels = this.getAvailableLabels();
        for (int i = 0; i < availableLabels.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(availableLabels.get(i).toString());
        }
        DomUtil.nullChecked(this.m_input).setTitle(Msgs.BUNDLE.formatMessage("ui.keyword.search.hint", new Object[]{sb.toString()}));
    }

    private List<T> queryLabelsOnType(String input, int max) throws Exception {
        if ((input = input.trim()).length() < 1) {
            return null;
        }
        return this.getLabels(input, max);
    }

    private List<T> getAvailableLabels() throws Exception {
        return this.getLabels("", 10);
    }

    private List<T> getLabels(String input, int max) throws Exception {
        List<T> isl = this.m_search.findLike(input, max + this.m_labelList.size() + 1);
        for (T tisl : this.m_labelList) {
            isl.remove(tisl);
        }
        return isl;
    }

    private void insertLabel(String value) throws Exception {
        if ((value = value.toLowerCase().trim()).length() <= 1) {
            return;
        }
        T sel = this.m_search.find(value);
        if (null != sel) {
            for (T il : this.m_labelList) {
                if (!MetaManager.areObjectsEqual(value, il)) continue;
                return;
            }
            this.addLabelOnInput(sel);
            return;
        }
        INew<T> ifa = this.m_instanceFactory;
        if (ifa == null) {
            return;
        }
        sel = ifa.create(value);
        if (null == sel) {
            return;
        }
        this.addLabelOnInput(sel);
    }

    private void addLabelOnInput(@Nonnull T instance) throws Exception {
        boolean ok;
        if (this.m_divMap.containsKey(instance)) {
            return;
        }
        if (null != this.m_allowCheck && !(ok = this.m_allowCheck.allowSelection(instance))) {
            return;
        }
        this.addItem(instance);
    }

    public void addItem(@Nonnull T instance) throws Exception {
        this.addLabel(instance);
    }

    public void setInstanceFactory(INew<T> instanceFactory) {
        this.m_instanceFactory = instanceFactory;
    }

    private void addLabel(@Nonnull T instance) throws Exception {
        if (this.m_divMap.containsKey(instance)) {
            return;
        }
        this.m_labelList.add(instance);
        Span s = this.createLabel(instance);
        if (this.m_input != null) {
            this.m_input.appendBeforeMe(s);
        } else {
            this.add(s);
        }
        this.callValueChanged();
    }

    public void removeItem(@Nonnull T instance) throws Exception {
        Span span = this.m_divMap.get(instance);
        if (span == null) {
            return;
        }
        span.remove();
        this.m_labelList.remove(instance);
        this.m_divMap.remove(instance);
    }

    private Span createLabel(final T lbl) throws Exception {
        final Span d = new Span();
        this.m_divMap.put(lbl, d);
        d.setCssClass("ui-lsel-item");
        INodeContentRenderer<T> contentRenderer = this.m_contentRenderer;
        if (contentRenderer == null) {
            d.add(lbl.toString());
        } else {
            contentRenderer.renderNodeContent(this, d, lbl, null);
        }
        if (!this.m_disabled) {
            Div btn = new Div();
            btn.setCssClass("ui-lsel-btn");
            d.add(btn);
            btn.setClicked(new IClicked<Div>(){

                @Override
                public void clicked(@Nonnull Div clickednode) throws Exception {
                    d.remove();
                    LabelSelector.this.m_labelList.remove(lbl);
                    LabelSelector.this.m_divMap.remove(lbl);
                    LabelSelector.this.callValueChanged();
                }
            });
        }
        return d;
    }

    private void callValueChanged() throws Exception {
        if (null != this.m_onValueChanged) {
            this.m_onValueChanged.onValueChanged(this);
        }
        this.updateTooltip();
    }

    public boolean isEnableAdding() {
        return false;
    }

    @Nullable
    public INodeContentRenderer<T> getContentRenderer() {
        return this.m_contentRenderer;
    }

    public void setContentRenderer(@Nullable INodeContentRenderer<T> contentRenderer) {
        this.m_contentRenderer = contentRenderer;
    }

    @Override
    public void setValue(@Nullable List<T> newlist) {
        newlist = null == newlist ? new ArrayList<T>() : new ArrayList<T>(newlist);
        this.m_labelList = newlist;
        this.m_divMap.clear();
        this.forceRebuild();
    }

    @Override
    @Nonnull
    public List<T> getValue() {
        return new ArrayList<T>(this.m_labelList);
    }

    @Override
    @Nonnull
    public List<T> getValueSafe() {
        return this.getValue();
    }

    @Override
    @Nullable
    public IValueChanged<?> getOnValueChanged() {
        return null;
    }

    @Override
    public void setOnValueChanged(@Nullable IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Override
    public boolean isReadOnly() {
        return this.isDisabled();
    }

    @Override
    public void setReadOnly(boolean ro) {
        this.setDisabled(ro);
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean d) {
        if (this.m_disabled == d) {
            return;
        }
        this.m_disabled = d;
        this.forceRebuild();
    }

    @Override
    public boolean isMandatory() {
        return false;
    }

    @Override
    public void setMandatory(boolean ro) {
    }

    @Nullable
    public IAllow<T> getAllowCheck() {
        return this.m_allowCheck;
    }

    public void setAllowCheck(@Nullable IAllow<T> allowCheck) {
        this.m_allowCheck = allowCheck;
    }

    public boolean isDefaultTooltip() {
        return this.m_defaultTooltip;
    }

    public void setDefaultTooltip(boolean defaultTooltip) {
        this.m_defaultTooltip = defaultTooltip;
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_actualClass;
    }

    public static interface IAllow<T> {
        public boolean allowSelection(@Nonnull T var1) throws Exception;
    }

    public static interface INew<T> {
        @Nullable
        public T create(@Nonnull String var1) throws Exception;
    }

    public static interface ISearch<T> {
        @Nullable
        public T find(@Nonnull String var1) throws Exception;

        @Nonnull
        public List<T> findLike(@Nonnull String var1, int var2) throws Exception;
    }
}

