/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.binding.OldBindingHandler;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.input.IActionAllowed;
import to.etc.domui.component.input.IKeyWordSearchQueryFactory;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.input.KeyWordPopupRowRenderer;
import to.etc.domui.component.input.KeyWordSearchInput;
import to.etc.domui.component.input.SimpleLookupInputRenderer;
import to.etc.domui.component.layout.FloatingWindow;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.SearchPropertyMetaModel;
import to.etc.domui.component.meta.impl.SearchPropertyMetaModelImpl;
import to.etc.domui.component.tbl.BasicRowRenderer;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IClickableRowRenderer;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.IRowRenderer;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.Table;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.LookupInputPropertyRenderer;
import to.etc.domui.util.Msgs;
import to.etc.util.RuntimeConversions;
import to.etc.util.StringTool;
import to.etc.util.WrappedException;
import to.etc.webapp.ProgrammerErrorException;
import to.etc.webapp.query.IIdentifyable;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QLiteral;
import to.etc.webapp.query.QOperation;
import to.etc.webapp.query.QOperatorNode;
import to.etc.webapp.query.QPropertyComparison;
import to.etc.webapp.query.QRestrictor;

public abstract class LookupInputBase<QT, OT>
extends Div
implements IControl<OT>,
ITypedControl<OT>,
IHasModifiedIndication {
    public static final String MAGIC_ID_MARKER = "?id?";
    public static final INodeContentRenderer<Object> DEFAULT_RENDERER = new SimpleLookupInputRenderer<Object>();
    @Nonnull
    private final Class<QT> m_queryClass;
    @Nonnull
    private final Class<OT> m_outputClass;
    @Nonnull
    private final ClassMetaModel m_queryMetaModel;
    @Nonnull
    private final ClassMetaModel m_outputMetaModel;
    @Nullable
    private LookupForm<QT> m_lookupForm;
    @Nullable
    private HoverButton m_selButton;
    @Nullable
    private HoverButton m_clearButton;
    @Nullable
    private FloatingWindow m_floater;
    @Nullable
    private DataTable<OT> m_result;
    @Nullable
    private OT m_value;
    private Table m_table;
    private boolean m_mandatory;
    private boolean m_readOnly;
    private boolean m_disabled;
    @Nullable
    private IQueryManipulator<QT> m_queryManipulator;
    @Nullable
    private IQueryHandler<QT> m_queryHandler;
    @Nullable
    private String m_formTitle;
    @Nullable
    private INodeContentRenderer<OT> m_valueRenderer;
    @Nullable
    private IErrorMessageListener m_customErrorMessageListener;
    @Nullable
    private IActionAllowed m_isLookupAllowed;
    @Nullable
    private KeyWordSearchInput<OT> m_keySearch;
    @Nullable
    private String m_keySearchHint;
    private boolean m_modifiedByUser;
    @Nullable
    private IKeyWordSearchQueryFactory<QT> m_keyWordSearchHandler;
    private boolean m_allowEmptyQuery = true;
    private boolean m_searchImmediately;
    @Nullable
    private String m_keyWordSearchCssClass;
    private int m_keyWordSearchPopupWidth;
    @Nullable
    private String m_selectionCssClass;
    private boolean m_absolutePopupLayoutQuirkMode;
    private boolean m_allowKeyWordSearch = true;
    @Nullable
    private List<SearchPropertyMetaModel> m_keywordLookupPropertyList;
    @Nullable
    private List<SearchPropertyMetaModel> m_searchPropertyList;
    @Nullable
    private RebuildCause m_rebuildCause;
    private boolean m_useStretchedLayout = true;
    @Nullable
    private ILookupFormModifier<QT> m_lookupFormInitialization;
    @Nullable
    private IClickableRowRenderer<OT> m_formRowRenderer;
    @Nullable
    private IClickableRowRenderer<OT> m_actualFormRowRenderer;
    @Nullable
    private KeyWordPopupRowRenderer<OT> m_dropdownRowRenderer;
    @Nullable
    private QCriteria<QT> m_rootCriteria;
    private boolean m_doFocus;
    @Nullable
    private IValueChanged<?> m_onValueChanged;

    @Nonnull
    protected abstract ITableModel<OT> createTableModel(@Nonnull QCriteria<QT> var1) throws Exception;

    public LookupInputBase(@Nonnull Class<QT> queryClass, @Nonnull Class<OT> resultClass, String ... resultColumns) {
        this(queryClass, resultClass, (ClassMetaModel)null, (ClassMetaModel)null);
        this.setResultColumns(resultColumns);
    }

    public LookupInputBase(@Nonnull Class<QT> queryClass, @Nonnull Class<OT> resultClass) {
        this(queryClass, resultClass, (ClassMetaModel)null, (ClassMetaModel)null);
    }

    public LookupInputBase(@Nonnull QCriteria<QT> rootCriteria, @Nonnull Class<OT> resultClass) {
        this(DomUtil.nullChecked(rootCriteria.getBaseClass()), resultClass, (ClassMetaModel)null, (ClassMetaModel)null);
        this.m_rootCriteria = rootCriteria;
    }

    public LookupInputBase(@Nonnull Class<QT> queryClass, @Nonnull Class<OT> resultClass, @Nullable ClassMetaModel queryMetaModel, @Nullable ClassMetaModel outputMetaModel) {
        this.m_queryClass = queryClass;
        this.m_outputClass = resultClass;
        this.m_queryMetaModel = queryMetaModel != null ? queryMetaModel : MetaManager.findClassMeta(queryClass);
        this.m_outputMetaModel = outputMetaModel != null ? outputMetaModel : MetaManager.findClassMeta(resultClass);
        HoverButton b = this.m_selButton = new HoverButton("THEME/btn-hover-popuplookup.png");
        b.addCssClass("ui-lui-sel-btn");
        b.setTestID("selButtonInputLookup");
        b.setClicked(new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase b) throws Exception {
                LookupInputBase.this.toggleFloaterByClick();
            }
        });
        b = this.m_clearButton = new HoverButton("THEME/btn-hover-ClearLookup.png", new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton b) throws Exception {
                LookupInputBase.this.handleSetValue(null);
            }
        });
        b.addCssClass("ui-lui-clear-btn");
        b.setTestID("clearButtonInputLookup");
        b.setDisplay(DisplayType.NONE);
        this.setCssClass("ui-lui");
    }

    @Nonnull
    private HoverButton getSelButton() {
        if (null != this.m_selButton) {
            return this.m_selButton;
        }
        throw new IllegalStateException("Selection button is not there.");
    }

    @Nonnull
    public HoverButton getClearButton() {
        if (null != this.m_clearButton) {
            return this.m_clearButton;
        }
        throw new IllegalStateException("Clear button is not there.");
    }

    @Override
    public void createContent() throws Exception {
        this.m_table = new Table();
        this.m_table.setCellSpacing("0");
        this.m_table.setCellPadding("0");
        this.add(this.m_table);
        this.m_keySearch = null;
        this.removeCssClass("ui-ro");
        if (this.m_value == null && this.isAllowKeyWordSearch() && this.isKeyWordSearchDefined()) {
            if (this.isReadOnly() || this.isDisabled()) {
                this.renderEmptySelection();
                this.addCssClass("ui-ro");
            } else {
                this.renderKeyWordSearch(this.m_selButton);
            }
        } else {
            INodeContentRenderer<Object> r = this.getValueRenderer();
            if (r == null) {
                r = DEFAULT_RENDERER;
            }
            r.renderNodeContent(this, this, this.m_value, this.isReadOnly() || this.isDisabled() ? null : this.m_selButton);
            this.handleSelectionCss();
        }
        HoverButton clearButton = this.getClearButton();
        if (!this.isReadOnly() && !this.isDisabled()) {
            if (!this.getSelButton().isAttached()) {
                TBody tb = this.m_table.getBody();
                TR tr = tb.getChildCount() == 0 ? tb.addRow() : (TR)tb.getChild(0);
                TD cell = tr.addCell();
                cell.add(this.getSelButton());
            }
            this.getSelButton().appendAfterMe(clearButton);
        }
        if (this.m_rebuildCause == RebuildCause.CLEAR) {
            if (this.m_keySearch != null) {
                this.m_keySearch.setFocus();
            }
        } else if (this.m_rebuildCause == RebuildCause.SELECT && clearButton != null && clearButton.getDisplay() != DisplayType.NONE && this.getPage().getFocusComponent() == null) {
            clearButton.setFocus();
        }
        this.m_rebuildCause = null;
        if (this.m_doFocus) {
            this.m_doFocus = false;
            if (this.m_keySearch != null) {
                this.m_keySearch.setFocus();
            } else if (this.m_clearButton != null) {
                this.m_clearButton.setFocus();
            }
        }
        if (this.m_absolutePopupLayoutQuirkMode) {
            this.getSelButton().setMarginLeft("103px");
        }
    }

    private void handleSelectionCss() {
        String selectionCssClass = this.getSelectionCssClass();
        if (!StringTool.isBlank((String)selectionCssClass)) {
            this.getParent().appendShowOverflowTextAsTitleJs("." + selectionCssClass + " td.ui-lui-vcell");
        }
    }

    private void appendParameters(@Nonnull TD cell, @Nonnull Object parameters) {
        TD tdParameters = new TD();
        cell.appendAfterMe(tdParameters);
        tdParameters.setCssClass("ui-lui-btntd");
        tdParameters.setValign(TableVAlign.TOP);
        tdParameters.add((NodeBase)parameters);
    }

    private void renderEmptySelection() {
        TD td = this.m_table.getBody().addRowAndCell();
        td.setValign(TableVAlign.TOP);
        td.setCssClass("ui-lui-v");
        String txt = Msgs.BUNDLE.getString("ui.lookup.empty");
        td.add(txt);
    }

    private boolean isKeyWordSearchDefined() {
        if (this.getKeyWordSearchHandler() != null) {
            return true;
        }
        if (this.m_keywordLookupPropertyList != null) {
            return true;
        }
        List<SearchPropertyMetaModel> spml = this.getQueryMetaModel().getKeyWordSearchProperties();
        return spml.size() > 0;
    }

    private void renderKeyWordSearch(@Nullable Object parameters) {
        TD td = this.m_table.getBody().addRowAndCell();
        td.setValign(TableVAlign.TOP);
        td.setCssClass("ui-lui-v");
        this.addKeySearchField(td);
        if (parameters != null) {
            this.appendParameters(td, parameters);
        }
    }

    private void addKeySearchField(NodeContainer parent) {
        this.m_keySearch = new KeyWordSearchInput<OT>(this.m_keyWordSearchCssClass);
        KeyWordSearchInput<OT> ks = this.m_keySearch;
        ks.setPopupWidth(this.getKeyWordSearchPopupWidth());
        ks.setAbsolutePopupLayoutQuirkMode(this.m_absolutePopupLayoutQuirkMode);
        KeyWordPopupRowRenderer<OT> rr = this.getDropdownRowRenderer();
        rr.setRowClicked(new ICellClicked<OT>(){

            @Override
            public void cellClicked(@Nonnull NodeBase tr, @Nonnull OT val) throws Exception {
                LookupInputBase.this.handleSetValue(val);
            }
        });
        ks.setResultsHintPopupRowRenderer(rr);
        ks.setOnLookupTyping(new IValueChanged<KeyWordSearchInput<OT>>(){

            @Override
            public void onValueChanged(@Nonnull KeyWordSearchInput<OT> component) throws Exception {
                ITableModel keySearchModel = LookupInputBase.this.searchKeyWord(component.getKeySearchValue());
                component.showResultsHintPopup(null);
                if (keySearchModel == null) {
                    component.setResultsCount(-1);
                    component.setFocus();
                    return;
                }
                if (keySearchModel.getRows() == 1) {
                    LookupInputBase.this.handleSetValue(keySearchModel.getItems(0, 1).get(0));
                } else {
                    component.setResultsCount(keySearchModel.getRows());
                    if (keySearchModel.getRows() > 0 && keySearchModel.getRows() < 10) {
                        component.showResultsHintPopup(keySearchModel);
                    }
                }
            }
        });
        ks.setOnShowResults(new IValueChanged<KeyWordSearchInput<OT>>(){

            @Override
            public void onValueChanged(@Nonnull KeyWordSearchInput<OT> component) throws Exception {
                ITableModel keySearchModel = LookupInputBase.this.searchKeyWord(component.getKeySearchValue());
                component.showResultsHintPopup(null);
                if (keySearchModel == null) {
                    component.setResultsCount(-1);
                    LookupInputBase.this.toggleFloater(null);
                    return;
                }
                if (keySearchModel.getRows() == 1) {
                    LookupInputBase.this.handleSetValue(keySearchModel.getItems(0, 1).get(0));
                } else {
                    component.setResultsCount(keySearchModel.getRows());
                    LookupInputBase.this.toggleFloater(keySearchModel);
                }
            }
        });
        parent.add(ks);
        if (this.m_keyWordSearchCssClass != null) {
            this.addCssClass(this.m_keyWordSearchCssClass);
        }
        ks.setHint(Msgs.BUNDLE.formatMessage("ui.keyword.search.hint", new Object[]{this.m_keySearchHint != null ? this.m_keySearchHint : this.getDefaultKeySearchHint()}));
    }

    @Nonnull
    private KeyWordSearchInput<OT> getKeySearch() {
        if (null != this.m_keySearch) {
            return this.m_keySearch;
        }
        throw new IllegalStateException("keySearch is null");
    }

    @Nonnull
    private KeyWordPopupRowRenderer<OT> getDropdownRowRenderer() {
        if (null == this.m_dropdownRowRenderer) {
            this.m_dropdownRowRenderer = new KeyWordPopupRowRenderer(this.getOutputMetaModel());
        }
        return DomUtil.nullChecked(this.m_dropdownRowRenderer);
    }

    private String getDefaultKeySearchHint() {
        List<SearchPropertyMetaModel> spml;
        List<SearchPropertyMetaModel> list = spml = this.m_keywordLookupPropertyList != null ? this.m_keywordLookupPropertyList : this.getQueryMetaModel().getKeyWordSearchProperties();
        if (spml.size() <= 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder(128);
        for (int i = 0; i < spml.size(); ++i) {
            SearchPropertyMetaModel spm;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            if (null == (spm = spml.get(i))) {
                throw new IllegalStateException("null entry in keyword search list");
            }
            if (spm.getLookupLabel() != null) {
                sb.append(spm.getLookupLabel());
                continue;
            }
            String propertyName = spm.getPropertyName();
            if (propertyName == null) {
                throw new IllegalStateException("Search property name is null");
            }
            PropertyMetaModel<?> pmm = this.getQueryMetaModel().findProperty(propertyName);
            if (pmm == null) {
                throw new IllegalStateException(propertyName + ": undefined property in " + this.getQueryMetaModel());
            }
            if (pmm.getDefaultLabel() != null) {
                sb.append(pmm.getDefaultLabel());
                continue;
            }
            sb.append(pmm.getName());
        }
        return sb.toString();
    }

    @Nullable
    private ITableModel<OT> searchKeyWord(@Nullable String searchString) throws Exception {
        if (searchString == null || searchString.trim().length() == 0) {
            return null;
        }
        Long magicId = this.getMagicString(searchString = DomUtil.nullChecked(searchString.replace("*", "%")));
        QCriteria<QT> searchQuery = magicId != null ? this.createTestQuery(magicId) : this.createStandardQuery(searchString);
        if (searchQuery == null) {
            return null;
        }
        if ((searchQuery = this.manipulateCriteria(searchQuery)) == null) {
            return null;
        }
        return this.createTableModel(searchQuery);
    }

    @Nullable
    private Long getMagicString(@Nonnull String searchString) {
        if (searchString.startsWith(MAGIC_ID_MARKER) && searchString.endsWith(MAGIC_ID_MARKER)) {
            try {
                int l = MAGIC_ID_MARKER.length();
                String id = searchString.substring(l, searchString.length() - l);
                return Long.valueOf(id.trim());
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private QCriteria<QT> createTestQuery(@Nonnull Long magicId) throws Exception {
        if (IIdentifyable.class.isAssignableFrom(this.m_queryClass)) {
            QCriteria<?> searchQuery = this.getQueryMetaModel().createCriteria();
            searchQuery.eq("id", (Object)magicId);
            return searchQuery;
        }
        throw new RuntimeException("This instance cannot be used for filling in lookup using magic string: " + this.m_queryClass);
    }

    @Nullable
    private QCriteria<QT> createStandardQuery(String searchString) throws Exception {
        Object searchQuery;
        IKeyWordSearchQueryFactory<QT> ksh = this.getKeyWordSearchHandler();
        if (ksh != null) {
            searchQuery = ksh.createQuery(searchString);
            if (searchQuery == null) {
                return null;
            }
        } else {
            if ((searchString = DomUtil.nullChecked(searchString.replace("*", "%"))).startsWith("$$") && searchString.length() > 2) {
                Class<?> pkType;
                Object pk;
                String idString = searchString.substring(2);
                PropertyMetaModel<?> primaryKey = this.getQueryMetaModel().getPrimaryKey();
                if (null != primaryKey && null != (pk = RuntimeConversions.convertTo((Object)idString, pkType = primaryKey.getActualType()))) {
                    QCriteria<?> searchQuery2 = this.getQueryMetaModel().createCriteria();
                    searchQuery2.eq(primaryKey.getName(), pk);
                    return searchQuery2;
                }
            }
            List<SearchPropertyMetaModel> spml = this.m_keywordLookupPropertyList == null ? this.getQueryMetaModel().getKeyWordSearchProperties() : this.getKeywordLookupPropertyList();
            searchQuery = this.getQueryMetaModel().createCriteria();
            QRestrictor r = searchQuery.or();
            int ncond = 0;
            if (spml.size() > 0) {
                for (SearchPropertyMetaModel spm : spml) {
                    if (spm.getMinLength() > searchString.length()) continue;
                    if (spm.getPropertyName() == null) {
                        throw new ProgrammerErrorException("The quick lookup properties for " + this.getQueryMetaModel() + " are invalid: the property name is null");
                    }
                    List<PropertyMetaModel<?>> pl = MetaManager.parsePropertyPath(this.getQueryMetaModel(), spm.getPropertyName());
                    if (pl.size() == 0) {
                        throw new ProgrammerErrorException("Unknown/unresolvable lookup property " + spm.getPropertyName() + " on " + this.getQueryMetaModel());
                    }
                    PropertyMetaModel<?> pmm = pl.get(pl.size() - 1);
                    if (DomUtil.isIntegerType(pmm.getActualType()) || pmm.getActualType() == BigDecimal.class) {
                        if (searchString.contains("%") && !pmm.isTransient()) {
                            r.add((QOperatorNode)new QPropertyComparison(QOperation.LIKE, spm.getPropertyName(), (QOperatorNode)new QLiteral((Object)searchString)));
                            continue;
                        }
                        try {
                            Object value = RuntimeConversions.convertTo((Object)searchString, pmm.getActualType());
                            if (null == value) continue;
                            r.eq(spm.getPropertyName(), value);
                            ++ncond;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    if (!pmm.getActualType().isAssignableFrom(String.class)) continue;
                    if (spm.isIgnoreCase()) {
                        r.ilike(spm.getPropertyName(), (Object)(searchString + "%"));
                    } else {
                        r.like(spm.getPropertyName(), (Object)(searchString + "%"));
                    }
                    ++ncond;
                }
            }
            if (ncond == 0) {
                return null;
            }
        }
        return searchQuery;
    }

    @Nullable
    private QCriteria<QT> manipulateCriteria(@Nonnull QCriteria<QT> enteredCriteria) {
        IQueryManipulator<QT> qm = this.getQueryManipulator();
        QCriteria<QT> result = enteredCriteria;
        if (qm != null && (result = qm.adjustQuery(enteredCriteria)) == null) {
            return null;
        }
        QCriteria<QT> root = this.m_rootCriteria;
        if (null != root) {
            result.mergeCriteria(root);
        }
        return result;
    }

    private void toggleFloaterByClick() throws Exception {
        if (this.m_keySearch != null) {
            this.toggleFloater(this.searchKeyWord(this.m_keySearch.getKeySearchValue()));
        } else {
            this.toggleFloater(null);
        }
    }

    private void toggleFloater(@Nullable ITableModel<OT> keySearchModel) throws Exception {
        LookupForm<QT> lf;
        if (this.m_floater != null) {
            this.m_floater.close();
            this.m_floater = null;
            this.m_result = null;
            return;
        }
        if (this.m_isLookupAllowed != null && !this.m_isLookupAllowed.isAllowed()) {
            return;
        }
        final FloatingWindow f = this.m_floater = FloatingWindow.create(this, this.getFormTitle() == null ? this.getDefaultTitle() : this.getFormTitle());
        f.setWidth("740px");
        f.setHeight("90%");
        f.setIcon("THEME/ttlFind.png");
        f.setTestID(this.getTestID() + "_floaterWindowLookupInput");
        IErrorMessageListener cerl = this.m_customErrorMessageListener;
        if (cerl != null && cerl instanceof NodeBase) {
            f.setErrorFence();
            f.add((NodeBase)((Object)cerl));
            DomUtil.getMessageFence(f).addErrorListener(cerl);
        }
        if ((lf = this.getLookupForm()) == null) {
            QCriteria<QT> rootCriteria = this.m_rootCriteria;
            lf = null != rootCriteria ? new LookupForm<QT>(rootCriteria, new String[0]) : new LookupForm<QT>(this.getQueryClass(), this.getQueryMetaModel(), new String[0]);
            if (this.m_searchPropertyList != null && this.m_searchPropertyList.size() != 0) {
                lf.setSearchProperties(this.m_searchPropertyList);
            }
        }
        lf.setCollapsed(keySearchModel != null && keySearchModel.getRows() > 0);
        lf.forceRebuild();
        if (this.getLookupFormInitialization() != null) {
            this.getLookupFormInitialization().initialize(lf);
        }
        f.add(lf);
        f.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                f.clearGlobalMessage("v.missing.search");
                LookupInputBase.this.m_floater = null;
                LookupInputBase.this.m_result = null;
            }
        });
        lf.setClicked(new IClicked<LookupForm<QT>>(){

            @Override
            public void clicked(@Nonnull LookupForm<QT> b) throws Exception {
                LookupInputBase.this.search(b);
            }
        });
        lf.setOnCancel(new IClicked<LookupForm<QT>>(){

            @Override
            public void clicked(@Nonnull LookupForm<QT> b) throws Exception {
                f.closePressed();
            }
        });
        if (keySearchModel != null && keySearchModel.getRows() > 0) {
            this.setResultModel(keySearchModel);
        } else if (this.isSearchImmediately()) {
            this.search(lf);
        }
    }

    @Nonnull
    private String getDefaultTitle() {
        String entity = this.getOutputMetaModel().getUserEntityName();
        if (entity != null) {
            return Msgs.BUNDLE.formatMessage("ui.lui.ttl.wen", new Object[]{entity});
        }
        return Msgs.BUNDLE.getString("ui.lui.ttl");
    }

    @Nonnull
    public FloatingWindow getFloater() {
        if (null != this.m_floater) {
            return this.m_floater;
        }
        throw new IllegalStateException("Floating search window is not currently present");
    }

    private void search(LookupForm<QT> lf) throws Exception {
        QCriteria<QT> c = lf.getEnteredCriteria();
        if (c == null) {
            return;
        }
        if ((c = this.manipulateCriteria(c)) == null) {
            return;
        }
        this.getFloater().clearGlobalMessage("v.missing.search");
        if (!lf.hasUserDefinedCriteria() && !this.isAllowEmptyQuery()) {
            this.getFloater().addGlobalMessage(UIMessage.error(Msgs.BUNDLE, "v.missing.search", new Object[0]));
            return;
        }
        this.getFloater().clearGlobalMessage();
        this.setTableQuery(c);
    }

    private void setTableQuery(@Nonnull QCriteria<QT> qc) throws Exception {
        ITableModel<OT> model = this.createTableModel(qc);
        this.setResultModel(model);
    }

    private void setResultModel(@Nonnull ITableModel<OT> model) throws Exception {
        DataTable<OT> dt = this.m_result;
        if (dt == null) {
            this.m_result = new DataTable<OT>(model, this.getActualFormRowRenderer());
            dt = this.m_result;
            this.getFloater().add(dt);
            dt.setPageSize(20);
            dt.setTableWidth("100%");
            this.initSelectionModel();
            if (this.isUseStretchedLayout()) {
                dt.setStretchHeight(true);
            }
            DataPager pg = new DataPager(this.m_result);
            this.getFloater().add(pg);
            dt.setTestID("resultTableLookupInput");
        } else {
            dt.setModel(model);
        }
    }

    protected void initSelectionModel() throws Exception {
    }

    @Nonnull
    public IRowRenderer<OT> getActualFormRowRenderer() {
        IClickableRowRenderer<OT> actualFormRowRenderer = this.m_actualFormRowRenderer;
        if (null == actualFormRowRenderer) {
            this.m_actualFormRowRenderer = this.getFormRowRenderer();
            actualFormRowRenderer = this.m_actualFormRowRenderer;
            if (null == actualFormRowRenderer) {
                this.m_actualFormRowRenderer = new BasicRowRenderer<OT>(this.getOutputClass(), this.getOutputMetaModel(), new Object[0]);
                actualFormRowRenderer = this.m_actualFormRowRenderer;
            }
            actualFormRowRenderer.setRowClicked(new ICellClicked<OT>(){

                @Override
                public void cellClicked(@Nonnull NodeBase tr, @Nonnull OT val) throws Exception {
                    LookupInputBase.this.getFloater().clearGlobalMessage("v.missing.search");
                    if (!LookupInputBase.this.getDataTable().isMultiSelectionVisible()) {
                        LookupInputBase.this.toggleFloater(null);
                    }
                    LookupInputBase.this.handleSetValue(val);
                }
            });
        }
        return actualFormRowRenderer;
    }

    public void setHint(@Nonnull String text) {
        if (this.m_selButton != null) {
            this.m_selButton.setTitle(text);
        }
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_readOnly;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        if (this.m_readOnly == readOnly) {
            return;
        }
        this.m_readOnly = readOnly;
        this.updateRoStyle();
        this.forceRebuild();
    }

    private void updateRoStyle() {
        if ((this.m_disabled || this.m_readOnly) && this.m_value != null) {
            this.addCssClass("ui-lui-selected-ro");
        } else {
            this.removeCssClass("ui-lui-selected-ro");
        }
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        if (this.m_disabled == disabled) {
            return;
        }
        this.m_disabled = disabled;
        this.updateRoStyle();
        this.forceRebuild();
    }

    @Override
    @Nullable
    public OT getValue() {
        if (this.m_value == null && this.isMandatory()) {
            this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.mandatory", new Object[0]));
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        return this.m_value;
    }

    @Override
    @Nullable
    public OT getValueSafe() {
        return (OT)DomUtil.getValueSafe(this);
    }

    public OT getWorkValue() {
        OT valueSafe = this.getValueSafe();
        this.clearMessage();
        return valueSafe;
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    @Override
    public void setValue(@Nullable OT v) {
        KeyWordSearchInput<OT> ks = this.m_keySearch;
        if (DomUtil.isEqual(this.m_value, v) && (ks == null || ks.getKeySearchValue() == null)) {
            return;
        }
        OT old = this.m_value;
        this.m_value = v;
        if (v != null) {
            this.getClearButton().setDisplay(DisplayType.INLINE);
            this.clearMessage();
            this.setCssClass("ui-lui-selected");
            String selectionCss = this.getSelectionCssClass();
            if (!StringTool.isBlank((String)selectionCss)) {
                this.addCssClass(DomUtil.nullChecked(selectionCss));
            }
        } else {
            this.getClearButton().setDisplay(DisplayType.NONE);
            this.setCssClass("ui-lui");
        }
        this.updateRoStyle();
        this.forceRebuild();
    }

    void handleSetValue(@Nullable OT value) throws Exception {
        if (!MetaManager.areObjectsEqual(value, this.m_value, null)) {
            DomUtil.setModifiedFlag(this);
            this.setValue(value);
            try {
                OldBindingHandler.controlToModel(this);
            }
            catch (Exception x) {
                throw WrappedException.wrap((Exception)x);
            }
            IValueChanged<?> onValueChanged = this.getOnValueChanged();
            if (onValueChanged != null) {
                onValueChanged.onValueChanged(this);
            }
        }
        this.m_rebuildCause = value == null ? RebuildCause.CLEAR : RebuildCause.SELECT;
    }

    @Override
    @Nullable
    public IValueChanged<?> getOnValueChanged() {
        if (this.m_floater != null) {
            return null;
        }
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(@Nullable IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    @Nullable
    public IQueryManipulator<QT> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    @Nullable
    public IQueryHandler<QT> getQueryHandler() {
        return this.m_queryHandler;
    }

    public void setQueryHandler(@Nullable IQueryHandler<QT> queryHandler) {
        this.m_queryHandler = queryHandler;
    }

    @Nullable
    public String getFormTitle() {
        return this.m_formTitle;
    }

    public void setFormTitle(@Nullable String lookupTitle) {
        this.m_formTitle = lookupTitle;
    }

    public boolean isAllowEmptyQuery() {
        return this.m_allowEmptyQuery;
    }

    public void setAllowEmptyQuery(boolean allowEmptyQuery) {
        this.m_allowEmptyQuery = allowEmptyQuery;
    }

    public void setQueryManipulator(@Nullable IQueryManipulator<QT> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    @Nullable
    public LookupForm<QT> getLookupForm() {
        return this.m_lookupForm;
    }

    public void setLookupForm(@Nullable LookupForm<QT> externalLookupForm) {
        this.m_lookupForm = externalLookupForm;
    }

    @Nullable
    public IErrorMessageListener getCustomErrorMessageListener() {
        return this.m_customErrorMessageListener;
    }

    public void setCustomErrorMessageListener(@Nullable IErrorMessageListener customErrorMessageListener) {
        this.m_customErrorMessageListener = customErrorMessageListener;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    @Nullable
    public IActionAllowed getIsLookupAllowed() {
        return this.m_isLookupAllowed;
    }

    public void setIsLookupAllowed(@Nullable IActionAllowed isLookupAllowed) {
        this.m_isLookupAllowed = isLookupAllowed;
    }

    @Nullable
    public IKeyWordSearchQueryFactory<QT> getKeyWordSearchHandler() {
        return this.m_keyWordSearchHandler;
    }

    public void setKeyWordSearchHandler(@Nullable IKeyWordSearchQueryFactory<QT> keyWordSearchManipulator) {
        this.m_keyWordSearchHandler = keyWordSearchManipulator;
    }

    @Nullable
    public String getKeyWordSearchCssClass() {
        return this.m_keyWordSearchCssClass;
    }

    public void setKeyWordSearchCssClass(@Nullable String cssClass) {
        this.m_keyWordSearchCssClass = cssClass;
    }

    @Nullable
    public String getSelectionCssClass() {
        return this.m_selectionCssClass;
    }

    public void setSelectionCssClass(@Nullable String cssClass) {
        this.m_selectionCssClass = cssClass;
    }

    public boolean isAllowKeyWordSearch() {
        return this.m_allowKeyWordSearch;
    }

    public void setAllowKeyWordSearch(boolean allowKeyWordSearch) {
        this.m_allowKeyWordSearch = allowKeyWordSearch;
    }

    @Nullable
    public String getKeySearchHint() {
        return this.m_keySearchHint;
    }

    public void setKeySearchHint(@Nullable String keySearchHint) {
        this.m_keySearchHint = keySearchHint;
        if (this.m_keySearch != null) {
            this.m_keySearch.setHint(keySearchHint);
        }
    }

    public void addKeywordProperty(@Nonnull String name, int minlen) {
        if (this.m_keywordLookupPropertyList == null) {
            this.m_keywordLookupPropertyList = new ArrayList<SearchPropertyMetaModel>();
        }
        SearchPropertyMetaModelImpl si = new SearchPropertyMetaModelImpl(this.getQueryMetaModel());
        if (minlen > 0) {
            si.setMinLength(minlen);
        }
        si.setPropertyName(name);
        si.setIgnoreCase(true);
        DomUtil.nullChecked(this.m_keywordLookupPropertyList).add(si);
    }

    public void setKeywordSearchProperties(@Nonnull List<SearchPropertyMetaModel> keywordLookupPropertyList) {
        this.m_keywordLookupPropertyList = keywordLookupPropertyList;
    }

    @Nonnull
    public List<SearchPropertyMetaModel> getKeywordLookupPropertyList() {
        if (null != this.m_keywordLookupPropertyList) {
            return this.m_keywordLookupPropertyList;
        }
        throw new NullPointerException("No keyword properties set.");
    }

    public List<SearchPropertyMetaModel> getSearchProperties() {
        return this.m_searchPropertyList;
    }

    public void setSearchProperties(List<SearchPropertyMetaModel> searchPropertyList) {
        this.m_searchPropertyList = searchPropertyList;
    }

    public void addKeywordProperty(@Nonnull String name) {
        this.addKeywordProperty(name, -1);
    }

    @Deprecated
    @Nonnull
    public Table getTable() {
        if (this.m_table == null) {
            throw new IllegalStateException("m_table is not created yet!");
        }
        return this.m_table;
    }

    @Deprecated
    @Nonnull
    public TBody getBody() {
        if (this.m_table == null) {
            throw new IllegalStateException("m_table is not created yet!");
        }
        return this.m_table.getBody();
    }

    public int getKeyWordSearchPopupWidth() {
        return this.m_keyWordSearchPopupWidth;
    }

    public void setKeyWordSearchPopupWidth(int keyWordSearchPopupWidth) {
        this.m_keyWordSearchPopupWidth = keyWordSearchPopupWidth;
    }

    public void setAbsolutePopupLayoutQuirkMode(boolean value) {
        this.m_absolutePopupLayoutQuirkMode = value;
    }

    public boolean isUseStretchedLayout() {
        return this.m_useStretchedLayout;
    }

    public void setUseStretchedLayout(boolean value) {
        if (value == this.m_useStretchedLayout) {
            return;
        }
        this.m_useStretchedLayout = value;
        if (this.isBuilt()) {
            this.forceRebuild();
        }
    }

    public ILookupFormModifier<QT> getLookupFormInitialization() {
        return this.m_lookupFormInitialization;
    }

    public void setLookupFormInitialization(ILookupFormModifier<QT> lookupFormInitialization) {
        this.m_lookupFormInitialization = lookupFormInitialization;
    }

    @Nonnull
    public Class<OT> getOutputClass() {
        return this.m_outputClass;
    }

    @Override
    @Nonnull
    public Class<OT> getActualType() {
        return this.m_outputClass;
    }

    @Nonnull
    public Class<QT> getQueryClass() {
        return this.m_queryClass;
    }

    @Nonnull
    public ClassMetaModel getOutputMetaModel() {
        return this.m_outputMetaModel;
    }

    @Nonnull
    public ClassMetaModel getQueryMetaModel() {
        return this.m_queryMetaModel;
    }

    public void setValueColumns(String ... columns) {
        this.setValueRenderer(new LookupInputPropertyRenderer<OT>(this.getOutputClass(), columns));
    }

    @Nullable
    public INodeContentRenderer<OT> getValueRenderer() {
        return this.m_valueRenderer;
    }

    public void setValueRenderer(@Nullable INodeContentRenderer<OT> contentRenderer) {
        this.m_valueRenderer = contentRenderer;
    }

    public void addFormColumns(Object ... columns) {
        IRowRenderer<OT> rr = this.getActualFormRowRenderer();
        if (!(rr instanceof BasicRowRenderer)) {
            throw new IllegalStateException("The row renderer for the form is set to something else than a BasicRowRenderer.");
        }
        ((BasicRowRenderer)rr).addColumns(columns);
    }

    public void addDropdownColumns(Object ... columns) {
        this.getDropdownRowRenderer().addColumns(columns);
    }

    public void setResultColumns(String ... resultColumns) {
        this.addDropdownColumns(resultColumns);
        this.addFormColumns(resultColumns);
    }

    public boolean isSearchImmediately() {
        return this.m_searchImmediately;
    }

    public void setSearchImmediately(boolean searchImmediately) {
        this.m_searchImmediately = searchImmediately;
        if (searchImmediately) {
            this.setAllowEmptyQuery(true);
        }
    }

    @Nullable
    public IClickableRowRenderer<OT> getFormRowRenderer() {
        return this.m_formRowRenderer;
    }

    public void setFormRowRenderer(@Nullable IClickableRowRenderer<OT> lookupFormRenderer) {
        this.m_formRowRenderer = lookupFormRenderer;
    }

    protected DataTable<OT> getDataTable() {
        return this.m_result;
    }

    protected void closePopup() throws Exception {
        if (this.m_floater != null) {
            this.toggleFloater(null);
        }
    }

    protected boolean isPopupShown() {
        return this.m_floater != null;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    public void setFocus() {
        if (null != this.m_keySearch) {
            this.m_keySearch.setFocus();
        } else if (!this.isBuilt()) {
            this.m_doFocus = true;
        }
    }

    private static enum RebuildCause {
        CLEAR,
        SELECT;

    }

    public static interface ILookupFormModifier<T> {
        public void initialize(@Nonnull LookupForm<T> var1) throws Exception;
    }
}

