/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.HoverButton;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.input.LookupInput;
import to.etc.domui.component.input.LookupInputBase;
import to.etc.domui.component.layout.Window;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.component.tbl.DefaultSelectAllHandler;
import to.etc.domui.component.tbl.ISelectionListener;
import to.etc.domui.component.tbl.InstanceSelectionModel;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IValueChanged;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Label;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class MultipleLookupInput<T>
extends Div
implements IControl<List<T>>,
ITypedControl<T> {
    private final Map<T, NodeContainer> m_itemNodes = new HashMap<T, NodeContainer>();
    private List<T> m_selectionList = Collections.EMPTY_LIST;
    private boolean m_mandatory;
    private boolean m_disabled;
    private IValueChanged<?> m_onValueChanged;
    private final MultiLookupInput m_lookupInput;
    private Div m_selectionContainer;
    private INodeContentRenderer<T> m_selectedItemRenderer;
    private String[] m_renderColumns;
    private String m_cssForSelectedItems;
    private String m_cssForSelectionContainer;
    private String m_maxHeightForSelectionContainer;
    private HoverButton m_clearButton;
    private Stack<Integer> m_updateStack = new Stack();
    private final INodeContentRenderer<T> DEFAULT_RENDERER = new INodeContentRenderer<T>(){

        @Override
        public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable T object, @Nullable Object parameters) throws Exception {
            ClassMetaModel cmm;
            if (node == null || !(node instanceof Label)) {
                throw new IllegalArgumentException("Expected Label but found: " + node);
            }
            if (object != null && (cmm = MetaManager.findClassMeta(object.getClass())) != null) {
                List<ExpandedDisplayProperty<?>> xpl = null;
                String[] cols = MultipleLookupInput.this.m_renderColumns;
                if (cols != null && cols.length > 0) {
                    xpl = ExpandedDisplayProperty.expandProperties(cmm, cols);
                } else {
                    List<DisplayPropertyMetaModel> l = cmm.getTableDisplayProperties();
                    if (l.size() > 0) {
                        xpl = ExpandedDisplayProperty.expandDisplayProperties(l, cmm, null);
                    }
                }
                if (xpl != null && xpl.size() > 0) {
                    xpl = ExpandedDisplayProperty.flatten(xpl);
                    String display = "";
                    String hint = "";
                    for (ExpandedDisplayProperty<?> xp : xpl) {
                        String val = xp.getPresentationString(object);
                        if (val == null || val.length() == 0) continue;
                        display = display + (display.length() == 0 ? val : ", " + val);
                        hint = hint + (hint.length() == 0 ? xp.getDefaultLabel() : ", " + xp.getDefaultLabel());
                    }
                    node.setText(display);
                    node.setTitle(hint);
                } else {
                    node.setText(object.toString());
                }
            }
        }
    };

    public MultipleLookupInput(@Nonnull Class<T> clazz, String ... renderColumns) {
        this.m_lookupInput = new MultiLookupInput(clazz, renderColumns);
        this.m_lookupInput.setLookupFormInitialization(new LookupInputBase.ILookupFormModifier<T>(){
            private boolean initialized = false;

            @Override
            public void initialize(@Nonnull LookupForm<T> lf) throws Exception {
                if (!this.initialized) {
                    DefaultButton confirm = new DefaultButton(Msgs.BUNDLE.getString("lookupform.confirm"));
                    confirm.setIcon("THEME/btnConfirm.png");
                    confirm.setTestID("confirmButton");
                    confirm.setClicked(new IClicked<NodeBase>(){

                        @Override
                        public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                            MultipleLookupInput.this.m_lookupInput.closePopup();
                            MultipleLookupInput.this.addSelection();
                        }
                    });
                    lf.addButtonItem(confirm, 800);
                    this.initialized = true;
                }
            }
        });
        this.m_renderColumns = renderColumns;
        this.m_clearButton = new HoverButton("THEME/btn-hover-ClearMultipleLookup.png", new IClicked<HoverButton>(){

            @Override
            public void clicked(@Nonnull HoverButton b) throws Exception {
                MultipleLookupInput.this.clearSelection(null);
            }
        });
        this.m_clearButton.setTestID("clearButtonInputLookup");
        this.m_clearButton.setDisplay(DisplayType.NONE);
        this.m_clearButton.addCssClass("ui-lui-clear-mul-btn");
    }

    private void addSelection() throws Exception {
        this.startUpdate();
        for (Object item : this.m_lookupInput.getSelectedItems()) {
            this.addSelection(item);
        }
        this.endUpdate();
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_lookupInput.getActualType();
    }

    protected void clearSelection(Object object) throws Exception {
        this.startUpdate();
        this.m_selectionList.clear();
        this.m_itemNodes.clear();
        this.m_selectionContainer.removeAllChildren();
        this.applyIE10Workaround();
        this.endUpdate();
    }

    protected void applyIE10Workaround() {
        Span dummySpan = new Span();
        this.m_selectionContainer.add(dummySpan);
    }

    private void addClearButton() throws Exception {
        List<HoverButton> btns;
        if (!this.m_lookupInput.isBuilt()) {
            this.m_lookupInput.build();
        }
        if ((btns = this.m_lookupInput.getDeepChildren(HoverButton.class)).size() > 0) {
            btns.get(btns.size() - 1).appendAfterMe(this.m_clearButton);
        } else {
            this.m_lookupInput.appendAfterMe(this.m_clearButton);
        }
        this.updateClearButtonState();
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.add(this.m_lookupInput);
        this.m_lookupInput.setOnValueChanged(new IValueChanged<LookupInput<T>>(){

            @Override
            public void onValueChanged(@Nonnull LookupInput<T> component) throws Exception {
                Object item = component.getValueSafe();
                if (item != null) {
                    DomUtil.setModifiedFlag(component);
                    MultipleLookupInput.this.addSelection(item);
                    component.setValue(null);
                    MultipleLookupInput.this.addClearButton();
                    IValueChanged<?> ovc = MultipleLookupInput.this.getOnValueChanged();
                    if (ovc != null) {
                        ovc.onValueChanged(MultipleLookupInput.this);
                    }
                    component.setFocus();
                }
            }
        });
        this.renderSelection();
        this.addClearButton();
        if ((this.isDisabled() || this.isReadOnly()) && !this.getValueSafe().isEmpty()) {
            this.m_lookupInput.setDisplay(DisplayType.NONE);
        }
    }

    public void addSelection(T item) throws Exception {
        if (this.m_selectionList == Collections.EMPTY_LIST) {
            this.m_selectionList = new ArrayList<T>();
        }
        if (!this.m_selectionList.contains(item)) {
            this.startUpdate();
            this.m_selectionList.add(item);
            Span itemNode = this.createItemNode(item);
            this.m_selectionContainer.add(itemNode);
            this.m_itemNodes.put(item, itemNode);
            this.endUpdate();
        }
    }

    public void startUpdate() {
        this.m_updateStack.push(this.m_selectionList.size());
    }

    public void endUpdate() throws Exception {
        if (this.m_updateStack.isEmpty()) {
            throw new IllegalStateException("Update stack can not be empty!");
        }
        Integer val = this.m_updateStack.pop();
        if (this.m_updateStack.isEmpty()) {
            IValueChanged<?> ovc;
            DomUtil.setModifiedFlag(this);
            this.updateClearButtonState();
            int currentSize = this.m_selectionList.size();
            if (currentSize != val && (ovc = this.getOnValueChanged()) != null) {
                ovc.onValueChanged(this);
            }
        }
    }

    private void renderSelection() throws Exception {
        this.m_selectionContainer = new Div();
        if (this.getCssForSelectionContainer() != null) {
            this.m_selectionContainer.setCssClass(this.getCssForSelectionContainer());
        } else {
            this.m_selectionContainer.setCssClass("ui-mli-cnt");
        }
        String maxHeightForSelectionContainer = this.getMaxHeightForSelectionContainer();
        if (null != maxHeightForSelectionContainer) {
            this.m_selectionContainer.setMaxHeight(maxHeightForSelectionContainer);
        }
        for (T item : this.m_selectionList) {
            Span itemNode = this.createItemNode(item);
            this.m_itemNodes.put(item, itemNode);
            this.m_selectionContainer.add(itemNode);
        }
        this.add(this.m_selectionContainer);
    }

    private Span createItemNode(final T item) throws Exception {
        Span itemNode = new Span();
        Label itemText = new Label();
        if (this.getCssForSelectedItems() != null) {
            itemNode.setCssClass(this.getCssForSelectedItems());
        } else {
            itemNode.setCssClass("ui-mli-itm");
        }
        Img imgClose = new Img("THEME/btnClose.png");
        itemNode.add(itemText);
        itemNode.add(imgClose);
        IClicked<NodeBase> removeHandler = new IClicked<NodeBase>(){

            @Override
            public void clicked(@Nonnull NodeBase clickednode) throws Exception {
                MultipleLookupInput.this.removeItem(item);
            }
        };
        imgClose.setClicked(removeHandler);
        INodeContentRenderer<T> r = this.getSelectedItemContentRenderer();
        if (r == null) {
            r = this.DEFAULT_RENDERER;
        }
        r.renderNodeContent(this, itemText, item, null);
        return itemNode;
    }

    @Nonnull
    public LookupInput<T> getMultipleLookupInput() {
        return this.m_lookupInput;
    }

    protected void updateClearButtonState() {
        this.m_clearButton.setDisplay(this.m_selectionList.size() == 0 ? DisplayType.NONE : DisplayType.INLINE);
    }

    public LookupInput<T> getLookupInput() {
        return this.m_lookupInput;
    }

    @Override
    public List<T> getValueSafe() {
        return this.m_selectionList;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public boolean isReadOnly() {
        return this.m_disabled;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        this.m_mandatory = mandatory;
    }

    @Override
    public void setReadOnly(boolean ro) {
        if (this.m_disabled != ro) {
            this.m_disabled = ro;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    @Override
    public List<T> getValue() {
        return this.m_selectionList;
    }

    @Override
    public void setValue(@Nullable List<T> v) {
        if (this.m_selectionList != v) {
            this.m_selectionList = v;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    @Override
    public void setDisabled(boolean d) {
        this.setReadOnly(d);
    }

    @Override
    public IValueChanged<?> getOnValueChanged() {
        return this.m_onValueChanged;
    }

    @Override
    public void setOnValueChanged(IValueChanged<?> onValueChanged) {
        this.m_onValueChanged = onValueChanged;
    }

    public INodeContentRenderer<T> getSelectedItemContentRenderer() {
        return this.m_selectedItemRenderer;
    }

    public void setSelectedItemContentRenderer(INodeContentRenderer<T> render) {
        if (this.m_selectedItemRenderer != render) {
            this.m_selectedItemRenderer = render;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public String[] getRenderColumns() {
        return this.m_renderColumns;
    }

    public void setRenderColumns(String[] renderColumns) {
        if (this.m_renderColumns != renderColumns) {
            this.m_renderColumns = renderColumns;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public String getCssForSelectedItems() {
        return this.m_cssForSelectedItems;
    }

    public void setCssForSelectedItems(String cssForSelectedItems) {
        if (this.m_cssForSelectedItems != cssForSelectedItems) {
            this.m_cssForSelectedItems = cssForSelectedItems;
            if (this.isBuilt()) {
                this.forceRebuild();
            }
        }
    }

    public String getCssForSelectionContainer() {
        return this.m_cssForSelectionContainer;
    }

    public void setCssForSelectionContainer(String cssForSelectionContainer) {
        this.m_cssForSelectionContainer = cssForSelectionContainer;
    }

    public String getMaxHeightForSelectionContainer() {
        return this.m_maxHeightForSelectionContainer;
    }

    public void setMaxHeightForSelectionContainer(String height) {
        this.m_maxHeightForSelectionContainer = height;
    }

    public void removeItem(T item) throws Exception {
        this.startUpdate();
        NodeBase itemNode = this.m_itemNodes.get(item);
        itemNode.remove();
        this.m_selectionList.remove(item);
        this.endUpdate();
    }

    public void setSearchImmediately(boolean searchImmediately) {
        this.m_lookupInput.setSearchImmediately(searchImmediately);
    }

    @Nullable
    public List<T> getBindValue() {
        Object val = this.getValue();
        if ((val == null || val.isEmpty()) && this.isMandatory()) {
            throw new ValidationException("ui.mandatory", new Object[0]);
        }
        return val;
    }

    public void setBindValue(@Nullable List<T> value) {
        this.setValue(value);
    }

    private class MultiLookupInput
    extends LookupInput<T> {
        private InstanceSelectionModel<T> m_isSelectionModel;

        public MultiLookupInput(Class<T> lookupClass, String[] resultColumns) {
            super(lookupClass, resultColumns);
        }

        @Override
        protected void initSelectionModel() throws Exception {
            this.m_isSelectionModel = new InstanceSelectionModel(true);
            this.getDataTable().setSelectionModel(this.m_isSelectionModel);
            this.getDataTable().setShowSelection(this.m_isSelectionModel.isMultiSelect());
            this.getDataTable().setSelectionAllHandler(new DefaultSelectAllHandler());
            this.m_isSelectionModel.addListener(new ISelectionListener<T>(){

                @Override
                public void selectionChanged(@Nonnull T row, boolean on) throws Exception {
                    MultiLookupInput.this.showSelectedCount();
                }

                @Override
                public void selectionAllChanged() throws Exception {
                    MultiLookupInput.this.showSelectedCount();
                }
            });
        }

        public Collection<T> getSelectedItems() {
            return this.m_isSelectionModel != null ? this.m_isSelectionModel.getSelectedSet() : Collections.EMPTY_SET;
        }

        public void showSelectedCount() throws IllegalStateException {
            int selectionCount = this.m_isSelectionModel.getSelectionCount();
            Window window = this.getLookupWindow();
            window.setWindowTitle(Msgs.BUNDLE.formatMessage("ui.lui.ttl.multi", new Object[]{selectionCount}));
        }

        @Nonnull
        private Window getLookupWindow() throws IllegalStateException {
            LookupForm lookupForm = this.getLookupForm();
            if (lookupForm != null) {
                return lookupForm.getParent(Window.class);
            }
            throw new IllegalStateException("Lookup form not found where expected");
        }

        @Override
        void handleSetValue(@Nullable T value) throws Exception {
            if (!this.isPopupShown()) {
                super.handleSetValue(value);
            } else {
                if (value != null) {
                    this.m_isSelectionModel.setInstanceSelected(value, !this.m_isSelectionModel.isSelected(value));
                }
                this.showSelectedCount();
            }
        }
    }
}

