/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.KeyWordPopupRowRenderer;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.SimpleListModel;
import to.etc.domui.dom.css.DisplayType;
import to.etc.domui.dom.css.Overflow;
import to.etc.domui.dom.css.PositionType;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.ILookupTypingListener;
import to.etc.domui.dom.html.Img;
import to.etc.domui.dom.html.Input;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.Span;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class SearchInput<T>
extends Div {
    private static final int MAX_RESULTS = 7;
    @Nonnull
    private final ClassMetaModel m_dataModel;
    @Nonnull
    private final Class<T> m_dataClass;
    private final Object[] m_columns;
    @Nullable
    private IQuery<T> m_handler;
    private Img m_imgWaiting = new Img("THEME/lui-keyword-wait.gif");
    private Div m_pnlSearchPopup;
    private NodeContainer m_resultMessageContainer;
    private int m_lastResultCount = -1;
    private Input m_input = new Input();
    private static final Set<Class<?>> SIMPLECLASSES = new HashSet<Class>(Arrays.asList(String.class, Date.class, Integer.class, Integer.TYPE, Long.class, Long.TYPE));

    public SearchInput(@Nonnull Class<T> clz, Object ... columns) {
        this(null, clz, columns);
    }

    public SearchInput(IQuery<T> handler, @Nonnull Class<T> clz, Object ... columns) {
        this.m_handler = handler;
        this.m_dataClass = clz;
        this.m_columns = columns;
        this.m_dataModel = MetaManager.findClassMeta(clz);
    }

    @Override
    public void createContent() throws Exception {
        this.setCssClass("ui-qsi");
        this.m_imgWaiting.setCssClass("ui-lui-waiting");
        this.m_imgWaiting.setDisplay(DisplayType.NONE);
        this.add(this.m_imgWaiting);
        this.m_input.setCssClass("ui-lui-keyword");
        this.m_input.setMaxLength(40);
        this.m_input.setSize(14);
        this.add(this.m_input);
        this.m_input.setOnLookupTyping(new ILookupTypingListener<NodeBase>(){

            @Override
            public void onLookupTyping(@Nonnull NodeBase component, boolean done) throws Exception {
                SearchInput.this.handleLookupTyping(done);
            }
        });
    }

    private void handleLookupTyping(boolean done) throws Exception {
        String curdata = this.m_input.getRawValue();
        if (curdata.length() == 0) {
            this.showResults(null);
            return;
        }
        IQuery<T> handler = this.m_handler;
        if (done) {
            if (handler != null) {
                handler.onEnter(curdata);
            }
            this.clearResultPopup();
            this.clearResultMessage();
            this.m_input.setRawValue("");
            return;
        }
        List<T> res = null;
        if (handler != null) {
            res = handler.queryFromString(curdata, 7);
        }
        this.showResults(res);
    }

    private void showResults(@Nullable List<T> isl) throws Exception {
        if (null == isl) {
            this.clearResultMessage();
            this.clearResultPopup();
            return;
        }
        int rc = isl.size();
        System.out.println("search: count=" + rc);
        if (rc == 0) {
            if (this.m_lastResultCount == 0) {
                return;
            }
            this.setResultMessage("ui-lui-keyword-no-res", Msgs.BUNDLE.getString("ui.keyword.search.no.match"));
            return;
        }
        if (rc > 7) {
            if (this.m_lastResultCount > 7) {
                return;
            }
            this.setResultMessage("ui-lui-keyword-large", Msgs.BUNDLE.formatMessage("ui.keyword.search.large.match", new Object[]{"7"}));
            return;
        }
        this.clearResultMessage();
        if (this.m_pnlSearchPopup == null) {
            this.m_pnlSearchPopup = new Div();
        } else {
            this.m_pnlSearchPopup.removeAllChildren();
        }
        if (!this.m_pnlSearchPopup.isAttached()) {
            this.add(this.m_pnlSearchPopup);
            this.m_pnlSearchPopup.setCssClass("ui-lui-keyword-popup");
            this.m_pnlSearchPopup.setPosition(PositionType.ABSOLUTE);
            this.m_pnlSearchPopup.setZIndex(10);
        }
        SimpleListModel<T> mdl = new SimpleListModel<T>(isl);
        KeyWordPopupRowRenderer rr = new KeyWordPopupRowRenderer(this.m_dataModel);
        if (SIMPLECLASSES.contains(this.m_dataClass)) {
            rr.addColumns("", new INodeContentRenderer<Object>(){

                @Override
                public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable Object object, @Nullable Object parameters) throws Exception {
                    node.add(String.valueOf(object));
                }
            });
        } else if (this.m_columns != null && this.m_columns.length > 0) {
            rr.addColumns(this.m_columns);
        }
        rr.setRowClicked(new ICellClicked<T>(){

            @Override
            public void cellClicked(@Nonnull NodeBase tr, @Nonnull T val) throws Exception {
                SearchInput.this.handleSelectValueFromPopup(val);
            }
        });
        DataTable<T> tbl = new DataTable<T>(mdl, rr);
        this.m_pnlSearchPopup.add(tbl);
        tbl.setWidth("100%");
        tbl.setOverflow(Overflow.HIDDEN);
        tbl.setPosition(PositionType.RELATIVE);
    }

    private void handleSelectValueFromPopup(T val) throws Exception {
        System.out.println("GOT: " + val);
        if (null != this.m_handler) {
            this.m_handler.onSelect(val);
        }
        this.clearResultMessage();
        this.clearResultPopup();
        this.m_input.setRawValue("");
        this.m_input.setFocus();
    }

    private void clearResultPopup() {
        if (null != this.m_pnlSearchPopup && this.m_pnlSearchPopup.isAttached()) {
            this.m_pnlSearchPopup.remove();
        }
    }

    private void setResultMessage(String css, String text) {
        if (this.m_resultMessageContainer == null) {
            this.m_resultMessageContainer = new Span();
        }
        this.m_resultMessageContainer.setCssClass(css);
        this.m_resultMessageContainer.setText(text);
        if (!this.m_resultMessageContainer.isAttached()) {
            this.add(this.m_resultMessageContainer);
        }
        this.clearResultPopup();
    }

    private void clearResultMessage() {
        if (this.m_resultMessageContainer != null && this.m_resultMessageContainer.isAttached()) {
            this.m_resultMessageContainer.remove();
        }
    }

    public IQuery<T> getHandler() {
        return this.m_handler;
    }

    public void setHandler(IQuery<T> handler) {
        this.m_handler = handler;
    }

    public static interface IQuery<T> {
        public List<T> queryFromString(String var1, int var2) throws Exception;

        public void onSelect(T var1) throws Exception;

        public void onEnter(String var1) throws Exception;
    }
}

