/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import javax.annotation.Nonnull;
import to.etc.domui.component.input.AbstractFloatingLookup;
import to.etc.domui.component.input.IQueryManipulator;
import to.etc.domui.component.layout.IWindowClosed;
import to.etc.domui.component.lookup.LookupForm;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.tbl.DataPager;
import to.etc.domui.component.tbl.DataTable;
import to.etc.domui.component.tbl.ICellClicked;
import to.etc.domui.component.tbl.IQueryHandler;
import to.etc.domui.component.tbl.ITableModel;
import to.etc.domui.component.tbl.SimpleRowRenderer;
import to.etc.domui.component.tbl.SimpleSearchModel;
import to.etc.domui.dom.errors.IErrorMessageListener;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.IValueSelected;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.UrlPage;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.webapp.query.IQContextContainer;
import to.etc.webapp.query.QContextManager;
import to.etc.webapp.query.QCriteria;
import to.etc.webapp.query.QDataContextFactory;

public class SimpleLookup<T>
extends AbstractFloatingLookup<T> {
    private LookupForm<T> m_externalLookupForm;
    DataTable<T> m_result;
    private IQueryManipulator<T> m_queryManipulator;
    private IQueryHandler<T> m_queryHandler;
    private String m_lookupTitle;
    private String[] m_resultColumns;
    private IErrorMessageListener m_customErrorMessageListener;
    private boolean m_allowEmptyQuery;
    private IValueSelected<T> m_onValueSelected;
    private boolean m_renderAsCollapsed;
    private boolean m_usedWithinLookupInput;
    private boolean m_showDefaultSearch;

    public SimpleLookup(Class<T> lookupClass, ClassMetaModel metaModel, String[] resultColumns) {
        this(lookupClass, metaModel);
        this.m_resultColumns = resultColumns;
    }

    public SimpleLookup(Class<T> lookupClass, String[] resultColumns) {
        this(lookupClass, (ClassMetaModel)null);
        this.m_resultColumns = resultColumns;
    }

    public SimpleLookup(Class<T> lookupClass) {
        this(lookupClass, (ClassMetaModel)null);
    }

    public SimpleLookup(Class<T> lookupClass, ClassMetaModel metaModel) {
        super(lookupClass, metaModel);
    }

    @Override
    public void createContent() throws Exception {
        this.setWindowTitle(this.getLookupTitle() == null ? Msgs.BUNDLE.getString("ui.lui.ttl") : this.getLookupTitle());
        super.createContent();
        this.setHeight("90%");
        this.setIcon("THEME/btnFind.png");
        if (this.getTestID() == null) {
            this.setTestID("simpleLookup");
        }
        if (this.m_customErrorMessageListener != null && this.m_customErrorMessageListener instanceof NodeBase) {
            this.setErrorFence();
            this.add((NodeBase)((Object)this.m_customErrorMessageListener));
            DomUtil.getMessageFence(this).addErrorListener(this.m_customErrorMessageListener);
        }
        LookupForm lf = this.getExternalLookupForm() != null ? this.getExternalLookupForm() : new LookupForm(this.getLookupClass(), this.getMetaModel(), new String[0]);
        lf.setCollapsed(this.m_renderAsCollapsed);
        lf.forceRebuild();
        this.add(lf);
        this.setOnClose(new IWindowClosed(){

            @Override
            public void closed(@Nonnull String closeReason) throws Exception {
                SimpleLookup.this.clearGlobalMessage("v.missing.search");
                SimpleLookup.this.m_result = null;
            }
        });
        lf.setClicked(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                SimpleLookup.this.search(b);
            }
        });
        lf.setOnCancel(new IClicked<LookupForm<T>>(){

            @Override
            public void clicked(@Nonnull LookupForm<T> b) throws Exception {
                SimpleLookup.this.closePressed();
            }
        });
        if (this.m_showDefaultSearch) {
            this.search(lf);
        }
    }

    void search(LookupForm<T> lf) throws Exception {
        QCriteria<T> c = lf.getEnteredCriteria();
        if (c == null) {
            return;
        }
        if (this.getQueryManipulator() != null && (c = this.getQueryManipulator().adjustQuery(c)) == null) {
            return;
        }
        this.clearGlobalMessage("v.missing.search");
        if (!lf.hasUserDefinedCriteria() && !this.isAllowEmptyQuery()) {
            this.addGlobalMessage(UIMessage.error(Msgs.BUNDLE, "v.missing.search", new Object[0]));
            return;
        }
        this.clearGlobalMessage();
        this.setTableQuery(c);
    }

    private void setTableQuery(QCriteria<T> qc) {
        SimpleSearchModel<T> model;
        if (this.m_queryHandler == null) {
            QDataContextFactory src = QContextManager.getDataContextFactory((String)"default-context", (IQContextContainer)this.getPage().getConversation());
            model = new SimpleSearchModel<T>(src, qc);
        } else {
            model = new SimpleSearchModel<T>(this.m_queryHandler, qc);
        }
        this.setResultModel(model);
    }

    private void setResultModel(ITableModel<T> model) {
        if (this.m_result == null) {
            SimpleRowRenderer rr = null;
            rr = this.m_resultColumns != null ? new SimpleRowRenderer(this.getLookupClass(), this.getMetaModel(), this.m_resultColumns) : new SimpleRowRenderer(this.getLookupClass(), this.getMetaModel(), new String[0]);
            this.m_result = new DataTable<T>(model, rr);
            this.add(this.m_result);
            this.m_result.setPageSize(20);
            this.m_result.setTableWidth("100%");
            rr.setRowClicked(new ICellClicked<T>(){

                @Override
                public void cellClicked(@Nonnull NodeBase tr, @Nonnull T val) throws Exception {
                    SimpleLookup.this.clearGlobalMessage("v.missing.search");
                    SimpleLookup.this.close();
                    if (SimpleLookup.this.getOnValueSelected() != null) {
                        SimpleLookup.this.getOnValueSelected().valueSelected(val);
                    }
                }
            });
            if (this.isUseStretchedLayout()) {
                this.m_result.setStretchHeight(true);
            }
            DataPager pg = new DataPager(this.m_result);
            this.add(pg);
        } else {
            this.m_result.setModel(model);
        }
        if (this.isUsedWithinLookupInput()) {
            this.m_result.setTestID("resultTableLookupInput");
        } else {
            this.m_result.setTestID("resultTableSimpleLookup");
        }
    }

    @Override
    public void closePressed() throws Exception {
        super.closePressed();
        if (this.getOnValueSelected() != null) {
            this.getOnValueSelected().valueSelected(null);
        }
    }

    public void startLookup(NodeBase parent, IValueSelected<T> callback) {
        this.setOnValueSelected(callback);
        UrlPage body = parent.getPage().getBody();
        body.add(this);
    }

    public IQueryManipulator<T> getQueryManipulator() {
        return this.m_queryManipulator;
    }

    public IQueryHandler<T> getQueryHandler() {
        return this.m_queryHandler;
    }

    public void setQueryHandler(IQueryHandler<T> queryHandler) {
        this.m_queryHandler = queryHandler;
    }

    public String getLookupTitle() {
        return this.m_lookupTitle;
    }

    public void setLookupTitle(String lookupTitle) {
        this.m_lookupTitle = lookupTitle;
    }

    public boolean isAllowEmptyQuery() {
        return this.m_allowEmptyQuery;
    }

    public void setAllowEmptyQuery(boolean allowEmptyQuery) {
        this.m_allowEmptyQuery = allowEmptyQuery;
    }

    public void setQueryManipulator(IQueryManipulator<T> queryManipulator) {
        this.m_queryManipulator = queryManipulator;
    }

    public LookupForm<T> getExternalLookupForm() {
        return this.m_externalLookupForm;
    }

    public void setExternalLookupForm(LookupForm<T> externalLookupForm) {
        this.m_externalLookupForm = externalLookupForm;
    }

    public String[] getResultColumns() {
        return this.m_resultColumns;
    }

    public void setResultColumns(String[] resultColumns) {
        this.m_resultColumns = resultColumns;
    }

    public IErrorMessageListener getCustomErrorMessageListener() {
        return this.m_customErrorMessageListener;
    }

    public void setCustomErrorMessageListener(IErrorMessageListener customErrorMessageListener) {
        this.m_customErrorMessageListener = customErrorMessageListener;
    }

    protected IValueSelected<T> getOnValueSelected() {
        return this.m_onValueSelected;
    }

    private void setOnValueSelected(IValueSelected<T> onValueSelected) {
        this.m_onValueSelected = onValueSelected;
    }

    public boolean isUsedWithinLookupInput() {
        return this.m_usedWithinLookupInput;
    }

    public void setUsedWithinLookupInput(boolean usedWithinLookupInput) {
        this.m_usedWithinLookupInput = usedWithinLookupInput;
    }

    public boolean isRenderAsCollapsed() {
        return this.m_renderAsCollapsed;
    }

    public void setRenderAsCollapsed(boolean renderAsCollapsed) {
        this.m_renderAsCollapsed = renderAsCollapsed;
    }

    public boolean isShowDefaultSearch() {
        return this.m_showDefaultSearch;
    }

    public void setShowDefaultSearch(boolean showDefaultSearch) {
        this.m_showDefaultSearch = showDefaultSearch;
    }
}

