/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.LookupInput;
import to.etc.domui.component.meta.ClassMetaModel;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.impl.DisplayPropertyMetaModel;
import to.etc.domui.component.meta.impl.ExpandedDisplayProperty;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.NodeContainer;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.TR;
import to.etc.domui.dom.html.TableVAlign;
import to.etc.domui.util.INodeContentRenderer;
import to.etc.domui.util.Msgs;

public class SimpleLookupInputRenderer<T>
implements INodeContentRenderer<T> {
    private INodeContentRenderer<T> m_beforeRenderer;
    private INodeContentRenderer<T> m_afterRenderer;

    @Override
    public void renderNodeContent(@Nonnull NodeBase component, @Nonnull NodeContainer node, @Nullable T object, @Nullable Object parameters) throws Exception {
        String txt;
        TBody tbl = ((LookupInput)node).getBody();
        if (this.getBeforeRenderer() != null) {
            TD cell = new TD();
            this.getBeforeRenderer().renderNodeContent(component, cell, object, parameters);
            if (cell.getChildCount() != 0) {
                tbl.addRow().add(cell);
            }
        }
        if (object != null) {
            ClassMetaModel cmm = MetaManager.findClassMeta(object.getClass());
            if (cmm != null) {
                List<DisplayPropertyMetaModel> l = cmm.getTableDisplayProperties();
                if (l.size() == 0) {
                    l = cmm.getComboDisplayProperties();
                }
                if (l.size() > 0) {
                    List<ExpandedDisplayProperty<?>> xpl = ExpandedDisplayProperty.expandDisplayProperties(l, cmm, null);
                    xpl = ExpandedDisplayProperty.flatten(xpl);
                    tbl.setCssClass("ui-lui-v");
                    int c = 0;
                    int mw = 0;
                    for (ExpandedDisplayProperty<?> xp : xpl) {
                        String val = xp.getPresentationString(object);
                        if (val == null || val.length() == 0) continue;
                        TR tr = new TR();
                        tbl.add(tr);
                        TD td = new TD();
                        tr.add(td);
                        td.setCssClass("ui-lui-vcell");
                        td.setValign(TableVAlign.TOP);
                        td.add(val);
                        int len = val.length();
                        if (len > mw) {
                            mw = len;
                        }
                        td = new TD();
                        tr.add(td);
                        td.setValign(TableVAlign.TOP);
                        td.setCssClass("ui-lui-btncell");
                        td.setWidth("1%");
                        if (c++ != 0 || parameters == null) continue;
                        td.add((NodeBase)parameters);
                    }
                    if ((mw += 4) > 40) {
                        mw = 40;
                    }
                    tbl.setWidth(mw + "em");
                    return;
                }
            }
            txt = object.toString();
        } else {
            txt = Msgs.BUNDLE.getString("ui.lookup.empty");
        }
        TR r = new TR();
        tbl.add(r);
        TD td = new TD();
        r.add(td);
        td.setValign(TableVAlign.TOP);
        td.setCssClass("ui-lui-v");
        td.add(txt);
        if (parameters != null) {
            td = new TD();
            r.add(td);
            td.setValign(TableVAlign.TOP);
            td.setWidth("1%");
            td.add((NodeBase)parameters);
        }
        if (this.getAfterRenderer() != null) {
            TD cell = new TD();
            this.getAfterRenderer().renderNodeContent(component, cell, object, parameters);
            if (cell.getChildCount() != 0) {
                tbl.addRow().add(cell);
            }
        }
    }

    public INodeContentRenderer<T> getBeforeRenderer() {
        return this.m_beforeRenderer;
    }

    public void setBeforeRenderer(INodeContentRenderer<T> beforeContent) {
        this.m_beforeRenderer = beforeContent;
    }

    public INodeContentRenderer<T> getAfterRenderer() {
        return this.m_afterRenderer;
    }

    public void setAfterRenderer(INodeContentRenderer<T> afterContent) {
        this.m_afterRenderer = afterContent;
    }
}

