/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.input;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.input.ITypedControl;
import to.etc.domui.component.meta.MetaManager;
import to.etc.domui.component.meta.NumericPresentation;
import to.etc.domui.component.meta.PropertyMetaModel;
import to.etc.domui.component.meta.PropertyMetaValidator;
import to.etc.domui.component.meta.impl.MetaPropertyValidatorImpl;
import to.etc.domui.converter.ConverterRegistry;
import to.etc.domui.converter.IConvertable;
import to.etc.domui.converter.IConverter;
import to.etc.domui.converter.IValueValidator;
import to.etc.domui.converter.MaxMinValidator;
import to.etc.domui.converter.MoneyUtil;
import to.etc.domui.converter.NumericUtil;
import to.etc.domui.converter.ValidatorRegistry;
import to.etc.domui.dom.css.TextAlign;
import to.etc.domui.dom.errors.UIMessage;
import to.etc.domui.dom.html.IControl;
import to.etc.domui.dom.html.IHasModifiedIndication;
import to.etc.domui.dom.html.Input;
import to.etc.domui.parts.MarkerImagePart;
import to.etc.domui.trouble.UIException;
import to.etc.domui.trouble.ValidationException;
import to.etc.domui.util.DomUtil;
import to.etc.domui.util.Msgs;
import to.etc.util.RuntimeConversionException;
import to.etc.util.RuntimeConversions;
import to.etc.webapp.nls.NlsContext;

public class Text<T>
extends Input
implements IControl<T>,
IHasModifiedIndication,
IConvertable<T>,
ITypedControl<T> {
    @Nonnull
    private Class<T> m_inputClass;
    private IConverter<T> m_converter;
    private List<IValueValidator<?>> m_validators = Collections.EMPTY_LIST;
    private T m_value;
    private boolean m_validated;
    private UIException m_validationResult;
    private boolean m_mandatory;
    private boolean m_untrimmed;
    private String m_emptyMarker;
    @Nonnull
    private NumberMode m_numberMode = NumberMode.NONE;
    private boolean m_modifiedByUser;
    private String m_validationRegexp;
    private String m_regexpUserString;
    @Nullable
    private String m_errclass;

    public Text(@Nonnull Class<T> inputClass) {
        this.m_inputClass = inputClass;
        NumberMode nm = NumberMode.NONE;
        if (BigDecimal.class.isAssignableFrom(inputClass) || DomUtil.isRealType(inputClass)) {
            nm = NumberMode.FLOAT;
        } else if (DomUtil.isIntegerType(inputClass)) {
            nm = NumberMode.DIGITS;
        }
        this.setNumberMode(nm);
    }

    @Override
    public boolean acceptRequestParameter(@Nonnull String[] values) {
        String newTrimmed;
        String oldValue = this.getRawValue();
        super.acceptRequestParameter(values);
        String oldTrimmed = oldValue == null ? "" : oldValue.trim();
        String string = newTrimmed = this.getRawValue() == null ? "" : this.getRawValue().trim();
        if (oldTrimmed.equals(newTrimmed)) {
            return false;
        }
        this.m_validated = false;
        DomUtil.setModifiedFlag(this);
        return true;
    }

    private void validate(boolean clearvalidate) {
        UIException result = this.m_validationResult;
        if (this.m_validated) {
            if (null == result) {
                return;
            }
            throw result;
        }
        try {
            this.m_validated = true;
            this.validatePrimitive();
            if (clearvalidate) {
                this.clearValidationFailure(result);
            }
            this.m_validationResult = null;
        }
        catch (ValidationException vx) {
            this.m_validationResult = vx;
            throw vx;
        }
    }

    private void validatePrimitive() {
        String raw = this.getRawValue();
        if (raw != null && !this.m_untrimmed) {
            raw = raw.trim();
        }
        if (raw == null || raw.length() == 0) {
            if (this.isMandatory()) {
                throw new ValidationException("ui.mandatory", new Object[0]);
            }
            this.m_value = null;
            return;
        }
        if (this.getValidationRegexp() != null && !Pattern.matches(this.getValidationRegexp(), raw)) {
            if (this.getRegexpUserString() != null) {
                throw new ValidationException("v.no.re.match", this.getRegexpUserString());
            }
            throw new ValidationException("v.invalid", new Object[0]);
        }
        try {
            IConverter<T> c = this.m_converter;
            if (c == null) {
                c = ConverterRegistry.findConverter(this.getActualType());
            }
            Object converted = c != null ? c.convertStringToObject(NlsContext.getLocale(), raw) : RuntimeConversions.convertTo((Object)raw, this.m_inputClass);
            for (IValueValidator<?> vv : this.m_validators) {
                vv.validate(converted);
            }
            this.m_value = converted;
        }
        catch (UIException x) {
            throw new ValidationException(x.getBundle(), x.getCode(), x.getParameters());
        }
        catch (RuntimeConversionException x) {
            throw new ValidationException("ui.invalid", raw);
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new ValidationException("ui.unexpected_exception", x);
        }
    }

    private void handleValidationException(@Nullable ValidationException x) {
        UIMessage message = null;
        if (null != x) {
            message = UIMessage.error(x);
        }
        this.setMessage(message);
        this.messageNotifier(message);
    }

    private void messageNotifier(@Nullable UIMessage msg) {
        String errclass = this.m_errclass;
        if (errclass != null) {
            this.removeCssClass(errclass);
            this.m_errclass = null;
            this.setTitle("");
        }
        if (null != msg) {
            errclass = this.m_errclass = "ui-text-" + msg.getType().name().toLowerCase();
            this.addCssClass(errclass);
            this.setTitle(msg.getMessage());
        }
    }

    @Override
    @Nonnull
    public Class<T> getActualType() {
        return this.m_inputClass;
    }

    @Override
    public IConverter<T> getConverter() {
        return this.m_converter;
    }

    @Override
    public void setConverter(IConverter<T> converter) {
        this.m_converter = converter;
        if (this.m_numberMode != NumberMode.NONE && converter != null) {
            this.m_numberMode = NumberMode.NONE;
            this.setOnKeyPressJS(null);
        }
    }

    public T getBindValue() {
        this.validate(false);
        return this.m_value;
    }

    public void setBindValue(@Nullable T value) {
        if (MetaManager.areObjectsEqual(this.m_value, value)) {
            return;
        }
        this.setValue(value);
    }

    @Override
    public T getValue() {
        try {
            this.validate(true);
            return this.m_value;
        }
        catch (ValidationException x) {
            this.handleValidationException(x);
            throw x;
        }
    }

    @Override
    public void clearMessage() {
        super.clearMessage();
        this.m_validated = false;
    }

    @Override
    public T getValueSafe() {
        return DomUtil.getValueSafe(this);
    }

    @Override
    public boolean hasError() {
        this.getValueSafe();
        return super.hasError();
    }

    @Override
    public void setValue(@Nullable T value) {
        String converted;
        this.m_value = value;
        try {
            IConverter<T> c = this.m_converter;
            if (c == null) {
                c = ConverterRegistry.findConverter(this.getActualType());
            }
            converted = c != null ? c.convertObjectToString(NlsContext.getLocale(), value) : (String)RuntimeConversions.convertTo(value, String.class);
        }
        catch (UIException x) {
            this.setMessage(UIMessage.error(x.getBundle(), x.getCode(), x.getParameters()));
            return;
        }
        catch (Exception x) {
            x.printStackTrace();
            this.setMessage(UIMessage.error(Msgs.BUNDLE, "ui.unexpected_exception", x));
            return;
        }
        this.setRawValue(converted == null ? "" : converted);
        this.clearMessage();
        if ((converted == null || converted.trim().length() == 0) && this.isMandatory()) {
            this.m_validated = false;
        } else {
            this.m_validated = true;
            this.m_validationResult = null;
        }
    }

    @Override
    public boolean isMandatory() {
        return this.m_mandatory;
    }

    @Override
    public void setMandatory(boolean mandatory) {
        if (mandatory && !this.m_mandatory) {
            this.m_validated = false;
        }
        this.m_mandatory = mandatory;
    }

    public boolean isUntrimmed() {
        return this.m_untrimmed;
    }

    public void setUntrimmed(boolean untrimmed) {
        this.m_untrimmed = untrimmed;
    }

    private void setEmptyMarker(String emptyMarker) {
        if (DomUtil.isBlank(emptyMarker)) {
            this.setSpecialAttribute("marker", null);
        } else {
            this.setSpecialAttribute("marker", emptyMarker);
        }
        this.m_emptyMarker = emptyMarker;
    }

    public String getEmptyMarker() {
        return this.m_emptyMarker;
    }

    public void setMarkerImage(String emptyMarker) {
        if (DomUtil.isBlank(emptyMarker)) {
            this.setSpecialAttribute("marker", null);
        } else {
            this.setSpecialAttribute("marker", emptyMarker);
        }
        this.m_emptyMarker = emptyMarker;
    }

    public String getMarkerImage() {
        return this.m_emptyMarker;
    }

    public void setMarker() {
        this.setMarkerImage(MarkerImagePart.getBackgroundIconOnly());
    }

    public void setMarker(String iconUrl) {
        this.setMarkerImage(MarkerImagePart.getBackgroundIconOnly(iconUrl));
    }

    public void setMarkerText(String caption) {
        this.setMarkerImage(MarkerImagePart.getBackgroundImage(caption));
    }

    public void setMarker(String iconUrl, String caption) {
        this.setMarkerImage(MarkerImagePart.getBackgroundImage(iconUrl, caption));
    }

    @Nonnull
    public NumberMode getNumberMode() {
        return this.m_numberMode;
    }

    public void setNumberMode(@Nonnull NumberMode numberMode) {
        this.m_numberMode = numberMode;
        switch (numberMode) {
            default: {
                throw new IllegalStateException((Object)((Object)numberMode) + "?");
            }
            case NONE: {
                this.setOnKeyPressJS("");
                break;
            }
            case DIGITS: {
                this.setOnKeyPressJS("WebUI.isNumberKey(event)");
                break;
            }
            case FLOAT: {
                this.setOnKeyPressJS("WebUI.isFloatKey(event)");
            }
        }
    }

    public void addValidator(IValueValidator<?> v) {
        if (this.m_validators == Collections.EMPTY_LIST) {
            this.m_validators = new ArrayList(5);
        }
        this.m_validators.add(v);
    }

    public void addValidator(PropertyMetaValidator v) {
        IValueValidator vi = ValidatorRegistry.getValueValidator(v.getValidatorClass(), v.getParameters());
        this.addValidator(vi);
    }

    public void addValidator(Class<? extends IValueValidator<T>> clz) {
        IValueValidator vi = ValidatorRegistry.getValueValidator(clz, null);
        this.addValidator(vi);
    }

    public void addValidator(Class<? extends IValueValidator<T>> clz, String[] parameters) {
        this.addValidator(new MetaPropertyValidatorImpl(clz, parameters));
    }

    public String getValidationRegexp() {
        return this.m_validationRegexp;
    }

    public void setValidationRegexp(String validationRegexp) {
        this.m_validationRegexp = validationRegexp;
    }

    public String getRegexpUserString() {
        return this.m_regexpUserString;
    }

    public void setRegexpUserString(String regexpUserString) {
        this.m_regexpUserString = regexpUserString;
    }

    @Override
    public boolean isModified() {
        return this.m_modifiedByUser;
    }

    @Override
    public void setModified(boolean as) {
        this.m_modifiedByUser = as;
    }

    public static final void assignPrecisionValidator(@Nonnull Text<?> control, @Nonnull PropertyMetaModel<?> pmm) {
        Text.assignPrecisionValidator(control, pmm.getPrecision(), pmm.getScale());
    }

    public static final void assignPrecisionValidator(@Nonnull Text<?> control, int precision, int scale) {
        if (precision > 0) {
            int d = precision;
            if (scale > 0) {
                d -= scale;
            }
            if (d < 0) {
                return;
            }
            BigDecimal bd = BigDecimal.valueOf(10L);
            bd = bd.pow(d);
            BigDecimal fraction = BigDecimal.ONE.divide(BigDecimal.TEN.pow(scale));
            bd = bd.subtract(fraction);
            control.addValidator(new MaxMinValidator(bd.negate(), bd));
        }
    }

    @Nonnull
    public static Text<Double> createDoubleMoneyInput(@Nonnull Class<?> clz, @Nonnull String property, boolean editable) {
        return Text.createDoubleMoneyInput(MetaManager.getPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static Text<BigDecimal> createBDMoneyInput(Class<?> clz, String property, boolean editable) {
        return Text.createBDMoneyInput(MetaManager.findPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static Text<BigDecimal> createBDMoneyInput(PropertyMetaModel<BigDecimal> pmm, boolean editable) {
        if (pmm == null) {
            throw new NullPointerException("Null property model not allowed");
        }
        Text<BigDecimal> txt = new Text<BigDecimal>(BigDecimal.class);
        Text.configureNumericInput(txt, pmm, editable);
        MoneyUtil.assignMonetaryConverter(pmm, editable, txt);
        return txt;
    }

    @Nonnull
    public static Text<Double> createDoubleMoneyInput(@Nonnull PropertyMetaModel<Double> pmm, boolean editable) {
        if (pmm == null) {
            throw new NullPointerException("Null property model not allowed");
        }
        Text<Double> txt = new Text<Double>(Double.class);
        Text.configureNumericInput(txt, pmm, editable);
        MoneyUtil.assignMonetaryConverter(pmm, editable, txt);
        return txt;
    }

    public static void configureNumericInput(@Nonnull Text<?> txt, @Nonnull PropertyMetaModel<?> pmm, boolean editable) {
        String s;
        if (!editable) {
            txt.setReadOnly(true);
        }
        if (pmm.getDisplayLength() > 0) {
            txt.setSize(pmm.getDisplayLength());
        } else if (pmm.getPrecision() > 0) {
            int size = pmm.getPrecision();
            int d = size++;
            if (pmm.getScale() > 0 && (d -= pmm.getScale()) >= 4) {
                int nd = (d - 1) / 3;
                size += nd;
            }
            txt.setSize(size);
        } else if (pmm.getLength() > 0) {
            txt.setSize(pmm.getLength() < 40 ? pmm.getLength() : 40);
        }
        Text.assignPrecisionValidator(txt, pmm);
        if (pmm.getLength() > 0) {
            txt.setMaxLength(pmm.getLength());
        }
        if (pmm.isRequired()) {
            txt.setMandatory(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            txt.setTitle(s);
        }
        for (PropertyMetaValidator mpv : pmm.getValidators()) {
            txt.addValidator(mpv);
        }
        txt.setTextAlign(TextAlign.RIGHT);
    }

    @Nonnull
    public static <T extends Number> Text<T> createNumericInput(PropertyMetaModel<T> pmm, boolean editable) {
        if (pmm == null) {
            throw new NullPointerException("Null property model not allowed");
        }
        Text<T> txt = new Text<T>(pmm.getActualType());
        Text.configureNumericInput(txt, pmm, editable);
        NumericUtil.assignNumericConverter(pmm, editable, txt, pmm.getActualType());
        return txt;
    }

    @Nonnull
    public static Text<Integer> createIntInput(Class<?> clz, String property, boolean editable) {
        return Text.createNumericInput(MetaManager.findPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static Text<Long> createLongInput(Class<?> clz, String property, boolean editable) {
        return Text.createNumericInput(MetaManager.findPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static Text<Double> createDoubleInput(Class<?> clz, String property, boolean editable) {
        return Text.createNumericInput(MetaManager.findPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static Text<BigDecimal> createBigDecimalInput(Class<?> clz, String property, boolean editable) {
        return Text.createNumericInput(MetaManager.findPropertyMeta(clz, property), editable);
    }

    @Nonnull
    public static <T> Text<?> createText(Class<?> clz, String property, boolean editable) {
        PropertyMetaModel<?> pmm = MetaManager.getPropertyMeta(clz, property);
        return Text.createText(pmm.getActualType(), pmm, editable);
    }

    @Nonnull
    public static <T> Text<T> createText(Class<T> iclz, PropertyMetaModel<T> pmm, boolean editable) {
        return Text.createText(iclz, pmm, editable, false);
    }

    @Nonnull
    public static <T> Text<T> createText(Class<T> iclz, PropertyMetaModel<T> pmm, boolean editable, boolean setDefaultErrorLocation) {
        String s;
        Class<T> aclz = pmm.getActualType();
        if (!iclz.isAssignableFrom(aclz)) {
            throw new IllegalStateException("Invalid class type=" + iclz + " for property " + pmm);
        }
        Text<T> txt = new Text<T>(iclz);
        if (!editable) {
            txt.setReadOnly(true);
        }
        if (pmm.getConverter() != null) {
            txt.setConverter(pmm.getConverter());
        }
        if (pmm.isRequired()) {
            txt.setMandatory(true);
        }
        if ((s = pmm.getDefaultHint()) != null) {
            txt.setTitle(s);
        }
        for (PropertyMetaValidator mpv : pmm.getValidators()) {
            txt.addValidator(mpv);
        }
        txt.setRegexpUserString(pmm.getRegexpUserString());
        txt.setValidationRegexp(pmm.getRegexpValidator());
        int calcmaxsz = -1;
        int calcsz = -1;
        if (pmm.getPrecision() > 0) {
            int size;
            Text.assignPrecisionValidator(txt, pmm);
            int d = size = pmm.getPrecision();
            String hint = pmm.getComponentTypeHint();
            if (hint != null) {
                hint = hint.toLowerCase();
            }
            if (hint == null || !hint.contains("no-minus")) {
                ++size;
            }
            if (hint == null || !hint.contains("no-separator")) {
                if (pmm.getScale() > 0) {
                    ++size;
                    if ((d -= pmm.getScale()) >= 4) {
                        int nd = (d - 1) / 3;
                        size += nd;
                    }
                } else if (d >= 4) {
                    int nd = (d - 1) / 3;
                    size += nd;
                }
            }
            if (NumericPresentation.isMonetary(pmm.getNumericPresentation())) {
                size += 2;
            }
            calcsz = size;
            calcmaxsz = size;
        } else if (NumericPresentation.isMonetary(pmm.getNumericPresentation())) {
            calcsz = 18;
            calcmaxsz = 30;
        }
        if (pmm.getDisplayLength() > 0) {
            calcsz = pmm.getDisplayLength();
        }
        if (pmm.getLength() > 0 && pmm.getLength() != 255 && pmm.getConverter() == null) {
            calcmaxsz = pmm.getLength();
            if (calcsz <= 0 && calcmaxsz < 40) {
                calcsz = calcmaxsz;
            }
        }
        if (calcmaxsz > 0) {
            txt.setMaxLength(calcmaxsz);
        }
        if (calcsz <= 0) {
            calcsz = calcmaxsz <= 0 || calcmaxsz > 40 ? 40 : calcmaxsz;
        }
        txt.setSize(calcsz);
        if (setDefaultErrorLocation) {
            txt.setErrorLocation(pmm.getDefaultLabel());
        }
        return txt;
    }

    private void renderMode() {
        switch (this.m_numberMode) {
            default: {
                break;
            }
            case DIGITS: {
                this.setOnKeyPressJS("WebUI.isNumberKey(event)");
                break;
            }
            case FLOAT: {
                this.setOnKeyPressJS("WebUI.isFloatKey(event)");
            }
        }
    }

    @Override
    public void createContent() throws Exception {
        super.createContent();
        this.renderMode();
    }

    public static void main(String[] args) {
        BigDecimal fraction = BigDecimal.ONE.divide(BigDecimal.TEN.pow(0));
        System.out.println("pow " + fraction);
    }

    public static enum NumberMode {
        NONE,
        DIGITS,
        FLOAT;

    }
}

