/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import to.etc.domui.dom.header.HeaderContributor;
import to.etc.domui.dom.html.Div;
import to.etc.domui.dom.html.Page;

public class BorderLayoutPanel
extends Div {
    private final Map<Panel, Div> m_panelMap = new HashMap<Panel, Div>();

    public BorderLayoutPanel() {
        this.select(Panel.CENTER);
        this.setCssClass("ui-blap");
    }

    public void select(@Nonnull Panel p) {
        if (null == p) {
            throw new IllegalArgumentException("null not allowed");
        }
        this.delegateTo(null);
        Div m = this.m_panelMap.get((Object)p);
        if (null == m) {
            m = new Div();
            m.setCssClass("ui-layout-" + p.name().toLowerCase());
            this.m_panelMap.put(p, m);
            this.add(m);
        }
        this.delegateTo(m);
    }

    @Override
    protected void onForceRebuild() {
        this.select(Panel.CENTER);
    }

    @Override
    public void createContent() throws Exception {
    }

    @Override
    protected void afterCreateContent() throws Exception {
        super.afterCreateContent();
        if (this.m_panelMap.size() != 1) {
            this.appendCreateJS("$('#" + this.getActualID() + "').layout();");
        }
    }

    @Override
    public void onAddedToPage(Page p) {
        this.getPage().addHeaderContributor(HeaderContributor.loadJavascript("$js/jquery.layout.js"), 101);
    }

    public static enum Panel {
        NORTH,
        SOUTH,
        WEST,
        EAST,
        CENTER;

    }
}

