/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.layout.ButtonFactory;
import to.etc.domui.component.layout.IButtonBar;
import to.etc.domui.component.layout.IButtonContainer;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.dom.html.TBody;
import to.etc.domui.dom.html.TD;
import to.etc.domui.dom.html.Table;

public class ButtonBar
extends Table
implements IButtonBar,
IButtonContainer {
    private boolean m_vertical;
    private TD m_center;
    private TBody m_body;
    @Nullable
    private TD m_right;
    @Nonnull
    private final ButtonFactory m_factory = new ButtonFactory(this);
    private List<NodeBase> m_list = new ArrayList<NodeBase>();

    public ButtonBar() {
        this.setCssClass("ui-buttonbar");
        this.setCellSpacing("0");
        this.setCellPadding("0");
        this.setTableWidth("100%");
    }

    public ButtonBar(boolean vertical) {
        this();
        this.m_vertical = vertical;
    }

    @Override
    public void createContent() throws Exception {
        this.m_body = new TBody();
        this.add(this.m_body);
        if (this.m_vertical) {
            this.createVertical();
        } else {
            this.createHorizontal();
        }
        for (NodeBase b : this.m_list) {
            this.appendObject(b);
        }
    }

    private void appendObject(NodeBase b) {
        if (this.m_vertical) {
            this.appendVertical(b);
        } else {
            this.appendHorizontal(b);
        }
    }

    private void appendHorizontal(NodeBase b) {
        this.m_center.add(b);
    }

    private void appendVertical(NodeBase b) {
        TD td = this.m_body.addRowAndCell();
        td.add(b);
    }

    private void createVertical() {
    }

    private void createHorizontal() {
        this.m_body.addRow();
        this.m_center = this.m_body.addCell();
        this.m_center.setCssClass("ui-bb-middle");
    }

    @Override
    public void addButton(@Nonnull NodeBase b, int order) {
        this.m_list.add(b);
        if (this.isBuilt()) {
            this.appendObject(b);
        }
    }

    public void clearButtons() {
        this.m_list.clear();
        this.forceRebuild();
    }

    public TD right() throws Exception {
        this.build();
        TD right = this.m_right;
        if (null == right) {
            this.m_right = right = this.m_body.addCell();
        }
        return right;
    }

    public TD buttonTD() throws Exception {
        this.build();
        return this.m_center;
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, String icon, IClicked<DefaultButton> click, int order) {
        return this.m_factory.addButton(txt, icon, click, order);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, String icon, IClicked<DefaultButton> click) {
        return this.m_factory.addButton(txt, icon, click);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(@Nonnull IUIAction<Void> action, int order) throws Exception {
        return this.m_factory.addButton(action, order);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(@Nonnull IUIAction<Void> action) throws Exception {
        return this.m_factory.addButton(action);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, IClicked<DefaultButton> click, int order) {
        return this.m_factory.addButton(txt, click, order);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, IClicked<DefaultButton> click) {
        return this.m_factory.addButton(txt, click);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(String txt, String icon, int order) {
        return this.m_factory.addBackButton(txt, icon, order);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(String txt, String icon) {
        return this.m_factory.addBackButton(txt, icon);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(int order) {
        return this.m_factory.addBackButton(order);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton() {
        return this.m_factory.addBackButton();
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(@Nonnull String txt, @Nonnull String icon, int order) {
        return this.m_factory.addCloseButton(txt, icon, order);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(@Nonnull String txt, @Nonnull String icon) {
        return this.m_factory.addCloseButton(txt, icon);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(int order) {
        return this.m_factory.addCloseButton(order);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton() {
        return this.m_factory.addCloseButton();
    }

    @Override
    public DefaultButton addBackButtonConditional(int order) {
        return this.m_factory.addBackButtonConditional(order);
    }

    @Override
    public DefaultButton addBackButtonConditional() {
        return this.m_factory.addBackButtonConditional();
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String msg, IClicked<DefaultButton> click, int order) {
        return this.m_factory.addConfirmedButton(txt, msg, click, order);
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String msg, IClicked<DefaultButton> click) {
        return this.m_factory.addConfirmedButton(txt, msg, click);
    }

    @Override
    public DefaultButton addConfirmedButton(String txt, String icon, String msg, IClicked<DefaultButton> click, int order) {
        return this.m_factory.addConfirmedButton(txt, icon, msg, click, order);
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String icon, String msg, IClicked<DefaultButton> click) {
        return this.m_factory.addConfirmedButton(txt, icon, msg, click);
    }

    @Override
    @Nonnull
    public LinkButton addLinkButton(String txt, String img, IClicked<LinkButton> click, int order) {
        return this.m_factory.addLinkButton(txt, img, click, order);
    }

    @Override
    @Nonnull
    public LinkButton addLinkButton(String txt, String img, IClicked<LinkButton> click) {
        return this.m_factory.addLinkButton(txt, img, click);
    }

    public LinkButton addConfirmedLinkButton(String txt, String img, String msg, IClicked<LinkButton> click, int order) {
        return this.m_factory.addConfirmedLinkButton(txt, img, msg, click, order);
    }

    public LinkButton addConfirmedLinkButton(String txt, String img, String msg, IClicked<LinkButton> click) {
        return this.m_factory.addConfirmedLinkButton(txt, img, msg, click);
    }

    @Override
    @Nonnull
    public <T> DefaultButton addAction(T instance, IUIAction<T> action, int order) throws Exception {
        return this.m_factory.addAction(instance, action, order);
    }

    @Override
    @Nonnull
    public <T> DefaultButton addAction(T instance, IUIAction<T> action) throws Exception {
        return this.m_factory.addAction(instance, action);
    }

    public void addButton(@Nonnull NodeBase b) {
        this.addButton(b, -1);
    }

    @Nonnull
    public ButtonFactory getButtonFactory() {
        return this.m_factory;
    }
}

