/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.layout.IButtonBar;
import to.etc.domui.component.layout.IButtonContainer;
import to.etc.domui.component.menu.IUIAction;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.state.IShelvedEntry;
import to.etc.domui.state.UIGoto;
import to.etc.domui.util.Msgs;

public class ButtonFactory
implements IButtonBar {
    @Nonnull
    private final IButtonContainer m_container;

    public ButtonFactory(@Nonnull IButtonContainer container) {
        this.m_container = container;
    }

    public void addButton(@Nonnull NodeBase button, int order) {
        this.m_container.addButton(button, order);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, String icon, IClicked<DefaultButton> click, int order) {
        DefaultButton b = new DefaultButton(txt, icon, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, String icon, IClicked<DefaultButton> click) {
        return this.addButton(txt, icon, click, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(@Nonnull IUIAction<Void> action, int order) throws Exception {
        DefaultButton b = new DefaultButton(action);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addButton(@Nonnull IUIAction<Void> action) throws Exception {
        return this.addButton(action, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, IClicked<DefaultButton> click, int order) {
        DefaultButton b = new DefaultButton(txt, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addButton(String txt, IClicked<DefaultButton> click) {
        return this.addButton(txt, click, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(String txt, String icon, int order) {
        DefaultButton b = new DefaultButton(txt, icon, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton bxx) throws Exception {
                UIGoto.back();
            }
        });
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(String txt, String icon) {
        return this.addBackButton(txt, icon, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton(int order) {
        List<IShelvedEntry> ps = this.m_container.getPage().getConversation().getWindowSession().getShelvedPageStack();
        if (ps.size() > 1) {
            IShelvedEntry se = ps.get(ps.size() - 2);
            if (se.isClose()) {
                return this.addCloseButton(order);
            }
        } else {
            return this.addCloseButton(order);
        }
        return this.addBackButton(Msgs.BUNDLE.getString("ui.buttonbar.back"), "THEME/btnCancel.png", order);
    }

    @Override
    @Nonnull
    public DefaultButton addBackButton() {
        return this.addBackButton(-1);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(@Nonnull String txt, @Nonnull String icon, int order) {
        DefaultButton b = new DefaultButton(txt, icon, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton clickednode) throws Exception {
                ButtonFactory.this.m_container.getPage().getBody().closeWindow();
            }
        });
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(@Nonnull String txt, @Nonnull String icon) {
        return this.addCloseButton(txt, icon, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton(int order) {
        return this.addCloseButton(Msgs.BUNDLE.getString("ui.buttonbar.close"), "THEME/btnClose.png", order);
    }

    @Override
    @Nonnull
    public DefaultButton addCloseButton() {
        return this.addCloseButton(-1);
    }

    @Override
    @Nullable
    public DefaultButton addBackButtonConditional(int order) {
        List<IShelvedEntry> ps = this.m_container.getPage().getConversation().getWindowSession().getShelvedPageStack();
        if (ps.size() <= 1) {
            return null;
        }
        IShelvedEntry se = ps.get(ps.size() - 2);
        if (se.isClose()) {
            return this.addCloseButton(order);
        }
        return this.addBackButton(order);
    }

    @Override
    @Nullable
    public DefaultButton addBackButtonConditional() {
        return this.addBackButtonConditional(-1);
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String msg, IClicked<DefaultButton> click, int order) {
        DefaultButton b = MsgBox.areYouSureButton(txt, msg, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String msg, IClicked<DefaultButton> click) {
        return this.addConfirmedButton(txt, msg, click, -1);
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String icon, String msg, IClicked<DefaultButton> click, int order) {
        DefaultButton b = MsgBox.areYouSureButton(txt, icon, msg, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public DefaultButton addConfirmedButton(String txt, String icon, String msg, IClicked<DefaultButton> click) {
        return this.addConfirmedButton(txt, icon, msg, click, -1);
    }

    @Override
    @Nonnull
    public LinkButton addLinkButton(String txt, String img, IClicked<LinkButton> click, int order) {
        LinkButton b = new LinkButton(txt, img, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public LinkButton addLinkButton(String txt, String img, IClicked<LinkButton> click) {
        return this.addLinkButton(txt, img, click, -1);
    }

    @Nonnull
    public LinkButton addConfirmedLinkButton(String txt, String img, String msg, IClicked<LinkButton> click, int order) {
        LinkButton b = MsgBox.areYouSureLinkButton(txt, img, msg, click);
        this.m_container.addButton(b, order);
        return b;
    }

    @Nonnull
    public LinkButton addConfirmedLinkButton(String txt, String img, String msg, IClicked<LinkButton> click) {
        return this.addConfirmedLinkButton(txt, img, msg, click, -1);
    }

    @Override
    @Nonnull
    public <T> DefaultButton addAction(T instance, IUIAction<T> action, int order) throws Exception {
        DefaultButton b = new DefaultButton(instance, action);
        this.m_container.addButton(b, order);
        return b;
    }

    @Override
    @Nonnull
    public <T> DefaultButton addAction(T instance, IUIAction<T> action) throws Exception {
        return this.addAction(instance, action, -1);
    }
}

