/*
 * Decompiled with CFR 0.152.
 */
package to.etc.domui.component.layout;

import javax.annotation.Nonnull;
import to.etc.domui.component.buttons.DefaultButton;
import to.etc.domui.component.buttons.LinkButton;
import to.etc.domui.component.misc.MsgBox;
import to.etc.domui.dom.html.IClicked;
import to.etc.domui.dom.html.NodeBase;
import to.etc.domui.state.UIGoto;

public abstract class ButtonMakerBase {
    protected abstract void addButton(NodeBase var1);

    public DefaultButton addButton(String txt, String icon, IClicked<DefaultButton> click) {
        DefaultButton b = new DefaultButton(txt, icon, click);
        this.addButton(b);
        return b;
    }

    public DefaultButton addButton(String txt, IClicked<DefaultButton> click) {
        DefaultButton b = new DefaultButton(txt, click);
        this.addButton(b);
        return b;
    }

    public DefaultButton addBackButton(String txt, String icon) {
        DefaultButton b = new DefaultButton(txt, icon, new IClicked<DefaultButton>(){

            @Override
            public void clicked(@Nonnull DefaultButton bxx) throws Exception {
                UIGoto.back();
            }
        });
        this.addButton(b);
        return b;
    }

    public DefaultButton addBackButton() {
        return this.addBackButton("Terug", "THEME/btnCancel.png");
    }

    public DefaultButton addConfirmedButton(String txt, String msg, IClicked<DefaultButton> click) {
        DefaultButton b = MsgBox.areYouSureButton(txt, msg, click);
        this.addButton(b);
        return b;
    }

    public DefaultButton addConfirmedButton(String txt, String icon, String msg, IClicked<DefaultButton> click) {
        DefaultButton b = MsgBox.areYouSureButton(txt, icon, msg, click);
        this.addButton(b);
        return b;
    }

    public LinkButton addLinkButton(String txt, String img, IClicked<LinkButton> click) {
        LinkButton b = new LinkButton(txt, img, click);
        this.addButton(b);
        return b;
    }

    public LinkButton addConfirmedLinkButton(String txt, String img, String msg, IClicked<LinkButton> click) {
        LinkButton b = MsgBox.areYouSureLinkButton(txt, img, msg, click);
        this.addButton(b);
        return b;
    }
}

